/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.frechet;

import fr.ign.cogit.geoxygene.api.spatial.coordgeom.IDirectPosition;
import fr.ign.cogit.geoxygene.api.spatial.coordgeom.ILineString;
import fr.ign.cogit.geoxygene.distance.Frechet;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;

public class OrthodromicFrechetDistance
extends Frechet {
    private static double discreteFrechetCouplingMeasure(ILineString p, ILineString q, int i, int j, double[][] ca) {
        if (ca[i][j] > -1.0) {
            return ca[i][j];
        }
        IDirectPosition a = p.getControlPoint(i);
        IDirectPosition b = q.getControlPoint(j);
        double d = APointsetsMeasure.pointToPointDistance(new Point(a.getX(), a.getY()), new Point(b.getX(), b.getY()));
        if (i == 0 && j == 0) {
            double d2 = d;
            ca[i][j] = d2;
            return d2;
        }
        if (i > 0 && j == 0) {
            double d3 = Math.max(OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, i - 1, j, ca), d);
            ca[i][j] = d3;
            return d3;
        }
        if (i == 0 && j > 0) {
            double d4 = Math.max(OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, i, j - 1, ca), d);
            ca[i][j] = d4;
            return d4;
        }
        if (i > 0 && j > 0) {
            double d5 = Math.max(Math.min(OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, i - 1, j, ca), Math.min(OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, i - 1, j - 1, ca), OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, i, j - 1, ca))), d);
            ca[i][j] = d5;
            return d5;
        }
        ca[i][j] = Double.POSITIVE_INFINITY;
        return Double.POSITIVE_INFINITY;
    }

    public static double discreteFrechet(ILineString p, ILineString q) {
        int sizeP = p.sizeControlPoint();
        int sizeQ = q.sizeControlPoint();
        double[][] ca = new double[sizeP][sizeQ];
        for (int i = 0; i < sizeP; ++i) {
            for (int j = 0; j < sizeQ; ++j) {
                ca[i][j] = -1.0;
            }
        }
        return OrthodromicFrechetDistance.discreteFrechetCouplingMeasure(p, q, sizeP - 1, sizeQ - 1, ca);
    }
}

