/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.ModelRegistry;
import org.aksw.limes.core.io.query.SparqlQueryModule;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class FileQueryModule
implements IQueryModule {
    KBInfo kb;
    Model model;
    private Logger logger = LoggerFactory.getLogger((String)FileQueryModule.class.getName());

    public FileQueryModule(KBInfo kbinfo) {
        try {
            InputStream in;
            RDFReader r;
            block4: {
                this.kb = kbinfo;
                this.model = ModelFactory.createDefaultModel();
                System.out.println("Trying to get reader " + this.kb.getType());
                r = this.model.getReader(this.kb.getType());
                try {
                    in = new FileInputStream(this.kb.getEndpoint());
                }
                catch (FileNotFoundException e) {
                    in = this.getClass().getClassLoader().getResourceAsStream(this.kb.getEndpoint());
                    if (in != null) break block4;
                    this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "endpoint could not be loaded as a file or resource");
                    return;
                }
            }
            InputStreamReader reader = new InputStreamReader(in, "UTF8");
            r.read(this.model, (Reader)reader, null);
            this.logger.info("RDF model read from " + this.kb.getEndpoint() + " is of size " + this.model.size());
            ModelRegistry.register(this.kb.getEndpoint(), this.model);
            reader.close();
            in.close();
        }
        catch (Exception e) {
            this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "Error loading endpoint", (Throwable)e);
        }
    }

    @Override
    public void fillCache(ACache c) {
        SparqlQueryModule sqm = new SparqlQueryModule(this.kb);
        sqm.fillCache(c, false);
    }
}

