/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.mapping;

import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.FileMapping;
import org.aksw.limes.core.io.mapping.HybridMapping;
import org.aksw.limes.core.io.mapping.MemoryMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)MappingFactory.class.getName());

    public static AMapping createDefaultMapping() {
        return new MemoryMapping();
    }

    public static AMapping createMapping(MappingType type) {
        if (type == MappingType.DEFAULT) {
            return MappingFactory.createDefaultMapping();
        }
        if (type == MappingType.MEMORY_MAPPING) {
            return new MemoryMapping();
        }
        if (type == MappingType.HYBIRD_MAPPING) {
            return new HybridMapping();
        }
        if (type == MappingType.FILE_MAPPING) {
            return new FileMapping();
        }
        logger.warn("Sorry, " + (Object)((Object)type) + " is not yet implemented. Generating " + (Object)((Object)MappingType.DEFAULT) + " map ...");
        return MappingFactory.createDefaultMapping();
    }

    public static enum MappingType {
        DEFAULT,
        MEMORY_MAPPING,
        HYBIRD_MAPPING,
        FILE_MAPPING;

    }
}

