/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluationDataLoader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.evaluation.evaluationDataLoader.EvaluationData;
import org.aksw.limes.core.evaluation.evaluationDataLoader.Experiment;
import org.aksw.limes.core.evaluation.evaluationDataLoader.OAEIMappingParser;
import org.aksw.limes.core.evaluation.evaluationDataLoader.PropMapper;
import org.aksw.limes.core.evaluation.oracle.IOracle;
import org.aksw.limes.core.evaluation.oracle.OracleFactory;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetChooser {
    static Logger logger = LoggerFactory.getLogger(DataSetChooser.class);

    public static EvaluationData getData(String dataSetName) {
        String d = dataSetName.replaceAll("-", "").toUpperCase();
        HashMap<Object, Object> param = new HashMap<MapKey, String>();
        switch (d) {
            case "PERSONNew": {
                param = DataSetChooser.getPersonNew();
                break;
            }
            case "PERSON1": {
                param = DataSetChooser.getPerson1();
                break;
            }
            case "PERSON2": {
                param = DataSetChooser.getPerson2();
                break;
            }
            case "RESTAURANTS": {
                param = DataSetChooser.getRestaurant();
                break;
            }
            case "RESTAURANTSFIXED": {
                param = DataSetChooser.getRestaurant();
                break;
            }
            case "DBLPACM": {
                param = DataSetChooser.getDBLPACM();
                break;
            }
            case "ABTBUY": {
                param = DataSetChooser.getAbtBuy();
                break;
            }
            case "DBLPSCHOLAR": {
                param = DataSetChooser.getDBLPScholar();
                break;
            }
            case "AMAZONGOOGLEPRODUCTS": {
                param = DataSetChooser.getAmazonGoogleProducts();
                break;
            }
            case "DBPLINKEDMDB": {
                param = DataSetChooser.getDBPediaLinkedMDB();
                break;
            }
            case "DRUGS": {
                param = DataSetChooser.getDrugs();
                break;
            }
            case "PERSON1_CSV": {
                param = DataSetChooser.getPerson1CSV();
                break;
            }
            case "PERSON2_CSV": {
                param = DataSetChooser.getPerson2CSV();
                break;
            }
            case "RESTAURANTS_CSV": {
                param = DataSetChooser.getRestaurantCSV();
                break;
            }
            case "OAEI2014BOOKS": {
                param = DataSetChooser.getOAEI2014Books();
            }
        }
        param.put((Object)MapKey.EVALUATION_RESULTS_FOLDER, DataSetChooser.getEvalFolder());
        param.put((Object)MapKey.MAX_RUNS, 5);
        EvaluationData data = EvaluationData.buildFromHashMap(param);
        AMapping fixed = DataSetChooser.fixReferenceMap(data.getReferenceMapping(), data.getSourceCache(), data.getTargetCache());
        if (d.equals("RESTAURANTSFIXED")) {
            data.setReferenceMapping(fixed);
            data.setName("Restaurants_fixed");
        }
        return data;
    }

    public static EvaluationData getData(DataSets a) {
        HashMap<Object, Object> param = new HashMap<MapKey, String>();
        switch (a) {
            case PERSON1: {
                param = DataSetChooser.getPerson1();
                break;
            }
            case PERSON2: {
                param = DataSetChooser.getPerson2();
                break;
            }
            case RESTAURANTS: {
                param = DataSetChooser.getRestaurant();
                break;
            }
            case RESTAURANTS_FIXED: {
                param = DataSetChooser.getRestaurant();
                break;
            }
            case DBLPACM: {
                param = DataSetChooser.getDBLPACM();
                break;
            }
            case ABTBUY: {
                param = DataSetChooser.getAbtBuy();
                break;
            }
            case DBLPSCHOLAR: {
                param = DataSetChooser.getDBLPScholar();
                break;
            }
            case AMAZONGOOGLEPRODUCTS: {
                param = DataSetChooser.getAmazonGoogleProducts();
                break;
            }
            case DBPLINKEDMDB: {
                param = DataSetChooser.getDBPediaLinkedMDB();
                break;
            }
            case DRUGS: {
                param = DataSetChooser.getDrugs();
                break;
            }
            case PERSON1_CSV: {
                param = DataSetChooser.getPerson1CSV();
                break;
            }
            case PERSON2_CSV: {
                param = DataSetChooser.getPerson2CSV();
                break;
            }
            case RESTAURANTS_CSV: {
                param = DataSetChooser.getRestaurantCSV();
                break;
            }
            case OAEI2014BOOKS: {
                param = DataSetChooser.getOAEI2014Books();
            }
        }
        param.put((Object)MapKey.EVALUATION_RESULTS_FOLDER, DataSetChooser.getEvalFolder());
        param.put((Object)MapKey.MAX_RUNS, 5);
        EvaluationData data = EvaluationData.buildFromHashMap(param);
        if (a.equals((Object)DataSets.RESTAURANTS_FIXED)) {
            AMapping fixed = DataSetChooser.fixReferenceMap(data.getReferenceMapping(), data.getSourceCache(), data.getTargetCache());
            data.setReferenceMapping(fixed);
            data.setName("Restaurants_fixed");
        }
        return data;
    }

    private static HashMap<MapKey, Object> getPersonNew() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Persons1/");
        param.put(MapKey.CONFIG_FILE, "personsNew.xml");
        param.put(MapKey.REFERENCE_FILE, "dataset11_dataset12_goldstandard_person.xml");
        param.put(MapKey.SOURCE_FILE, "person11.nt");
        param.put(MapKey.TARGET_FILE, "person12.nt");
        String type = "-Person";
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, DataSetChooser.getEvalFolder());
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Persons1.csv");
        param.put(MapKey.NAME, "Persons1");
        XMLConfigurationReader cR = new XMLConfigurationReader("" + param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.TARGET_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.TARGET_FILE), type));
        param.put(MapKey.REFERENCE_MAPPING, Experiment.readOAEIMapping((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.REFERENCE_FILE)));
        param.put(MapKey.SOURCE_CLASS, "http://www.okkam.org/ontology_person1.owl#Person");
        param.put(MapKey.TARGET_CLASS, "okkamperson2:Person");
        return param;
    }

    private static HashMap<MapKey, Object> getPerson1() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Persons1/");
        param.put(MapKey.CONFIG_FILE, "persons1.xml");
        param.put(MapKey.REFERENCE_FILE, "dataset11_dataset12_goldstandard_person.xml");
        param.put(MapKey.SOURCE_FILE, "person11.nt");
        param.put(MapKey.TARGET_FILE, "person12.nt");
        String type = "-Person";
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, DataSetChooser.getEvalFolder());
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Persons1.csv");
        param.put(MapKey.NAME, "Persons1");
        XMLConfigurationReader cR = new XMLConfigurationReader("" + param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.TARGET_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.TARGET_FILE), type));
        param.put(MapKey.REFERENCE_MAPPING, Experiment.readOAEIMapping((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.REFERENCE_FILE)));
        param.put(MapKey.SOURCE_CLASS, "http://www.okkam.org/ontology_person1.owl#Person");
        param.put(MapKey.TARGET_CLASS, "okkamperson2:Person");
        return param;
    }

    private static HashMap<MapKey, Object> getOAEI2014Books() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/OAEI2014/");
        param.put(MapKey.CONFIG_FILE, "oaei2014_identity.xml");
        param.put(MapKey.REFERENCE_FILE, "oaei2014_identity_mappings.rdf");
        param.put(MapKey.SOURCE_FILE, "oaei2014_identity_a.owl");
        param.put(MapKey.TARGET_FILE, "oaei2014_identity_b.owl");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, DataSetChooser.getEvalFolder());
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_OAEI2014.csv");
        param.put(MapKey.NAME, "OAEI2014");
        XMLConfigurationReader cR = new XMLConfigurationReader("" + param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        OAEIMappingParser mappingParser = new OAEIMappingParser((String)param.get((Object)MapKey.BASE_FOLDER) + (String)param.get((Object)MapKey.REFERENCE_FILE));
        param.put(MapKey.REFERENCE_MAPPING, mappingParser.parseDocument());
        param.put(MapKey.SOURCE_CLASS, "oaei2014:Book");
        param.put(MapKey.TARGET_CLASS, "oaei2014:Book");
        return param;
    }

    private static HashMap<MapKey, Object> getPerson1CSV() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Persons1/");
        param.put(MapKey.CONFIG_FILE, "persons1_csv.xml");
        param.put(MapKey.REFERENCE_FILE, "dataset11_dataset12_goldstandard_person.xml.csv");
        param.put(MapKey.SOURCE_FILE, "person11.nt");
        param.put(MapKey.TARGET_FILE, "person12.nt");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Persons1.csv");
        param.put(MapKey.NAME, "Persons1_CSV");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + (String)param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        HybridCache sC = HybridCache.getData(cR.getConfiguration().getSourceInfo());
        HybridCache tC = HybridCache.getData(cR.getConfiguration().getTargetInfo());
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, sC);
        param.put(MapKey.TARGET_CACHE, tC);
        IOracle o = OracleFactory.getOracle("" + param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "CSV", "simple");
        param.put(MapKey.REFERENCE_MAPPING, o.getMapping());
        return param;
    }

    private static HashMap<MapKey, Object> getPerson2() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Persons2/");
        param.put(MapKey.CONFIG_FILE, "persons2.xml");
        param.put(MapKey.REFERENCE_FILE, "dataset21_dataset22_goldstandard_person.xml");
        param.put(MapKey.SOURCE_FILE, "person21.nt");
        param.put(MapKey.TARGET_FILE, "person22.nt");
        String type = "-Person";
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Persons2.csv");
        param.put(MapKey.NAME, "Persons2");
        XMLConfigurationReader cR = new XMLConfigurationReader("" + param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.TARGET_CACHE, Experiment.readOAEIFile((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.TARGET_FILE), type));
        param.put(MapKey.REFERENCE_MAPPING, Experiment.readOAEIMapping((String)param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.REFERENCE_FILE)));
        param.put(MapKey.SOURCE_CLASS, "http://www.okkam.org/ontology_person1.owl#Person");
        param.put(MapKey.TARGET_CLASS, "okkamperson2:Person");
        return param;
    }

    private static HashMap<MapKey, Object> getPerson2CSV() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Persons2/");
        param.put(MapKey.CONFIG_FILE, "persons2_csv.xml");
        param.put(MapKey.REFERENCE_FILE, "dataset21_dataset22_goldstandard_person.xml.csv");
        param.put(MapKey.SOURCE_FILE, "person21.nt");
        param.put(MapKey.TARGET_FILE, "person22.nt");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Persons2.csv");
        param.put(MapKey.NAME, "Persons2_CSV");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + (String)param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        HybridCache sC = HybridCache.getData(cR.getConfiguration().getSourceInfo());
        HybridCache tC = HybridCache.getData(cR.getConfiguration().getTargetInfo());
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, sC);
        param.put(MapKey.TARGET_CACHE, tC);
        IOracle o = OracleFactory.getOracle("" + param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "CSV", "simple");
        param.put(MapKey.REFERENCE_MAPPING, o.getMapping());
        return param;
    }

    private static HashMap<MapKey, Object> getRestaurant() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Restaurants/");
        param.put(MapKey.CONFIG_FILE, "restaurants.xml");
        param.put(MapKey.REFERENCE_FILE, "restaurant1_restaurant2_goldstandard.rdf");
        param.put(MapKey.SOURCE_FILE, "restaurant1.nt");
        param.put(MapKey.TARGET_FILE, "restaurant2.nt");
        String type = "-Restaurant";
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Restaurants.csv");
        param.put(MapKey.NAME, "Restaurants");
        XMLConfigurationReader cR = new XMLConfigurationReader("" + param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, Experiment.readOAEIFile(param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.SOURCE_FILE), type));
        param.put(MapKey.TARGET_CACHE, Experiment.readOAEIFile(param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.TARGET_FILE), type));
        param.put(MapKey.REFERENCE_MAPPING, Experiment.readOAEIMapping(param.get((Object)MapKey.DATASET_FOLDER) + (String)param.get((Object)MapKey.REFERENCE_FILE)));
        param.put(MapKey.SOURCE_CLASS, "http://www.okkam.org/ontology_restaurant1.owl#Restaurant");
        param.put(MapKey.TARGET_CLASS, "http://www.okkam.org/ontology_restaurant2.owl#Restaurant");
        return param;
    }

    private static HashMap<MapKey, Object> getRestaurantCSV() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Restaurants/");
        param.put(MapKey.CONFIG_FILE, "restaurants_csv.xml");
        param.put(MapKey.REFERENCE_FILE, "restaurant1_restaurant2_goldstandard.rdf.csv");
        param.put(MapKey.SOURCE_FILE, "restaurant1.nt");
        param.put(MapKey.TARGET_FILE, "restaurant2.nt");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Restaurants.csv");
        param.put(MapKey.NAME, "Restaurants_CSV");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + (String)param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        HybridCache sC = HybridCache.getData(cR.getConfiguration().getSourceInfo());
        HybridCache tC = HybridCache.getData(cR.getConfiguration().getTargetInfo());
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, sC);
        param.put(MapKey.TARGET_CACHE, tC);
        IOracle o = OracleFactory.getOracle("" + param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "CSV", "simple");
        param.put(MapKey.REFERENCE_MAPPING, o.getMapping());
        param.put(MapKey.SOURCE_CLASS, "http://www.okkam.org/ontology_restaurant1.owl#Restaurant");
        param.put(MapKey.TARGET_CLASS, "http://www.okkam.org/ontology_restaurant2.owl#Restaurant");
        return param;
    }

    private static HashMap<MapKey, Object> getDBLPACM() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/DBLP-ACM/");
        param.put(MapKey.CONFIG_FILE, "PublicationData.xml");
        param.put(MapKey.REFERENCE_FILE, "DBLP-ACM_perfectMapping.csv");
        param.put(MapKey.SOURCE_FILE, "ACM.csv");
        param.put(MapKey.TARGET_FILE, "DBLP2.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_DBLP-ACM.csv");
        param.put(MapKey.NAME, "DBLP-ACM");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "csv", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "dblp:book");
        param.put(MapKey.TARGET_CLASS, "acm:book");
        return param;
    }

    private static HashMap<MapKey, Object> getAbtBuy() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Abt-Buy/");
        param.put(MapKey.CONFIG_FILE, "Abt-Buy.xml");
        param.put(MapKey.REFERENCE_FILE, "abt_buy_perfectMapping.csv");
        param.put(MapKey.SOURCE_FILE, "Abt.csv");
        param.put(MapKey.TARGET_FILE, "Buy.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Abt-Buy.csv");
        param.put(MapKey.NAME, "Abt-Buy");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "csv", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "abt:product");
        param.put(MapKey.TARGET_CLASS, "buy:product");
        return param;
    }

    private static HashMap<MapKey, Object> getDBLPScholar() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/DBLP-Scholar/");
        param.put(MapKey.CONFIG_FILE, "DBLP-Scholar.xml");
        param.put(MapKey.REFERENCE_FILE, "DBLP-Scholar_perfectMapping.csv");
        param.put(MapKey.SOURCE_FILE, "DBLP1.csv");
        param.put(MapKey.TARGET_FILE, "Scholar.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_DBLP-Scholar.csv");
        param.put(MapKey.NAME, "DBLP-SCHOLAR");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "csv", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "dblp:book");
        param.put(MapKey.TARGET_CLASS, "scholar:book");
        return param;
    }

    private static HashMap<MapKey, Object> getAmazonGoogleProducts() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/Amazon-GoogleProducts/");
        param.put(MapKey.CONFIG_FILE, "Amazon-GoogleProducts.xml");
        param.put(MapKey.REFERENCE_FILE, "Amzon_GoogleProducts_perfectMapping.csv");
        param.put(MapKey.SOURCE_FILE, "Amazon.csv");
        param.put(MapKey.TARGET_FILE, "GoogleProducts.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Amazon-GoogleProducts.csv");
        param.put(MapKey.NAME, "Amazon-GoogleProducts");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "csv", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "amazon:product");
        param.put(MapKey.TARGET_CLASS, "google:product");
        return param;
    }

    private static HashMap<MapKey, Object> getDBPediaLinkedMDB() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/dbpedia-linkedmdb/");
        param.put(MapKey.CONFIG_FILE, "dbpedia-linkedmdb.xml");
        param.put(MapKey.REFERENCE_FILE, "reference.csv");
        param.put(MapKey.SOURCE_FILE, "source.csv");
        param.put(MapKey.TARGET_FILE, "target.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_DBPedia-LinkedMDB.csv");
        param.put(MapKey.NAME, "DBPedia-LinkedMDB");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "tab", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "dbpedia:film");
        param.put(MapKey.TARGET_CLASS, "linkedmdb:movie");
        return param;
    }

    private static HashMap<MapKey, Object> getDrugs() {
        HashMap<MapKey, Object> param = new HashMap<MapKey, Object>();
        param.put(MapKey.BASE_FOLDER, "src/main/resources/datasets/");
        param.put(MapKey.DATASET_FOLDER, "src/main/resources/datasets/dailymed-drugbank-ingredients/");
        param.put(MapKey.CONFIG_FILE, "dailymed-drugbank.xml");
        param.put(MapKey.REFERENCE_FILE, "reference2.csv");
        param.put(MapKey.SOURCE_FILE, "source2.csv");
        param.put(MapKey.TARGET_FILE, "target2.csv");
        param.put(MapKey.EVALUATION_RESULTS_FOLDER, "resources/results/");
        param.put(MapKey.EVALUATION_FILENAME, "Pseudo_eval_Drugs.csv");
        param.put(MapKey.NAME, "Drugs");
        XMLConfigurationReader cR = new XMLConfigurationReader((String)param.get((Object)MapKey.BASE_FOLDER) + param.get((Object)MapKey.CONFIG_FILE));
        ((AConfigurationReader)cR).read();
        param.put(MapKey.CONFIG_READER, cR);
        param.put(MapKey.PROPERTY_MAPPING, PropMapper.getPropertyMappingFromFile((String)param.get((Object)MapKey.BASE_FOLDER), (String)param.get((Object)MapKey.CONFIG_FILE)));
        param.put(MapKey.SOURCE_CACHE, HybridCache.getData(cR.getConfiguration().getSourceInfo()));
        param.put(MapKey.TARGET_CACHE, HybridCache.getData(cR.getConfiguration().getTargetInfo()));
        param.put(MapKey.REFERENCE_MAPPING, OracleFactory.getOracle((String)param.get((Object)MapKey.DATASET_FOLDER) + param.get((Object)MapKey.REFERENCE_FILE), "csv", "simple").getMapping());
        param.put(MapKey.SOURCE_CLASS, "dailymed:drug");
        param.put(MapKey.TARGET_CLASS, "drugbank:drug");
        return param;
    }

    public static Set<MapKey> getLoggingKeys() {
        HashSet<MapKey> set = new HashSet<MapKey>();
        set.add(MapKey.NAME);
        return set;
    }

    public static String getEvalFolder() {
        return "resources/results/";
    }

    public static AMapping fixReferenceMap(AMapping original, ACache sC, ACache tC) {
        int count = 0;
        AMapping fixed = MappingFactory.createMapping(MappingFactory.MappingType.MEMORY_MAPPING);
        for (String sk : original.getMap().keySet()) {
            if (sC.containsUri(sk)) {
                for (String tk : original.getMap().get(sk).keySet()) {
                    if (tC.containsUri(tk)) {
                        fixed.add(sk, tk, original.getConfidence(sk, tk));
                        continue;
                    }
                    ++count;
                }
                continue;
            }
            count += original.getMap().get(sk).size();
        }
        logger.info("Removed " + count + " mappings as the instances are not found in the Caches");
        return fixed;
    }

    @Test
    public void testAll() {
        try {
            for (DataSets ds : DataSets.values()) {
                DataSetChooser.getData(ds);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)true);
    }

    public static enum DataSets {
        PERSON1,
        PERSON1_CSV,
        PERSON2,
        PERSON2_CSV,
        RESTAURANTS,
        OAEI2014BOOKS,
        RESTAURANTS_FIXED,
        DBLPACM,
        ABTBUY,
        DBLPSCHOLAR,
        AMAZONGOOGLEPRODUCTS,
        DBPLINKEDMDB,
        DRUGS,
        RESTAURANTS_CSV;

    }

    static enum MapKey {
        BASE_FOLDER("basefolder"),
        DATASET_FOLDER("datasetfolder"),
        CONFIG_FILE("config"),
        REFERENCE_FILE("reference"),
        SOURCE_FILE("file1"),
        TARGET_FILE("file1"),
        TRAINING("training"),
        EVALUATION_RESULTS_FOLDER("evalfolder"),
        EVALUATION_FILENAME("evalfilename"),
        NAME("name"),
        SOURCE_CACHE("sourcecache"),
        TARGET_CACHE("targetcache"),
        PROPERTY_MAPPING("propertymapping"),
        REFERENCE_MAPPING("referencemapping"),
        MAX_RUNS("maxruns"),
        CONFIG_READER("configreader"),
        SOURCE_CLASS("sourceclass"),
        TARGET_CLASS("targetclass");

        private final String key;

        private MapKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

