/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Part;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.controller.LimesResult;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.preprocessing.APreprocessingFunction;
import org.aksw.limes.core.io.preprocessing.PreprocessingFunctionFactory;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.aksw.limes.core.io.serializer.SerializerFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import spark.Filter;
import spark.Response;
import spark.Spark;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String STORAGE_DIR_PATH = "./.server-storage/";
    public static final String LOG_DIR_PATH = "./.server-storage/logs/";
    public static final String CONFIG_FILE_PREFIX = "limes_cfg_";
    public static final String CONFIG_FILE_SUFFIX = "xml";
    private static final Gson GSON = new GsonBuilder().create();
    private static final int FILE_SIZE_THRESHOLD = 1024;
    private static final long MAX_REQUEST_SIZE = 0xF00000L;
    private static final long MAX_FILE_SIZE = 0x500000L;
    private static Server instance = null;
    private final Map<String, CompletableFuture<Void>> requests = new HashMap<String, CompletableFuture<Void>>();
    private Map<String, String> uploadFiles = new HashMap<String, String>();
    private final File uploadDir = new File("./.server-storage/");
    private int port = -1;
    private int limit = -1;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public void run(int port, int limit) {
        try {
            Path files = Paths.get(STORAGE_DIR_PATH, "files").toAbsolutePath();
            if (Files.exists(files, new LinkOption[0])) {
                Files.walk(files, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.limit = limit;
        if (this.port > 0) {
            throw new IllegalStateException("Server already running on port " + port + "!");
        }
        this.port = port;
        if (!this.uploadDir.exists()) {
            this.uploadDir.mkdir();
        }
        Spark.port((int)port);
        Spark.staticFiles.location("/web-ui");
        Spark.staticFiles.expireTime(7200L);
        Server.enableCORS("*", "GET, POST, OPTIONS", "");
        Spark.post((String)"/submit", this::handleSubmit);
        Spark.get((String)"/status/:id", this::handleStatus);
        Spark.get((String)"/logs/:id", this::handleLogs);
        Spark.get((String)"/results/:id", this::handleResults);
        Spark.get((String)"/result/:id/:file", this::handleResult);
        Spark.get((String)"/list/operators", this::handleOperators);
        Spark.get((String)"/list/measures", this::handleMeasures);
        Spark.get((String)"/list/preprocessings", this::handlePreprocessings);
        Spark.get((String)"/sparql/:endpoint", this::handleSparql);
        Spark.get((String)"/uploads/:uploadId/sparql", this::handleLocalSparql);
        Spark.post((String)"/upload", this::handleUpload);
        Spark.post((String)"/sparql/:endpoint", this::handleSparql);
        Spark.options((String)"/sparql/:endpoint", this::handleSparql);
        Spark.exception(Exception.class, (e, req, res) -> {
            logger.error("Error in processing request" + req.uri(), (Throwable)e);
            res.status(500);
            res.type("application/json");
            res.body(GSON.toJson((Object)new ErrorMessage(e)));
        });
        Spark.notFound((req, res) -> {
            res.type("application/json");
            res.status(404);
            return GSON.toJson((Object)new ErrorMessage(-2, "Route not known"));
        });
        Spark.init();
        Spark.awaitInitialization();
    }

    private Object handleSparql(spark.Request req, Response res) throws IOException {
        HttpEntity entity;
        Request request;
        String endpointUrl = URLDecoder.decode(req.params("endpoint"), "UTF-8");
        if (req.queryString() != null && !req.queryString().equals("null")) {
            endpointUrl = endpointUrl + "?" + req.queryString();
        }
        logger.info("endpointUrl: {}", (Object)endpointUrl);
        switch (req.requestMethod()) {
            case "POST": {
                request = Request.Post((String)endpointUrl);
                request.bodyByteArray(req.bodyAsBytes());
                break;
            }
            case "OPTIONS": {
                request = Request.Options((String)endpointUrl);
                break;
            }
            default: {
                request = Request.Get((String)endpointUrl);
            }
        }
        for (String header : req.headers()) {
            if (header.equals("Content-Length") || header.equals("Host")) continue;
            request.setHeader(header, req.headers(header));
        }
        HttpResponse response = request.execute().returnResponse();
        for (Header header : response.getAllHeaders()) {
            if (header.getName().startsWith("Access-Control")) continue;
            res.header(header.getName(), header.getValue());
        }
        res.status(response.getStatusLine().getStatusCode());
        if (!req.requestMethod().equals("OPTIONS") && (entity = response.getEntity()) != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            res.raw().getOutputStream().write(bytes);
            res.raw().getOutputStream().flush();
            res.raw().getOutputStream().close();
        }
        return res.raw();
    }

    private Object handleLocalSparql(spark.Request req, Response res) throws IOException {
        String uploadId = req.params("uploadId");
        String s = this.uploadFiles.get(uploadId);
        String query = req.queryParams("query");
        String matchQuery = query.toLowerCase().trim();
        Model queryModel = ModelFactory.createDefaultModel().read(s);
        QueryExecution queryExecution = QueryExecutionFactory.create((String)query, (Model)queryModel);
        if (matchQuery.startsWith("select")) {
            ResultSet resultSet = queryExecution.execSelect();
            ResultSetFormatter.outputAsJSON((OutputStream)res.raw().getOutputStream(), (ResultSet)resultSet);
        } else if (matchQuery.startsWith("ask")) {
            boolean result = queryExecution.execAsk();
            ResultSetFormatter.outputAsJSON((OutputStream)res.raw().getOutputStream(), (boolean)result);
        }
        queryExecution.close();
        return "";
    }

    private Object handleUpload(spark.Request req, Response res) throws IOException, ServletException {
        File workingDir = new File(this.uploadDir.getAbsoluteFile(), "files");
        if (!workingDir.exists() && !workingDir.mkdirs() || !workingDir.isDirectory()) {
            throw new IOException("Not able to create directory " + workingDir.getAbsolutePath());
        }
        HashMap<String, String> partUploads = new HashMap<String, String>();
        req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(workingDir.getAbsolutePath(), 0x500000L, 0xF00000L, 1024));
        if (req.contentType().contains("multipart/form-data")) {
            for (Part part : req.raw().getParts()) {
                InputStream is = part.getInputStream();
                try {
                    String uploadId = UUID.randomUUID().toString();
                    Path partFileName = Paths.get(part.getSubmittedFileName(), new String[0]).getFileName();
                    String extension = FilenameUtils.getExtension((String)partFileName.toString());
                    Path destinationPath = workingDir.toPath().resolve(uploadId + "." + extension);
                    Files.copy(is, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                    partUploads.put(part.getSubmittedFileName(), uploadId);
                    this.uploadFiles.put(uploadId, destinationPath.toString());
                    logger.info("Uploaded file '{}' with uploadId '{}'", (Object)part.getName(), (Object)uploadId);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        } else {
            return GSON.toJson((Object)new ErrorMessage(1, "Only Requests of type \"multipart/form-data\" are allowed"));
        }
        res.status(200);
        return GSON.toJson((Object)new UploadMessage(partUploads));
    }

    private Server() {
    }

    private Object handleOperators(spark.Request req, Response res) {
        OperatorsMessage result = new OperatorsMessage(Arrays.stream(LogicOperator.values()).map(Enum::name).collect(Collectors.toList()));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleMeasures(spark.Request req, Response res) {
        MeasuresMessage result = new MeasuresMessage(Arrays.stream(MeasureType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handlePreprocessings(spark.Request req, Response res) {
        PreprocessingsMessage result = new PreprocessingsMessage(PreprocessingFunctionFactory.listTypes().stream().map(pp -> {
            APreprocessingFunction ppf = PreprocessingFunctionFactory.getPreprocessingFunction(PreprocessingFunctionFactory.getPreprocessingType(pp));
            return new PreprocessingsMessage.PPInfo((String)pp, ppf.minNumberOfArguments(), ppf.maxNumberOfArguments(), ppf.isComplex());
        }).filter(ppi -> !((PreprocessingsMessage.PPInfo)ppi).isComplex).collect(Collectors.toList()));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleSubmit(spark.Request req, Response res) throws Exception {
        req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement("/temp"));
        Part configFile = req.raw().getPart("config_file");
        String fileName = Server.getFileName(configFile);
        String suffix = FilenameUtils.getExtension((String)fileName);
        Path tempFile = Files.createTempFile(this.uploadDir.toPath(), CONFIG_FILE_PREFIX, "." + (suffix.equals("") ? CONFIG_FILE_SUFFIX : suffix), new FileAttribute[0]);
        try (InputStream is = configFile.getInputStream();){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        logger.info("Uploaded file '{}' saved as '{}'", (Object)fileName, (Object)tempFile.toAbsolutePath());
        String id = tempFile.toString();
        id = id.substring(id.indexOf(CONFIG_FILE_PREFIX) + CONFIG_FILE_PREFIX.length(), id.lastIndexOf("."));
        File workingDir = new File(this.uploadDir.getAbsoluteFile(), id);
        if (!workingDir.mkdir()) {
            throw new RuntimeException("Not able to create directory " + workingDir.getAbsolutePath());
        }
        String requestId = id;
        this.requests.put(requestId, (CompletableFuture<Void>)((CompletableFuture)CompletableFuture.completedFuture(null).thenAcceptAsync($ -> {
            String targetEndpoint;
            MDC.put((String)"requestId", (String)requestId);
            XMLConfigurationReader reader = new XMLConfigurationReader(tempFile.toAbsolutePath().toString());
            Configuration config = ((AConfigurationReader)reader).read();
            String sourceEndpoint = config.getSourceInfo().getEndpoint();
            if (this.uploadFiles.containsKey(sourceEndpoint)) {
                config.getSourceInfo().setEndpoint(this.uploadFiles.get(sourceEndpoint));
            }
            if (this.uploadFiles.containsKey(targetEndpoint = config.getTargetInfo().getEndpoint())) {
                config.getTargetInfo().setEndpoint(this.uploadFiles.get(targetEndpoint));
            }
            LimesResult mappings = Controller.getMapping(config, this.limit);
            String outputFormat = config.getOutputFormat();
            ISerializer output = SerializerFactory.createSerializer(outputFormat);
            output.setPrefixes(config.getPrefixes());
            File verificationFile = new File(workingDir, config.getVerificationFile());
            File acceptanceFile = new File(workingDir, config.getAcceptanceFile());
            output.writeToFile(mappings.getVerificationMapping(), config.getVerificationRelation(), verificationFile.getAbsolutePath());
            output.writeToFile(mappings.getAcceptanceMapping(), config.getAcceptanceRelation(), acceptanceFile.getAbsolutePath());
        })).exceptionally(e -> {
            e.printStackTrace();
            return null;
        }));
        res.status(200);
        return GSON.toJson((Object)new SubmitMessage(id));
    }

    private Object handleStatus(spark.Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        StatusMessage result = !this.requests.containsKey(id) ? new StatusMessage(-1, "Request ID not found") : (!this.requests.get(id).isDone() ? new StatusMessage(1, "Request is being processed") : new StatusMessage(2, "Request has been processed"));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleLogs(spark.Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(LOG_DIR_PATH + id + ".log");
        if (requestedFile.exists()) {
            boolean finish;
            res.type("text/plain");
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            boolean bl = finish = !this.requests.containsKey(id) || this.requests.get(id).isDone();
            while (true) {
                int count;
                if ((count = fs.read(buffer)) >= 0) {
                    os.write(buffer, 0, count);
                    continue;
                }
                os.flush();
                if (finish) break;
                Thread.sleep(500L);
                finish = this.requests.get(id).isDone();
            }
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Logfile not found"));
    }

    private Object handleResult(spark.Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File file = new File(req.params("file"));
        File requestedFile = new File(STORAGE_DIR_PATH + id + "/" + file.getName());
        if (requestedFile.exists()) {
            int count;
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
            Collection mimeTypes = MimeUtil.getMimeTypes((File)requestedFile, (MimeType)new MimeType("text/plain"));
            res.type(mimeTypes.iterator().next().toString());
            res.header("Content-Disposition", "attachment; filename=" + file.getName());
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            while ((count = fs.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Result file not found"));
    }

    private Object handleResults(spark.Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        File dir = new File(STORAGE_DIR_PATH + id);
        if (dir.exists() && dir.isDirectory()) {
            List availableFiles = Arrays.stream(Objects.requireNonNull(dir.listFiles())).map(File::getName).collect(Collectors.toList());
            return GSON.toJson((Object)new ResultsMessage(availableFiles));
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Request ID not found"));
    }

    private static String sanitizeId(String id) {
        return id.replaceAll("[^\\d]", "");
    }

    private static String getFileName(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return "config.ttl";
    }

    private static void enableCORS(String origin, String methods, String headers) {
        Spark.options((String)"/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        }});
    }

    private static class UploadMessage
    extends ServerMessage {
        private List<UploadInfo> uploads = new ArrayList<UploadInfo>();

        private UploadMessage(Map<String, String> partUploads) {
            for (Map.Entry<String, String> upload : partUploads.entrySet()) {
                this.uploads.add(new UploadInfo(upload.getKey(), upload.getValue()));
            }
        }

        static class UploadInfo {
            private String partName;
            private String uploadId;

            UploadInfo(String partName, String uploadId) {
                this.partName = partName;
                this.uploadId = uploadId;
            }
        }
    }

    private static class SubmitMessage
    extends ServerMessage {
        private String requestId;

        private SubmitMessage(String requestId) {
            this.requestId = requestId;
        }
    }

    static class PreprocessingsMessage
    extends ServerMessage {
        private List<PPInfo> availablePreprocessings;

        private PreprocessingsMessage(List<PPInfo> availablePreprocessings) {
            this.availablePreprocessings = availablePreprocessings;
        }

        static class PPInfo {
            private String name;
            private int minArgs;
            private int maxArgs;
            private boolean isComplex;

            PPInfo(String name, int minArgs, int maxArgs, boolean isComplex) {
                this.name = name;
                this.minArgs = minArgs;
                this.maxArgs = maxArgs;
                this.isComplex = isComplex;
            }
        }
    }

    private static class OperatorsMessage
    extends ServerMessage {
        private List<String> availableOperators;

        private OperatorsMessage(List<String> availableOperators) {
            this.availableOperators = availableOperators;
        }
    }

    private static class MeasuresMessage
    extends ServerMessage {
        private List<String> availableMeasures;

        private MeasuresMessage(List<String> availableMeasures) {
            this.availableMeasures = availableMeasures;
        }
    }

    private static class ResultsMessage
    extends ServerMessage {
        private List<String> availableFiles;

        private ResultsMessage(List<String> availableFiles) {
            this.availableFiles = availableFiles;
        }
    }

    private static class StatusMessage
    extends ServerMessage {
        private Status status = new Status();

        private StatusMessage(int status, String description) {
            this.status.code = status;
            this.status.description = description;
        }

        private static class Status {
            int code;
            String description;

            private Status() {
            }
        }
    }

    private static class ErrorMessage
    extends ServerMessage {
        private Error error;

        ErrorMessage(Throwable e) {
            this(-1, e.getMessage());
        }

        ErrorMessage(int code, String message) {
            this.success = false;
            this.error = new Error();
            this.error.code = code;
            this.error.message = message;
        }

        private static class Error {
            private int code;
            private String message;

            private Error() {
            }
        }
    }

    private static class ServerMessage {
        protected boolean success = true;

        private ServerMessage() {
        }
    }
}

