/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.MapperFactory;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class MeasureProcessor {
    private static final String ADD = "ADD";
    private static final String XOR = "XOR";
    private static final String MAX = "MAX";
    private static final String MIN = "MIN";
    private static final String AND = "AND";
    private static final String OR = "OR";
    static Logger logger = LoggerFactory.getLogger((String)MeasureProcessor.class.getName());

    public static List<String> getMeasures(String expression) {
        ArrayList<String> results = new ArrayList<String>();
        Parser p = new Parser(expression, 0.0);
        if (p.isAtomic()) {
            results.add(p.getOperator());
        } else {
            results.addAll(MeasureProcessor.getMeasures(p.getLeftTerm()));
            results.addAll(MeasureProcessor.getMeasures(p.getRightTerm()));
        }
        return results;
    }

    public static double getSimilarity(Instance sourceInstance, Instance targetInstance, String expression, double threshold, String sourceVar, String targetVar) {
        Parser p = new Parser(expression, threshold);
        try {
            if (p.isAtomic()) {
                int i;
                String var;
                String[] split;
                AMapper mapper = null;
                MeasureType type = MeasureFactory.getMeasureType(p.getOperator());
                mapper = MapperFactory.createMapper(type);
                HybridCache source = new HybridCache();
                HybridCache target = new HybridCache();
                ((ACache)source).addInstance(sourceInstance);
                ((ACache)target).addInstance(targetInstance);
                String property1 = null;
                String property2 = null;
                String term1 = "?" + p.getLeftTerm();
                String term2 = "?" + p.getRightTerm();
                String property = "";
                if (term1.contains(".")) {
                    split = term1.split("\\.");
                    var = split[0];
                    property = split[1];
                    if (split.length >= 2) {
                        for (i = 2; i < split.length; ++i) {
                            property = property + "." + split[i];
                        }
                    }
                    if (var.equals(sourceVar)) {
                        property1 = property;
                    } else {
                        property2 = property;
                    }
                } else {
                    property1 = term1;
                }
                if (term2.contains(".")) {
                    split = term2.split("\\.");
                    var = split[0];
                    property = split[1];
                    if (split.length >= 2) {
                        for (i = 2; i < split.length; ++i) {
                            property = property + "." + split[i];
                        }
                    }
                    if (var.equals(sourceVar)) {
                        property1 = property;
                    } else {
                        property2 = property;
                    }
                } else {
                    property2 = term2;
                }
                if (property1 == null || property2 == null) {
                    logger.error(MarkerFactory.getMarker((String)"FATAL"), "Property values could not be read. Exiting");
                    throw new RuntimeException();
                }
                double similarity = 0.0;
                if (threshold <= 0.0) {
                    throw new InvalidThresholdException(threshold);
                }
                AMapping m = mapper.getMapping(source, target, sourceVar, targetVar, expression, threshold);
                for (String s : m.getMap().keySet()) {
                    for (String t : m.getMap().get(s).keySet()) {
                        similarity = m.getConfidence(s, t);
                    }
                }
                if (similarity >= threshold) {
                    return similarity;
                }
                return 0.0;
            }
            if (p.getOperator().equalsIgnoreCase(MAX) | p.getOperator().equalsIgnoreCase(OR) | p.getOperator().equalsIgnoreCase(XOR)) {
                double parentThreshold = p.getThreshold();
                double firstChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getLeftTerm(), p.getThreshold1(), sourceVar, targetVar);
                double secondChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getRightTerm(), p.getThreshold2(), sourceVar, targetVar);
                if (firstChild < p.getThreshold1() && secondChild < p.getThreshold2()) {
                    return 0.0;
                }
                double maxSimilarity = Math.max(firstChild, secondChild);
                if (maxSimilarity >= parentThreshold) {
                    return maxSimilarity;
                }
                return 0.0;
            }
            if (p.getOperator().equalsIgnoreCase(MIN) | p.getOperator().equalsIgnoreCase(AND)) {
                double parentThreshold = p.getThreshold();
                double firstChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getLeftTerm(), p.getThreshold1(), sourceVar, targetVar);
                double secondChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getRightTerm(), p.getThreshold2(), sourceVar, targetVar);
                if (firstChild < p.getThreshold1() && secondChild < p.getThreshold2()) {
                    return 0.0;
                }
                double minSimilarity = Math.min(firstChild, secondChild);
                if (minSimilarity >= parentThreshold) {
                    return minSimilarity;
                }
                return 0.0;
            }
            if (p.getOperator().equalsIgnoreCase(ADD)) {
                double parentThreshold = p.getThreshold();
                double firstChild = p.getLeftCoefficient() * MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getLeftTerm(), p.getThreshold1(), sourceVar, targetVar);
                double secondChild = p.getRightCoefficient() * MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getRightTerm(), p.getThreshold2(), sourceVar, targetVar);
                if (firstChild < p.getThreshold1() && secondChild < p.getThreshold2()) {
                    return 0.0;
                }
                if (firstChild + secondChild >= parentThreshold) {
                    return firstChild + secondChild;
                }
                return 0.0;
            }
            double parentThreshold = p.getThreshold();
            double firstChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getLeftTerm(), p.getThreshold1(), sourceVar, targetVar);
            double secondChild = MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getRightTerm(), p.getThreshold2(), sourceVar, targetVar);
            if (secondChild == 0.0) {
                if (firstChild >= p.getThreshold1()) {
                    if (firstChild >= parentThreshold) {
                        return firstChild;
                    }
                    return 0.0;
                }
                return 0.0;
            }
            return 0.0;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getCosts(String measureExpression, double mappingSize) {
        List<String> measures = MeasureProcessor.getMeasures(measureExpression);
        double runtime = 0.0;
        for (int i = 0; i < measures.size(); ++i) {
            MeasureType type = MeasureFactory.getMeasureType(measures.get(i));
            runtime += MeasureFactory.createMeasure(type).getRuntimeApproximation(mappingSize);
        }
        return runtime;
    }
}

