/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.resourcesets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;

public class SetJaccardMapper
extends AMapper {
    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        List<Set<String>> small;
        List<Set<String>> big;
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        List<Set<String>> sourceIndex = this.buildIndex(source, properties.get(0));
        List<Set<String>> targetIndex = this.buildIndex(target, properties.get(1));
        if (sourceIndex.size() > targetIndex.size()) {
            big = sourceIndex;
            small = targetIndex;
        } else {
            big = targetIndex;
            small = sourceIndex;
        }
        List<List<Set<String>>> possibleMatches = this.getPossibleMatches(small, big, threshold);
        AMapping result = MappingFactory.createDefaultMapping();
        for (int i = 0; i < possibleMatches.size(); i += 2) {
            List<Set<String>> s = possibleMatches.get(i);
            List<Set<String>> t = possibleMatches.get(i + 1);
            for (Set<String> setS : s) {
                for (Set<String> setT : t) {
                    double score = this.fastSimCheck(setS, setT, threshold);
                    if (!(score >= threshold)) continue;
                    result.add(((NamedHashSet)setS).getUri(), ((NamedHashSet)setT).getUri(), score);
                }
            }
        }
        return result;
    }

    private List<Set<String>> buildIndex(ACache c, String p) {
        ArrayList<Set<String>> index = new ArrayList<Set<String>>();
        for (String uri : c.getAllUris()) {
            NamedHashSet<String> values = new NamedHashSet<String>(c.getInstance(uri).getProperty(p), uri);
            if (values.size() <= 0) continue;
            index.add(values);
        }
        SetSizeQuicksort.sort(index);
        return index;
    }

    private List<List<Set<String>>> getPossibleMatches(List<Set<String>> small, List<Set<String>> big, double threshold) {
        int startBig = 0;
        int oldSize = small.get(0).size();
        ArrayList<Set<String>> tempSource = new ArrayList<Set<String>>();
        ArrayList<Set<String>> tempTarget = new ArrayList<Set<String>>();
        ArrayList<List<Set<String>>> possibleMatches = new ArrayList<List<Set<String>>>();
        for (Set<String> values : small) {
            if (values.size() > oldSize) {
                boolean nextStartSizeNotFixedYet = true;
                int loB = (int)Math.ceil((double)oldSize * threshold);
                int hiB = (int)Math.floor((double)oldSize / threshold);
                int nextStartSize = (int)Math.ceil(threshold * (double)values.size());
                for (int j = startBig; j < big.size(); ++j) {
                    Set<String> targetValues = big.get(j);
                    if (targetValues.size() < loB) continue;
                    if (targetValues.size() > hiB) break;
                    if (nextStartSizeNotFixedYet && targetValues.size() >= nextStartSize) {
                        nextStartSizeNotFixedYet = false;
                        startBig = startBig == 0 ? 0 : j - 1;
                    }
                    tempTarget.add(targetValues);
                }
                possibleMatches.add(tempSource);
                possibleMatches.add(tempTarget);
                tempSource = new ArrayList();
                oldSize = values.size();
            }
            tempSource.add(values);
        }
        int loB = (int)Math.ceil((double)oldSize * threshold);
        int hiB = (int)Math.floor((double)oldSize / threshold);
        for (int j = startBig; j < big.size(); ++j) {
            Set<String> targetValues = big.get(j);
            if (targetValues.size() < loB) continue;
            if (targetValues.size() > hiB) break;
            tempTarget.add(targetValues);
        }
        possibleMatches.add(tempSource);
        possibleMatches.add(tempTarget);
        return possibleMatches;
    }

    private double fastSimCheck(Set<String> s, Set<String> t, double threshold) {
        int matches = 0;
        int mismatches = 0;
        int maxMismatches = (int)Math.floor(((double)Math.min(s.size(), t.size()) - threshold * (double)Math.max(s.size(), t.size())) / (1.0 + threshold));
        for (String x : s) {
            if (t.contains(x)) {
                ++matches;
                continue;
            }
            if (++mismatches <= maxMismatches) continue;
            return 0.0;
        }
        return (double)matches / ((double)s.size() + (double)t.size() - (double)matches);
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public String getName() {
        return "set_jaccard";
    }

    public static class NamedHashSet<E>
    implements Set<E> {
        private String uri;
        private Set<E> decoratedSet;

        public NamedHashSet(Set<E> set, String uri) {
            this.decoratedSet = set;
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public int size() {
            return this.decoratedSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.decoratedSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.decoratedSet.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.decoratedSet.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.decoratedSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.decoratedSet.toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.decoratedSet.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.decoratedSet.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.decoratedSet.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.decoratedSet.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.decoratedSet.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.decoratedSet.removeAll(c);
        }

        @Override
        public void clear() {
            this.decoratedSet.clear();
        }
    }

    public static class SetSizeQuicksort {
        public static void sort(List<Set<String>> values) {
            if (values == null || values.size() == 0) {
                return;
            }
            SetSizeQuicksort.quicksort(values, 0, values.size() - 1);
        }

        private static void quicksort(List<Set<String>> strings, int low, int high) {
            int i = low;
            int j = high;
            int pivot = strings.get(low + (high - low) / 2).size();
            while (i <= j) {
                while (strings.get(i).size() < pivot) {
                    ++i;
                }
                while (strings.get(j).size() > pivot) {
                    --j;
                }
                if (i > j) continue;
                SetSizeQuicksort.exchange(strings, i, j);
                ++i;
                --j;
            }
            if (low < j) {
                SetSizeQuicksort.quicksort(strings, low, j);
            }
            if (i < high) {
                SetSizeQuicksort.quicksort(strings, i, high);
            }
        }

        private static void exchange(List<Set<String>> strings, int i, int j) {
            Set<String> temp = strings.get(i);
            strings.set(i, strings.get(j));
            strings.set(j, temp);
        }
    }
}

