/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.io.ls.ILinkSpecification;
import org.aksw.limes.core.io.parser.Parser;

public class LinkSpecification
implements ILinkSpecification {
    protected static final String MAX = "MAX";
    protected static final String OR = "OR";
    protected static final String ADD = "ADD";
    protected static final String MINUS = "MINUS";
    protected static final String XOR = "XOR";
    protected static final String MIN = "MIN";
    protected static final String AND = "AND";
    protected double threshold;
    protected LogicOperator operator;
    protected List<LinkSpecification> children;
    protected List<LinkSpecification> dependencies;
    protected String filterExpression;
    protected LinkSpecification parent;
    protected double quality = 0.0;
    protected String atomicMeasure = "";
    protected String prop1 = "";
    protected String prop2 = "";
    protected String treePath = "";
    protected String fullExpression = "";
    private double lowThreshold = 0.0;

    public LinkSpecification() {
        this.setOperator(null);
        this.setChildren(null);
        this.setThreshold(-1.0);
        this.parent = null;
        this.setDependencies(null);
    }

    public LinkSpecification(String measure, double threshold) {
        this.setOperator(null);
        this.setChildren(null);
        this.parent = null;
        this.setDependencies(null);
        this.readSpec(measure, threshold);
    }

    public void setAtomicFilterExpression(String atomicMeasure, String prop1, String prop2) {
        this.setAtomicMeasure(atomicMeasure);
        this.prop1 = prop1;
        this.prop2 = prop2;
        this.filterExpression = atomicMeasure + "(" + prop1 + "," + prop2 + ")";
    }

    public void addChild(LinkSpecification spec) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<LinkSpecification>());
        }
        this.getChildren().add(spec);
    }

    public void addDependency(LinkSpecification spec) {
        if (this.getDependencies() == null) {
            this.setDependencies(new ArrayList<LinkSpecification>());
        }
        this.getDependencies().add(spec);
    }

    public void removeDependency(LinkSpecification spec) {
        if (this.getDependencies().contains(spec)) {
            this.getDependencies().remove(spec);
        }
        if (this.getDependencies().isEmpty()) {
            this.setDependencies(null);
        }
    }

    public boolean hasDependencies() {
        if (this.getDependencies() == null) {
            return false;
        }
        return !this.getDependencies().isEmpty();
    }

    public boolean isEmpty() {
        return this.filterExpression == null && (this.getChildren() == null || this.getChildren().isEmpty());
    }

    public boolean isAtomic() {
        if (this.getChildren() == null) {
            return true;
        }
        return this.getChildren().isEmpty();
    }

    public void pathOfAtomic() {
        if (this.isAtomic()) {
            this.treePath = this.treePath + "";
        } else if (this.getChildren() != null) {
            for (LinkSpecification child : this.getChildren()) {
                String parentPath = this.treePath;
                child.treePath = child == this.getChildren().get(0) ? parentPath + ": " + (Object)((Object)this.getOperator()) + "->left" : parentPath + ": " + (Object)((Object)this.getOperator()) + "->right";
                child.pathOfAtomic();
            }
        }
    }

    public void readSpec(String spec, double theta) {
        Parser p = new Parser(spec = spec.trim(), theta);
        if (p.isAtomic()) {
            this.filterExpression = spec;
            this.setThreshold(theta);
            this.fullExpression = spec;
        } else {
            LinkSpecification leftSpec = new LinkSpecification();
            LinkSpecification rightSpec = new LinkSpecification();
            leftSpec.parent = this;
            rightSpec.parent = this;
            this.setChildren(new ArrayList<LinkSpecification>());
            this.getChildren().add(leftSpec);
            this.getChildren().add(rightSpec);
            if (p.getOperator().equalsIgnoreCase(AND)) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(MIN)) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), theta);
                rightSpec.readSpec(p.getRightTerm(), theta);
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(OR)) {
                this.setOperator(LogicOperator.OR);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "OR(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(MAX)) {
                this.setOperator(LogicOperator.OR);
                leftSpec.readSpec(p.getLeftTerm(), theta);
                rightSpec.readSpec(p.getRightTerm(), theta);
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "OR(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(XOR)) {
                this.setOperator(LogicOperator.XOR);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "XOR(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(MINUS)) {
                this.setOperator(LogicOperator.MINUS);
                leftSpec.readSpec(p.getLeftTerm(), p.getThreshold1());
                rightSpec.readSpec(p.getRightTerm(), p.getThreshold2());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "MINUS(" + leftSpec.fullExpression + "|" + p.getThreshold1() + "," + rightSpec.fullExpression + "|" + p.getThreshold2() + ")";
            } else if (p.getOperator().equalsIgnoreCase(ADD)) {
                this.setOperator(LogicOperator.AND);
                leftSpec.readSpec(p.getLeftTerm(), Math.abs(theta - p.getRightCoefficient()) / p.getLeftCoefficient());
                rightSpec.readSpec(p.getRightTerm(), Math.abs(theta - p.getLeftCoefficient()) / p.getRightCoefficient());
                this.filterExpression = null;
                this.setThreshold(theta);
                this.fullExpression = "AND(" + leftSpec.fullExpression + "|" + Math.abs(theta - p.getRightCoefficient()) / p.getLeftCoefficient() + "," + rightSpec.fullExpression + "|" + Math.abs(theta - p.getLeftCoefficient()) / p.getRightCoefficient() + ")";
            }
        }
    }

    public List<LinkSpecification> getAllLeaves() {
        ArrayList<LinkSpecification> allLeaves = new ArrayList<LinkSpecification>();
        if (this.isAtomic()) {
            allLeaves.add(this);
        } else {
            for (LinkSpecification child : this.getChildren()) {
                allLeaves.addAll(child.getAllLeaves());
            }
        }
        return allLeaves;
    }

    public LinkSpecification setLeaf(LinkSpecification leaf, int n) {
        LinkSpecification clone = this.clone();
        clone.setLeaf(leaf, null, n);
        return clone;
    }

    private void setLeaf(LinkSpecification leaf, LinkSpecification parent, int n) {
        List<LinkSpecification> children = this.getChildren();
        int leftSize = children.get(0).getAllLeaves().size();
        if (n < leftSize) {
            if (children.get(0).isAtomic()) {
                leaf.setParent(this);
                children.set(0, leaf);
                this.setChildren(children);
                return;
            }
            children.get(0).setLeaf(leaf, this, n);
        } else {
            if (children.get(1).isAtomic()) {
                leaf.setParent(this);
                children.set(1, leaf);
                this.setChildren(children);
                return;
            }
            children.get(1).setLeaf(leaf, this, n - leftSize);
        }
    }

    public int size() {
        int size = 1;
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isAtomic()) {
            return 1;
        }
        for (LinkSpecification c : this.getChildren()) {
            size += c.size();
        }
        return size;
    }

    public int hashCode() {
        int res = new Random().nextInt();
        return res;
    }

    @Override
    public LinkSpecification clone() {
        LinkSpecification clone = new LinkSpecification();
        clone.setThreshold(this.threshold);
        clone.setLowThreshold(this.lowThreshold);
        clone.setOperator(this.operator);
        clone.filterExpression = this.filterExpression;
        clone.fullExpression = this.fullExpression;
        clone.prop1 = this.prop1;
        clone.prop2 = this.prop2;
        clone.atomicMeasure = this.atomicMeasure;
        ArrayList<LinkSpecification> l = new ArrayList<LinkSpecification>();
        if (this.getChildren() != null) {
            for (LinkSpecification c : this.getChildren()) {
                LinkSpecification childCopy = c.clone();
                clone.addChild(childCopy);
                childCopy.parent = clone;
                l.add(childCopy);
            }
        }
        return clone;
    }

    public String toString() {
        if (this.getChildren() != null) {
            String str = "(" + this.filterExpression + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null,)";
            for (LinkSpecification child : this.getChildren()) {
                str = str + "\n  ->" + child;
            }
            return str;
        }
        return "(" + this.filterExpression + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null)";
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public String toStringPretty() {
        if (this.getChildren() != null) {
            String str = "(" + this.filterExpression + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null,)";
            String indent = new String(new char[this.getDepth()]).replace("\u0000", "\t");
            for (LinkSpecification child : this.getChildren()) {
                str = str + "\n  " + indent + " ->" + child.toStringPretty();
            }
            return str;
        }
        return "(" + this.filterExpression + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null)";
    }

    public String toStringOneLine() {
        if (this.getChildren() != null) {
            String str = "(" + this.getShortendFilterExpression() + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null,)";
            str = str + "{";
            for (LinkSpecification child : this.getChildren()) {
                str = str + child.toStringOneLine() + ",";
            }
            str = str + "}";
            return str;
        }
        return "(" + this.getShortendFilterExpression() + ", " + this.getThreshold() + ", " + (Object)((Object)this.getOperator()) + ", null)";
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getMeasure() {
        if (this.isAtomic()) {
            return this.filterExpression;
        }
        return (Object)((Object)this.getOperator()) + "()";
    }

    public boolean equals(Object other) {
        LinkSpecification o = (LinkSpecification)other;
        if (this.isAtomic() && o.isAtomic()) {
            if (this.filterExpression == null && o.filterExpression == null) {
                return true;
            }
            if (this.filterExpression != null && o.filterExpression == null) {
                return false;
            }
            if (this.filterExpression == null && o.filterExpression != null) {
                return false;
            }
            if (this.filterExpression.equalsIgnoreCase(o.filterExpression)) {
                return Math.abs(this.getThreshold() - o.getThreshold()) < 0.001;
            }
        } else {
            if (!this.isAtomic() && !o.isAtomic()) {
                if (this.getOperator() == null && o.getOperator() != null) {
                    return false;
                }
                if (this.getOperator() != null && o.getOperator() == null) {
                    return false;
                }
                if (this.getOperator() == null && o.getOperator() == null) {
                    return true;
                }
                if (this.getOperator().equals((Object)o.getOperator())) {
                    if (this.getChildren() == null && o.getChildren() == null) {
                        return true;
                    }
                    if (this.getChildren() != null && o.getChildren() == null) {
                        return false;
                    }
                    if (this.getChildren() == null && o.getChildren() != null) {
                        return false;
                    }
                    return this.getChildren().equals(o.getChildren());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        LinkSpecification other = (LinkSpecification)o;
        if (other.size() > this.size()) {
            return -1;
        }
        if (other.size() < this.size()) {
            return 1;
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isAtomic() && other.isAtomic()) {
            if (this.getThreshold() > other.getThreshold()) {
                return 1;
            }
            if (this.getThreshold() < other.getThreshold()) {
                return -1;
            }
            if (this.filterExpression == null && other.filterExpression != null) {
                return -1;
            }
            if (this.filterExpression != null && other.filterExpression == null) {
                return 1;
            }
            if (this.filterExpression == null && other.filterExpression == null) {
                return 0;
            }
            return this.filterExpression.compareToIgnoreCase(other.filterExpression);
        }
        if (this.getOperator() == other.getOperator()) {
            if (this.getAllLeaves().size() == other.getAllLeaves().size()) {
                List<LinkSpecification> leaves = this.getAllLeaves();
                List<LinkSpecification> otherLeaves = other.getAllLeaves();
                for (int i = 0; i < leaves.size(); ++i) {
                    if (leaves.get(i).compareTo(otherLeaves.get(i)) == 0) continue;
                    return leaves.get(i).compareTo(otherLeaves.get(i));
                }
                return 0;
            }
            return this.getAllLeaves().size() - other.getAllLeaves().size();
        }
        return this.getOperator().compareTo(other.getOperator());
    }

    public String getShortendFilterExpression() {
        if (this.filterExpression == null) {
            return null;
        }
        if (this.filterExpression.length() <= 0) {
            return "";
        }
        if (!this.isAtomic()) {
            return this.filterExpression;
        }
        int beginProp1 = this.filterExpression.indexOf("(");
        int brakeProp = this.filterExpression.indexOf(",");
        int endProp2 = this.filterExpression.indexOf(")");
        String measure = this.filterExpression.substring(0, beginProp1);
        String prop1 = this.filterExpression.substring(beginProp1 + 1, brakeProp);
        String prop2 = this.filterExpression.substring(brakeProp + 1, endProp2);
        if (prop1.lastIndexOf("#") != -1) {
            prop1 = prop1.substring(prop1.lastIndexOf("#") + 1);
        } else if (prop1.lastIndexOf("/") != -1) {
            prop1 = prop1.substring(prop1.lastIndexOf("/") + 1);
        }
        if (prop2.lastIndexOf("#") != -1) {
            prop2 = prop2.substring(prop2.lastIndexOf("#") + 1);
        } else if (prop2.lastIndexOf("/") != -1) {
            prop2 = prop2.substring(prop2.lastIndexOf("/") + 1);
        }
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        df.applyPattern("#,###,######0.00");
        return measure + "(" + prop1 + "," + prop2 + ")|" + df.format(this.getThreshold());
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public String getAtomicMeasure() {
        if (this.isAtomic()) {
            if (this.atomicMeasure.length() > 0) {
                return this.atomicMeasure;
            }
            return this.filterExpression.substring(0, this.filterExpression.indexOf("("));
        }
        return null;
    }

    public void setAtomicMeasure(String atomicMeasure) {
        this.atomicMeasure = atomicMeasure;
    }

    public boolean containsRedundantProperties() {
        List<LinkSpecification> leaves = this.getAllLeaves();
        HashSet<String> props = new HashSet<String>();
        for (LinkSpecification leave : leaves) {
            String propStr = leave.prop1 + "_" + leave.prop2;
            if (props.add(propStr)) continue;
            return true;
        }
        return false;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public LogicOperator getOperator() {
        return this.operator;
    }

    public void setOperator(LogicOperator operator) {
        this.operator = operator;
    }

    public List<LinkSpecification> getChildren() {
        return this.children;
    }

    public void setChildren(List<LinkSpecification> children) {
        this.children = children;
    }

    public List<LinkSpecification> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<LinkSpecification> dependencies) {
        this.dependencies = dependencies;
    }

    public String getFullExpression() {
        return this.fullExpression;
    }

    public void setFullExpression(String fullExpression) {
        this.fullExpression = fullExpression;
    }

    public LinkSpecification getParent() {
        return this.parent;
    }

    public void setParent(LinkSpecification parent) {
        this.parent = parent;
    }

    public String getProperty1() {
        return this.prop1;
    }

    public String getProperty2() {
        return this.prop2;
    }

    public double getQuality() {
        return this.quality;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    public double getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(double lowThreshold) {
        this.lowThreshold = lowThreshold;
    }
}

