/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.rewriter;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.rewriter.Rewriter;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgebraicRewriter
extends Rewriter {
    static Logger logger = LoggerFactory.getLogger(AlgebraicRewriter.class);

    @Override
    public LinkSpecification rewrite(LinkSpecification spec) {
        if (spec.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (spec.size() <= 1) {
            return spec;
        }
        int newSize = spec.size();
        LinkSpecification result = spec;
        try {
            int oldSize;
            do {
                System.out.println(spec);
                oldSize = newSize;
                spec = this.updateThresholds(spec);
                spec = this.computeAllDependencies(spec);
                spec = this.collapseSpec(spec);
                spec = this.removeUnaryOperators(spec);
                spec = this.removeDuplicates(spec);
                newSize = spec.size();
                result = spec;
            } while (newSize < oldSize);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public LinkSpecification updateThresholds(LinkSpecification spec) {
        if (spec == null) {
            return spec;
        }
        if (spec.isEmpty()) {
            return spec;
        }
        if (spec.isAtomic()) {
            return spec;
        }
        if (!spec.isAtomic()) {
            if (spec.getFilterExpression() == null) {
                double min = 1.0;
                for (LinkSpecification child : spec.getChildren()) {
                    if (!(child.getThreshold() < min)) continue;
                    min = child.getThreshold();
                }
                if (spec.getThreshold() <= min) {
                    spec.setThreshold(0.0);
                }
            }
            for (LinkSpecification child : spec.getChildren()) {
                LinkSpecification linkSpecification = this.updateThresholds(child);
            }
        }
        return spec;
    }

    public LinkSpecification removeDuplicates(LinkSpecification spec) {
        LinkSpecification right;
        LinkSpecification left;
        if (!spec.isAtomic() && spec.getChildren().size() == 2 && (left = this.removeDuplicates(spec.getChildren().get(0))).equals(right = this.removeDuplicates(spec.getChildren().get(1)))) {
            spec = left;
            double theta = Math.max(spec.getThreshold(), left.getThreshold());
            spec.setThreshold(theta);
        }
        return spec;
    }

    public LinkSpecification removeUnaryOperators(LinkSpecification spec) {
        System.out.println("removeUnaryOperators: " + spec);
        System.out.println("removeUnaryOperators: " + spec.isAtomic());
        if (!spec.isAtomic()) {
            if (spec.getFilterExpression() == null && spec.getChildren().size() == 1) {
                double theta = Math.max(spec.getThreshold(), spec.getChildren().get(0).getThreshold());
                System.out.print("Old spec = " + spec);
                spec = spec.getChildren().get(0);
                spec.setThreshold(theta);
                System.out.println("New spec = " + spec);
                System.out.println(spec.isAtomic());
            }
            if (!spec.isAtomic()) {
                ArrayList<LinkSpecification> newChildren = new ArrayList<LinkSpecification>();
                for (LinkSpecification child : spec.getChildren()) {
                    System.out.println("child spec = " + child);
                    newChildren.add(this.removeUnaryOperators(child));
                }
                spec.setChildren(newChildren);
            }
        }
        return spec;
    }

    public LinkSpecification computeAtomicDependency(LinkSpecification source, LinkSpecification target) {
        String measure2;
        String measure1;
        if (!source.isAtomic() || !target.isAtomic()) {
            return source;
        }
        if (this.getProperties(source).equals(this.getProperties(target)) && (measure1 = this.getMeasure(source)).equals(measure2 = this.getMeasure(target))) {
            if (source.getThreshold() <= target.getThreshold()) {
                source.addDependency(target);
            } else {
                double t1 = source.getThreshold();
                double t2 = target.getThreshold();
                if (!measure1.equals("trigrams") && measure2.equals("overlap") && measure2.equals("jaccard") && t2 <= 2.0 * t1 / (1.0 + t1)) {
                    source.addDependency(target);
                }
            }
        }
        return source;
    }

    public List<String> getProperties(LinkSpecification spec) {
        ArrayList<String> result = new ArrayList<String>();
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.getFilterExpression(), spec.getThreshold());
            result.add(p.getLeftTerm());
            result.add(p.getRightTerm());
        }
        return result;
    }

    public String getMeasure(LinkSpecification spec) {
        if (spec.isAtomic()) {
            return spec.getFilterExpression().substring(0, spec.getFilterExpression().indexOf("("));
        }
        return null;
    }

    public LinkSpecification computeAllDependencies(LinkSpecification spec) {
        spec = this.computeAtomicDependencies(spec);
        spec = this.computeNonAtomicDependencies(spec);
        for (LinkSpecification ls : spec.getAllLeaves()) {
            System.out.println(ls);
            System.out.println(ls.getDependencies());
        }
        return spec;
    }

    public LinkSpecification computeNonAtomicDependencies(LinkSpecification spec) {
        if (!spec.isAtomic()) {
            List<Object> newDependencies = null;
            ArrayList<LinkSpecification> newChildren = new ArrayList<LinkSpecification>();
            for (LinkSpecification linkSpecification : spec.getChildren()) {
                newChildren.add(this.computeNonAtomicDependencies(linkSpecification));
            }
            spec.setChildren(newChildren);
            if (spec.getOperator() == LogicOperator.AND && spec.getChildren().get(0).hasDependencies()) {
                newDependencies = spec.getChildren().get(0).getDependencies();
                for (int i = 1; i < spec.getChildren().size() && spec.getChildren().get(i).hasDependencies(); ++i) {
                    newDependencies.retainAll(spec.getChildren().get(i).getDependencies());
                }
            }
            if (spec.getOperator() == LogicOperator.OR) {
                newDependencies = new ArrayList();
                for (LinkSpecification linkSpecification : spec.getChildren()) {
                    if (!linkSpecification.hasDependencies()) continue;
                    newDependencies.addAll(linkSpecification.getDependencies());
                }
            }
            spec.setDependencies(null);
            if (newDependencies != null) {
                for (LinkSpecification linkSpecification : newDependencies) {
                    if (!(linkSpecification.getThreshold() > spec.getThreshold()) && spec.getThreshold() != 0.0) continue;
                    spec.addDependency(linkSpecification);
                }
            }
        }
        return spec;
    }

    public LinkSpecification computeAtomicDependencies(LinkSpecification spec) {
        List<LinkSpecification> leaves = spec.getAllLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            leaves.get(i).setDependencies(new ArrayList<LinkSpecification>());
            for (int j = 0; j < leaves.size(); ++j) {
                if (i == j) continue;
                leaves.set(i, this.computeAtomicDependency(leaves.get(i), leaves.get(j)));
            }
        }
        return spec;
    }

    public LinkSpecification collapseSpec(LinkSpecification spec) {
        ArrayList<LinkSpecification> newChildren;
        if (spec == null) {
            return spec;
        }
        if (spec.isAtomic()) {
            return spec;
        }
        if (spec.getOperator() == LogicOperator.AND) {
            newChildren = new ArrayList<LinkSpecification>();
            newChildren.addAll(spec.getChildren());
            for (LinkSpecification child : spec.getChildren()) {
                if (!child.hasDependencies()) continue;
                System.out.println("Dependency found");
                for (LinkSpecification dependency : child.getDependencies()) {
                    System.out.println("Dependency : " + dependency);
                    if (!newChildren.contains(dependency) || newChildren.size() <= 1) continue;
                    newChildren.remove(child);
                    System.out.println("Children after removal: " + newChildren);
                }
            }
            spec.setChildren(newChildren);
        } else if (spec.getOperator() == LogicOperator.OR) {
            newChildren = new ArrayList();
            newChildren.addAll(spec.getChildren());
            for (LinkSpecification child : spec.getChildren()) {
                if (!child.hasDependencies()) continue;
                for (LinkSpecification dependency : child.getDependencies()) {
                    if (!newChildren.contains(dependency) || newChildren.size() <= 1) continue;
                    newChildren.remove(dependency);
                }
            }
            spec.setChildren(newChildren);
        }
        newChildren = new ArrayList();
        for (LinkSpecification child : spec.getChildren()) {
            newChildren.add(this.collapseSpec(child));
        }
        spec.setChildren(newChildren);
        return spec;
    }
}

