/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APRF
implements IQualitativeMeasure {
    static Logger logger = LoggerFactory.getLogger(APRF.class);

    public static double trueFalsePositive(AMapping predictions, AMapping goldStandard, boolean truePositive) {
        double TPCounter = 0.0;
        double FPCounter = 0.0;
        for (String sUri : predictions.getMap().keySet()) {
            for (String tUri : predictions.getMap().get(sUri).keySet()) {
                if (goldStandard.contains(sUri, tUri) && goldStandard.getMap().get(sUri).get(tUri) > 0.0) {
                    TPCounter += 1.0;
                    continue;
                }
                if (goldStandard.contains(sUri, tUri) || !(predictions.getMap().get(sUri).get(tUri) > 0.0)) continue;
                FPCounter += 1.0;
            }
        }
        if (truePositive) {
            return TPCounter;
        }
        return FPCounter;
    }

    public static double falseNegative(AMapping predictions, AMapping goldStandard) {
        double FNCounter = 0.0;
        for (String sUri : goldStandard.getMap().keySet()) {
            for (String tUri : goldStandard.getMap().get(sUri).keySet()) {
                if (!(goldStandard.getMap().get(sUri).get(tUri) > 0.0) || predictions.contains(sUri, tUri) && predictions.getMap().get(sUri).get(tUri) > 0.0) continue;
                FNCounter += 1.0;
            }
        }
        return FNCounter;
    }

    public static double trueNegative(AMapping predictions, GoldStandard goldStandard) {
        double negativesSize = goldStandard.sourceUris.size() * goldStandard.targetUris.size() - predictions.size();
        for (String sUri : predictions.getMap().keySet()) {
            for (String tUri : predictions.getMap().get(sUri).keySet()) {
                if (!predictions.contains(sUri, tUri) || !(predictions.getMap().get(sUri).get(tUri) <= 0.0)) continue;
                negativesSize += 1.0;
            }
        }
        return negativesSize - APRF.falseNegative(predictions, goldStandard.referenceMappings);
    }

    @Override
    public abstract double calculate(AMapping var1, GoldStandard var2);
}

