/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.datastrutures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Tree<T> {
    private List<Tree<T>> children = null;
    private Tree<T> parent;
    private T value;

    public Tree(Tree<T> parent, T value, List<Tree<T>> childrenlist) {
        this.parent = parent;
        this.value = value;
        if (childrenlist != null) {
            for (Tree<T> child : childrenlist) {
                this.children.add(new Tree<T>(this, child.value, child.children));
            }
        }
    }

    public Tree(T value) {
        this.parent = null;
        this.value = value;
        this.children = null;
    }

    public Tree() {
        this.children = null;
        this.parent = null;
        this.value = null;
    }

    public Set<Tree<T>> getLeaves() {
        HashSet<Tree<T>> leaves = new HashSet<Tree<T>>();
        for (Tree<T> child : this.children) {
            if (child.children == null) {
                leaves.add(child);
                continue;
            }
            Set<Tree<T>> childrenLeaves = child.getLeaves();
            for (Tree<T> l : childrenLeaves) {
                leaves.add(l);
            }
        }
        return leaves;
    }

    public void addChild(Tree<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<Tree<T>>();
        }
        this.children.add(child);
        child.parent = this;
    }

    public void removeChild(Tree<T> child) {
        this.children.remove(child);
    }

    public void remove() {
        if (this.children != null && this.children.size() > 0) {
            for (Tree<T> c : this.children) {
                c.remove();
            }
        }
        this.parent.children.remove(this);
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public List<Tree<T>> getchildren() {
        return this.children;
    }

    public T getValue() {
        return this.value;
    }

    public void print() {
        this.print("", true);
    }

    private void print(String prefix, boolean isTail) {
        System.out.println(prefix + (isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + (this.parent == null ? "ROOT(\u27c2)" : this.value));
        if (this.children != null) {
            for (int i = 0; i < this.children.size() - 1; ++i) {
                super.print(prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (this.children.size() > 0) {
                super.print(prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }
    }

    public long size() {
        long size = 0L;
        if (this.children == null || this.children.size() == 0) {
            return 1L;
        }
        for (Tree<T> child : this.children) {
            size += child.size();
        }
        return 1L + size;
    }

    public long depth() {
        if (this.children == null || this.children.size() == 0) {
            return 1L;
        }
        long maxDepth = 0L;
        for (Tree<T> child : this.children) {
            long d = child.depth();
            if (maxDepth >= d) continue;
            maxDepth = d;
        }
        return maxDepth + 1L;
    }

    public long level() {
        long level = 0L;
        Tree<T> t = this;
        while (t.parent != null) {
            ++level;
            t = t.parent;
        }
        return level;
    }
}

