/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.datastrutures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Point {
    public List<Double> coordinates;
    public String label;

    public Point() {
        this.label = "";
        this.coordinates = Arrays.asList(0.0, 0.0);
    }

    public Point(Double ... points) {
        this.label = "";
        this.coordinates = new ArrayList<Double>();
        for (Double p : points) {
            this.coordinates.add(p);
        }
    }

    public Point(String name, List<Double> position) {
        this.label = name;
        this.coordinates = position;
    }

    public static Point add(Point p, Point q) {
        return Point.add(p.label + "+" + q.label, p, q);
    }

    public static Point add(String label, Point p, Point q) {
        List<Double> position = Arrays.asList(0.0, 0.0);
        for (int i = 0; i < p.coordinates.size(); ++i) {
            position.set(i, p.coordinates.get(i) + q.coordinates.get(i));
        }
        return new Point(label, position);
    }

    public static void main(String[] args) {
        Point p = new Point("p", Arrays.asList(1.0, 1.0));
        Point q = new Point("q", Arrays.asList(1.0, 2.0));
        System.out.println(p + "+" + q + " = " + Point.add(p, q));
    }

    public boolean equals(Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob.getClass() != this.getClass()) {
            return false;
        }
        Point other = (Point)ob;
        if (!this.label.equals(other.label)) {
            return false;
        }
        return this.coordinates.equals(other.coordinates);
    }

    public int hashCode() {
        return this.label.hashCode() ^ this.coordinates.hashCode();
    }

    public String toString() {
        return this.coordinates.toString();
    }
}

