/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.aksw.limes.core.io.config.reader.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Checks a link specification against the LIMES DTD.
 *
 * @author Axel-C. Ngonga Ngomo (ngonga@informatik.uni-leipzig.de)
 * @author Mohamed Sherif (sherif@informatik.uni-leipzig.de)
 * @version Jul 12, 2016
 */
public class DtdChecker implements org.xml.sax.ErrorHandler {

    protected boolean valid = true;
    private Logger logger = LoggerFactory.getLogger(DtdChecker.class);

    /**
     * Carries out the validation in case a fatal parsing error occur.
     *
     * @param e Exception generated by the fatal parsing error
     * @throws SAXParseException if XML contains errors
     */
    public void fatalError(SAXParseException e) throws SAXException {
        logger.error(MarkerFactory.getMarker("FATAL"),"Error at " + e.getLineNumber() + " line.");
        logger.error(MarkerFactory.getMarker("FATAL"),e.getMessage());
        valid = false;
    }

    /**
     * Carry out the validation in case a parsing error occurs.
     *
     * @param e
     *         Exception generated by the parsing error
     * @throws SAXParseException Encapsulate an XML parse error or warning
     */
    public void error(SAXParseException e) throws SAXParseException {
        logger.warn("Error at " + e.getLineNumber() + " line.");
        logger.warn(e.getMessage());
        valid = false;
    }

    /**
     * Carry out the validation in case a warning is issued during the parsing.
     *
     * @param err
     *         Exception generated by the warning
     */
    public void warning(SAXParseException err) {
        logger.warn(err.getMessage());
        valid = false;
    }
}

