/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching.stablematching;

import java.util.ArrayList;
import java.util.HashMap;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.matching.stablematching.Hospital;
import org.aksw.limes.core.ml.algorithm.matching.stablematching.Resident;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HospitalResidents {
    static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    HashMap<Integer, String> residentReverseIndex = new HashMap();
    HashMap<String, Integer> hospitalIndex = new HashMap();
    HashMap<String, Integer> residentIndex = new HashMap();
    HashMap<Integer, String> hospitalReverseIndex = new HashMap();

    public AMapping getMatching(AMapping m) {
        double[] preferences;
        int i;
        this.residentReverseIndex = new HashMap();
        this.hospitalIndex = new HashMap();
        this.residentIndex = new HashMap();
        this.hospitalReverseIndex = new HashMap();
        int rCounter = 0;
        int hCounter = 0;
        for (String key : m.getMap().keySet()) {
            this.residentReverseIndex.put(rCounter, key);
            this.residentIndex.put(key, rCounter);
            ++rCounter;
            for (String value : m.getMap().get(key).keySet()) {
                if (this.hospitalIndex.containsKey(value)) continue;
                this.hospitalIndex.put(value, hCounter);
                this.hospitalReverseIndex.put(hCounter, value);
                ++hCounter;
            }
        }
        logger.debug(hCounter + " hospitals and " + rCounter + " residents");
        ArrayList<Resident> residents = new ArrayList<Resident>();
        ArrayList<Hospital> hospitals = new ArrayList<Hospital>();
        for (i = 0; i < rCounter; ++i) {
            int j;
            String r = this.residentReverseIndex.get(i);
            preferences = new double[hCounter];
            for (int j2 = 0; j2 < hCounter; ++j2) {
                preferences[j2] = 0.0;
            }
            for (String h : m.getMap().get(r).keySet()) {
                int index = this.hospitalIndex.get(h);
                preferences[index] = m.getConfidence(r, h);
            }
            for (j = 0; j < hCounter; ++j) {
            }
            preferences = this.sort(preferences);
            for (j = 0; j < hCounter; ++j) {
            }
            residents.add(new Resident(i, preferences));
            residents.get((int)i).label = r;
        }
        for (i = 0; i < hCounter; ++i) {
            String h = this.hospitalReverseIndex.get(i);
            preferences = new double[rCounter];
            for (int j = 0; j < rCounter; ++j) {
                preferences[j] = 0.0;
            }
            for (String r : m.getMap().keySet()) {
                int index = this.residentIndex.get(r);
                preferences[index] = m.getConfidence(r, h);
            }
            preferences = this.sort(preferences);
            if (rCounter % hCounter == 0) {
                hospitals.add(new Hospital(i, rCounter / hCounter, preferences));
            } else {
                hospitals.add(new Hospital(i, rCounter / hCounter + 1, preferences));
            }
            hospitals.get((int)i).label = h;
        }
        AMapping result = MappingFactory.createDefaultMapping();
        ArrayList<ArrayList<Integer>> match = this.getMatching(residents, hospitals);
        for (int i2 = 0; i2 < match.size(); ++i2) {
            for (int j = 0; j < match.get(i2).size(); ++j) {
                String uri1 = this.residentReverseIndex.get(match.get(i2).get(j));
                String uri2 = this.hospitalReverseIndex.get(i2);
                result.add(uri1, uri2, m.getConfidence(uri1, uri2));
            }
        }
        return result;
    }

    public double[] sort(double[] input) {
        double[] result = new double[input.length];
        for (int k = 0; k < input.length; ++k) {
            double max = -2.0;
            int index = 0;
            for (int jj = 0; jj < input.length; ++jj) {
                if (!(input[jj] > max)) continue;
                max = input[jj];
                index = jj;
            }
            result[input.length - k - 1] = index;
            input[index] = -1.0;
        }
        return result;
    }

    public ArrayList<ArrayList<Integer>> getMatching(ArrayList<Resident> r, ArrayList<Hospital> h) {
        ArrayList<Integer> unmatched = new ArrayList<Integer>();
        for (int i = 0; i < r.size(); ++i) {
            unmatched.add(i);
        }
        while (unmatched.size() > 0) {
            logger.debug("unmatched = " + unmatched);
            int residentID = (Integer)unmatched.get(0);
            unmatched.remove(0);
            int bestHospital = r.get(residentID).getNextChoice();
            int rejected = h.get(bestHospital).grantAdmission(residentID);
            if (rejected < 0) continue;
            logger.debug("Unmatched = " + unmatched + "; Rejected = " + rejected);
            unmatched.add(rejected);
        }
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < h.size(); ++i) {
            result.add(h.get((int)i).acceptedResidents);
        }
        logger.debug("Results = " + result);
        return result;
    }
}

