/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.classifier;

public class SimpleClassifier
implements Comparable<SimpleClassifier> {
    protected String measure = null;
    protected String sourceProperty = null;
    protected String targetProperty = null;
    protected double threshold = 1.0;
    protected double weight = 1.0;
    protected double fMeasure = 0.0;

    public SimpleClassifier(String measure, double threshold) {
        this.measure = measure;
        this.threshold = threshold;
    }

    public SimpleClassifier(String measure, double threshold, String sourceProperty, String targetProperty) {
        this.measure = measure;
        this.threshold = threshold;
        this.sourceProperty = sourceProperty;
        this.targetProperty = targetProperty;
    }

    public SimpleClassifier clone() {
        SimpleClassifier copy = new SimpleClassifier(this.measure, this.threshold);
        copy.setfMeasure(this.fMeasure);
        copy.sourceProperty = this.sourceProperty;
        copy.targetProperty = this.targetProperty;
        copy.weight = this.weight;
        return copy;
    }

    public double getfMeasure() {
        return this.fMeasure;
    }

    public void setfMeasure(double fMeasure) {
        this.fMeasure = fMeasure;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getMetricExpression() {
        return this.measure + "(x." + this.sourceProperty + ",y." + this.targetProperty + ")|" + this.threshold;
    }

    public String getSourceProperty() {
        return this.sourceProperty;
    }

    public void setSourceProperty(String sourceProperty) {
        this.sourceProperty = sourceProperty;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        return "(Source: " + this.sourceProperty + " Target: " + this.targetProperty + " Measure: " + this.measure + " Theta = " + this.threshold + " FMeasure = " + this.getfMeasure() + " Weight = " + this.weight + ")";
    }

    public String toLinkSpecString() {
        return "" + this.measure + "(" + this.sourceProperty + " , " + this.targetProperty + "):Theta = " + this.threshold + ", Weight = " + this.weight;
    }

    @Override
    public int compareTo(SimpleClassifier o) {
        if (this.getfMeasure() > o.getfMeasure()) {
            return 1;
        }
        if (this.getfMeasure() < o.getfMeasure()) {
            return -1;
        }
        return 0;
    }
}

