/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.temporal.simpleTemporal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.temporal.TemporalMeasure;

public class PredecessorMeasure
extends TemporalMeasure {
    @Override
    public double getSimilarity(Object object1, Object object2) {
        double sim = 0.0;
        String[] split1 = ((String)object1).split("\\|");
        String[] split2 = ((String)object2).split("\\|");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        long epoch1 = 0L;
        long epoch2 = 0L;
        try {
            Date date1 = df.parse(split1[0]);
            epoch1 = date1.getTime();
        }
        catch (ParseException e) {
            System.err.println("Exiting..");
        }
        try {
            Date date2 = df.parse(split2[0]);
            epoch2 = date2.getTime();
        }
        catch (ParseException e) {
            System.err.println("Exiting..");
        }
        sim = epoch1 > epoch2 ? 1.0 : 0.0;
        return sim;
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        String beginDate1 = this.getFirstProperty(property1);
        String beginDate2 = this.getFirstProperty(property2);
        String s1 = new String(instance1.getProperty(beginDate1).first());
        String s2 = new String(instance2.getProperty(beginDate2).first());
        return this.getSimilarity(s1, s2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "Predecessor";
    }

    @Override
    public String getType() {
        return "temporal";
    }
}

