/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.Arrays;
import java.util.List;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class DoubleMetaphoneMeasure
extends StringMeasure {
    public static List<String> getCode(String word) {
        return Arrays.asList(DoubleMetaphoneMeasure.calculateMetaphone(word));
    }

    private double getProximity(char[] s1, char[] s2) {
        int longer;
        int shorter;
        if (s1.length > s2.length) {
            shorter = s2.length;
            longer = s1.length;
        } else {
            shorter = s1.length;
            longer = s2.length;
        }
        double distance = 0.0;
        for (int i = 0; i < shorter; ++i) {
            if (s1[i] == s2[i]) continue;
            distance += 1.0;
        }
        return 1.0 - distance / (double)longer;
    }

    public double proximity(String s1, String s2) {
        List<String> map1 = DoubleMetaphoneMeasure.getCode(s1);
        List<String> map2 = DoubleMetaphoneMeasure.getCode(s2);
        double proximity = 0.0;
        for (String k1 : map1) {
            for (String k2 : map2) {
                double check = this.getProximity(k1.toCharArray(), k2.toCharArray());
                if (!(check > proximity)) continue;
                proximity = check;
            }
        }
        return proximity;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        return false;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return this.proximity(object1.toString(), object2.toString());
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double value = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.proximity(source, target);
                if (!(sim > value)) continue;
                value = sim;
            }
        }
        return sim;
    }

    @Override
    public String getName() {
        return "doublemeta";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    private static String[] calculateMetaphone(String word) {
        int size = word.length();
        int last = size - 1;
        word = word.toUpperCase() + "     ";
        String[] result = new String[]{"", ""};
        int current = 0;
        boolean slavoGermanic = DoubleMetaphoneMeasure.checkSlavoGermanic(word);
        if (DoubleMetaphoneMeasure.stringAt(word, 0, 2, "GN", "KN", "PN", "WR", "PS", "")) {
            ++current;
        }
        if (DoubleMetaphoneMeasure.getAt(word, 0) == 'X') {
            DoubleMetaphoneMeasure.metaphAdd(result, "S");
            ++current;
        }
        block25: while ((result[0].length() < 4 || result[1].length() < 4) && current <= last) {
            switch (DoubleMetaphoneMeasure.getAt(word, current)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (current == 0) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "A");
                    }
                    ++current;
                    continue block25;
                }
                case 'B': {
                    DoubleMetaphoneMeasure.metaphAdd(result, "P");
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'B') {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case '\u00c7': {
                    DoubleMetaphoneMeasure.metaphAdd(result, "S");
                    ++current;
                    continue block25;
                }
                case 'C': {
                    if (current > 1 && !DoubleMetaphoneMeasure.isVowel(word, current - 2) && DoubleMetaphoneMeasure.stringAt(word, current - 1, 3, "ACH", "") && DoubleMetaphoneMeasure.getAt(word, current + 2) != 'I' && (DoubleMetaphoneMeasure.getAt(word, current + 2) != 'E' || DoubleMetaphoneMeasure.stringAt(word, current - 2, 6, "BACHER", "MACHER", ""))) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        current += 2;
                        continue block25;
                    }
                    if (current == 0 && DoubleMetaphoneMeasure.stringAt(word, current, 6, "CAESAR", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 4, "CHIA", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "CH", "")) {
                        if (current > 0 && DoubleMetaphoneMeasure.stringAt(word, current, 4, "CHAE", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K", "X");
                            current += 2;
                            continue block25;
                        }
                        if (current == 0 && (DoubleMetaphoneMeasure.stringAt(word, current + 1, 5, "HARAC", "HARIS", "") || DoubleMetaphoneMeasure.stringAt(word, current + 1, 3, "HOR", "HYM", "HIA", "HEM", "")) && !DoubleMetaphoneMeasure.stringAt(word, 0, 5, "CHORE", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K");
                            current += 2;
                            continue block25;
                        }
                        if (DoubleMetaphoneMeasure.stringAt(word, 0, 4, "VAN ", "VON ", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 3, "SCH", "") || DoubleMetaphoneMeasure.stringAt(word, current - 2, 6, "ORCHES", "ARCHIT", "ORCHID", "") || DoubleMetaphoneMeasure.stringAt(word, current + 2, 1, "T", "S", "") || (DoubleMetaphoneMeasure.stringAt(word, current - 1, 1, "A", "O", "U", "E", "") || current == 0) && DoubleMetaphoneMeasure.stringAt(word, current + 2, 1, "L", "R", "N", "M", "B", "H", "F", "V", "W", " ", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        } else if (current > 0) {
                            if (DoubleMetaphoneMeasure.stringAt(word, 0, 2, "MC", "")) {
                                DoubleMetaphoneMeasure.metaphAdd(result, "K");
                            } else {
                                DoubleMetaphoneMeasure.metaphAdd(result, "X", "K");
                            }
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "X");
                        }
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "CZ", "") && !DoubleMetaphoneMeasure.stringAt(word, current - 2, 4, "WICZ", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S", "X");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 3, "CIA", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "X");
                        current += 3;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "CC", "") && (current != 1 || DoubleMetaphoneMeasure.getAt(word, 0) != 'M')) {
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 2, 1, "I", "E", "H", "") && !DoubleMetaphoneMeasure.stringAt(word, current + 2, 2, "HU", "")) {
                            if (current == 1 && DoubleMetaphoneMeasure.getAt(word, current - 1) == 'A' || DoubleMetaphoneMeasure.stringAt(word, current - 1, 5, "UCCEE", "UCCES", "")) {
                                DoubleMetaphoneMeasure.metaphAdd(result, "KS");
                            } else {
                                DoubleMetaphoneMeasure.metaphAdd(result, "X");
                            }
                            current += 3;
                            continue block25;
                        }
                        DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "CK", "CG", "CQ", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "CI", "CE", "CY", "")) {
                        if (DoubleMetaphoneMeasure.stringAt(word, current, 3, "CIO", "CIE", "CIA", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S", "X");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S");
                        }
                        current += 2;
                        continue block25;
                    }
                    DoubleMetaphoneMeasure.metaphAdd(result, "K");
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, " C", " Q", " G", "")) {
                        current += 3;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "C", "K", "Q", "") && !DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "CE", "CI", "")) {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'D': {
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "DG", "")) {
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 2, 1, "I", "E", "Y", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "J");
                            current += 3;
                            continue block25;
                        }
                        DoubleMetaphoneMeasure.metaphAdd(result, "TK");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "DT", "DD", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "T");
                        current += 2;
                        continue block25;
                    }
                    DoubleMetaphoneMeasure.metaphAdd(result, "T");
                    ++current;
                    continue block25;
                }
                case 'F': {
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'F' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "F");
                    continue block25;
                }
                case 'G': {
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'H') {
                        if (current > 0 && !DoubleMetaphoneMeasure.isVowel(word, current - 1)) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K");
                            current += 2;
                            continue block25;
                        }
                        if (current < 3 && current == 0) {
                            if (DoubleMetaphoneMeasure.getAt(word, current + 2) == 'I') {
                                DoubleMetaphoneMeasure.metaphAdd(result, "J");
                            } else {
                                DoubleMetaphoneMeasure.metaphAdd(result, "K");
                            }
                            current += 2;
                            continue block25;
                        }
                        if (current > 1 && DoubleMetaphoneMeasure.stringAt(word, current - 2, 1, "B", "H", "D", "") || current > 2 && DoubleMetaphoneMeasure.stringAt(word, current - 3, 1, "B", "H", "D", "") || current > 3 && DoubleMetaphoneMeasure.stringAt(word, current - 4, 1, "B", "H", "")) {
                            current += 2;
                            continue block25;
                        }
                        if (current > 2 && DoubleMetaphoneMeasure.getAt(word, current - 1) == 'U' && DoubleMetaphoneMeasure.stringAt(word, current - 3, 1, "C", "G", "L", "R", "T", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "F");
                        } else if (current > 0 && DoubleMetaphoneMeasure.getAt(word, current - 1) != 'I') {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        }
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'N') {
                        if (current == 1 && DoubleMetaphoneMeasure.isVowel(word, 0) && !slavoGermanic) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "KN", "N");
                        } else if (!DoubleMetaphoneMeasure.stringAt(word, current + 2, 2, "EY", "") && DoubleMetaphoneMeasure.getAt(word, current + 1) != 'Y' && !slavoGermanic) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "N", "KN");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "KN");
                        }
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "LI", "") && !slavoGermanic) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "KL", "L");
                        current += 2;
                        continue block25;
                    }
                    if (current == 0 && (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'Y' || DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER", ""))) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "K", "J");
                        current += 2;
                        continue block25;
                    }
                    if (!(!DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "ER", "") && DoubleMetaphoneMeasure.getAt(word, current + 1) != 'Y' || DoubleMetaphoneMeasure.stringAt(word, 0, 6, "DANGER", "RANGER", "MANGER", "") || DoubleMetaphoneMeasure.stringAt(word, current - 1, 1, "E", "I", "") || DoubleMetaphoneMeasure.stringAt(word, current - 1, 3, "RGY", "OGY", ""))) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "K", "J");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "E", "I", "Y", "") || DoubleMetaphoneMeasure.stringAt(word, current - 1, 4, "AGGI", "OGGI", "")) {
                        if (DoubleMetaphoneMeasure.stringAt(word, 0, 4, "VAN ", "VON ", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 3, "SCH", "") || DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "ET", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "K");
                        } else if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 4, "IER ", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "J");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "J", "K");
                        }
                        current += 2;
                        continue block25;
                    }
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'G' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "K");
                    continue block25;
                }
                case 'H': {
                    if ((current == 0 || DoubleMetaphoneMeasure.isVowel(word, current - 1)) && DoubleMetaphoneMeasure.isVowel(word, current + 1)) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "H");
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'J': {
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 4, "JOSE", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 4, "SAN ", "")) {
                        if (current == 0 && DoubleMetaphoneMeasure.getAt(word, current + 4) == ' ' || DoubleMetaphoneMeasure.stringAt(word, 0, 4, "SAN ", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "H");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "J", "H");
                        }
                        ++current;
                        continue block25;
                    }
                    if (current == 0 && !DoubleMetaphoneMeasure.stringAt(word, current, 4, "JOSE", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "J", "A");
                    } else if (DoubleMetaphoneMeasure.isVowel(word, current - 1) && !slavoGermanic && (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'A' || DoubleMetaphoneMeasure.getAt(word, current + 1) == 'O')) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "J", "H");
                    } else if (current == last) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "J", " ");
                    } else if (!DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "L", "T", "K", "S", "N", "M", "B", "Z", "") && !DoubleMetaphoneMeasure.stringAt(word, current - 1, 1, "S", "K", "L", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "J");
                    }
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'J') {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'K': {
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'K' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "K");
                    continue block25;
                }
                case 'L': {
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'L') {
                        if (current == size - 3 && DoubleMetaphoneMeasure.stringAt(word, current - 1, 4, "ILLO", "ILLA", "ALLE", "") || (DoubleMetaphoneMeasure.stringAt(word, last - 1, 2, "AS", "OS", "") || DoubleMetaphoneMeasure.stringAt(word, last, 1, "A", "O", "")) && DoubleMetaphoneMeasure.stringAt(word, current - 1, 4, "ALLE", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "L", " ");
                            current += 2;
                            continue block25;
                        }
                        current += 2;
                    } else {
                        ++current;
                    }
                    DoubleMetaphoneMeasure.metaphAdd(result, "L");
                    continue block25;
                }
                case 'M': {
                    current = DoubleMetaphoneMeasure.stringAt(word, current - 1, 3, "UMB", "") && (current + 1 == last || DoubleMetaphoneMeasure.stringAt(word, current + 2, 2, "ER", "")) || DoubleMetaphoneMeasure.getAt(word, current + 1) == 'M' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "M");
                    continue block25;
                }
                case 'N': {
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'N' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "N");
                    continue block25;
                }
                case '\u00d1': {
                    ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "N");
                    continue block25;
                }
                case 'P': {
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'H') {
                        DoubleMetaphoneMeasure.metaphAdd(result, "F");
                        current += 2;
                        continue block25;
                    }
                    current = DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "P", "B", "") ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "P");
                    continue block25;
                }
                case 'Q': {
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'Q' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "K");
                    continue block25;
                }
                case 'R': {
                    if (current == last && !slavoGermanic && DoubleMetaphoneMeasure.stringAt(word, current - 2, 2, "IE", "") && !DoubleMetaphoneMeasure.stringAt(word, current - 4, 2, "ME", "MA", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "", "R");
                    } else {
                        DoubleMetaphoneMeasure.metaphAdd(result, "R");
                    }
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'R') {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'S': {
                    if (DoubleMetaphoneMeasure.stringAt(word, current - 1, 3, "ISL", "YSL", "")) {
                        ++current;
                        continue block25;
                    }
                    if (current == 0 && DoubleMetaphoneMeasure.stringAt(word, current, 5, "SUGAR", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "X", "S");
                        ++current;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "SH", "")) {
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "X");
                        }
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 3, "SIO", "SIA", "") || DoubleMetaphoneMeasure.stringAt(word, current, 4, "SIAN", "")) {
                        if (!slavoGermanic) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S", "X");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S");
                        }
                        current += 3;
                        continue block25;
                    }
                    if (current == 0 && DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "M", "N", "L", "W", "") || DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "Z", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S", "X");
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "Z", "")) {
                            current += 2;
                            continue block25;
                        }
                        ++current;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "SC", "")) {
                        if (DoubleMetaphoneMeasure.getAt(word, current + 2) == 'H') {
                            if (DoubleMetaphoneMeasure.stringAt(word, current + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM", "")) {
                                if (DoubleMetaphoneMeasure.stringAt(word, current + 3, 2, "ER", "EN", "")) {
                                    DoubleMetaphoneMeasure.metaphAdd(result, "X", "SK");
                                } else {
                                    DoubleMetaphoneMeasure.metaphAdd(result, "SK");
                                }
                                current += 3;
                                continue block25;
                            }
                            if (current == 0 && !DoubleMetaphoneMeasure.isVowel(word, 3) && DoubleMetaphoneMeasure.getAt(word, 3) != 'W') {
                                DoubleMetaphoneMeasure.metaphAdd(result, "X", "S");
                            } else {
                                DoubleMetaphoneMeasure.metaphAdd(result, "X");
                            }
                            current += 3;
                            continue block25;
                        }
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 2, 1, "I", "E", "Y", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "S");
                            current += 3;
                            continue block25;
                        }
                        DoubleMetaphoneMeasure.metaphAdd(result, "SK");
                        current += 3;
                        continue block25;
                    }
                    if (current == last && DoubleMetaphoneMeasure.stringAt(word, current - 2, 2, "AI", "OI", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "", "S");
                    } else {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S");
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "S", "Z", "")) {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'T': {
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 4, "TION", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "X");
                        current += 3;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 3, "TIA", "TCH", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "X");
                        current += 3;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "TH", "") || DoubleMetaphoneMeasure.stringAt(word, current, 3, "TTH", "")) {
                        if (DoubleMetaphoneMeasure.stringAt(word, current + 2, 2, "OM", "AM", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 4, "VAN ", "VON ", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 3, "SCH", "")) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "T");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "0", "T");
                        }
                        current += 2;
                        continue block25;
                    }
                    current = DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "T", "D", "") ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "T");
                    continue block25;
                }
                case 'V': {
                    current = DoubleMetaphoneMeasure.getAt(word, current + 1) == 'V' ? (current += 2) : ++current;
                    DoubleMetaphoneMeasure.metaphAdd(result, "F");
                    continue block25;
                }
                case 'W': {
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 2, "WR", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "R");
                        current += 2;
                        continue block25;
                    }
                    if (current == 0 && (DoubleMetaphoneMeasure.isVowel(word, current + 1) || DoubleMetaphoneMeasure.stringAt(word, current, 2, "WH", ""))) {
                        if (DoubleMetaphoneMeasure.isVowel(word, current + 1)) {
                            DoubleMetaphoneMeasure.metaphAdd(result, "A", "F");
                        } else {
                            DoubleMetaphoneMeasure.metaphAdd(result, "A");
                        }
                    }
                    if (current == last && DoubleMetaphoneMeasure.isVowel(word, current - 1) || DoubleMetaphoneMeasure.stringAt(word, current - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY", "") || DoubleMetaphoneMeasure.stringAt(word, 0, 3, "SCH", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "", "F");
                        ++current;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current, 4, "WICZ", "WITZ", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "TS", "FX");
                        current += 4;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'X': {
                    if (current != last || !DoubleMetaphoneMeasure.stringAt(word, current - 3, 3, "IAU", "EAU", "") && !DoubleMetaphoneMeasure.stringAt(word, current - 2, 2, "AU", "OU", "")) {
                        DoubleMetaphoneMeasure.metaphAdd(result, "KS");
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 1, "C", "X", "")) {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
                case 'Z': {
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'H') {
                        DoubleMetaphoneMeasure.metaphAdd(result, "J");
                        current += 2;
                        continue block25;
                    }
                    if (DoubleMetaphoneMeasure.stringAt(word, current + 1, 2, "ZO", "ZI", "ZA", "") || slavoGermanic && current > 0 && DoubleMetaphoneMeasure.getAt(word, current - 1) != 'T') {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S", "TS");
                    } else {
                        DoubleMetaphoneMeasure.metaphAdd(result, "S");
                    }
                    if (DoubleMetaphoneMeasure.getAt(word, current + 1) == 'Z') {
                        current += 2;
                        continue block25;
                    }
                    ++current;
                    continue block25;
                }
            }
            ++current;
        }
        return result;
    }

    private static boolean checkSlavoGermanic(String word) {
        return word.contains("W") || word.contains("K") || word.contains("CZ") || word.contains("WITZ");
    }

    private static void metaphAdd(String[] result, String main) {
        result[0] = result[0] + main;
        result[1] = result[1] + main;
    }

    private static void metaphAdd(String[] result, String main, String alt) {
        result[0] = result[0] + main;
        result[1] = result[1] + alt;
    }

    private static char getAt(String word, int index) {
        if (index >= word.length()) {
            return '\u0000';
        }
        return word.charAt(index);
    }

    private static boolean stringAt(String word, int start, int length, String ... values) {
        if (start < 0) {
            return false;
        }
        String target = word.substring(start, start + length);
        for (String test : values) {
            if (!test.equals(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVowel(String word, int at) {
        if (at < 0 || at >= word.length()) {
            return false;
        }
        char it = word.charAt(at);
        return it == 'A' || it == 'E' || it == 'I' || it == 'O' || it == 'U' || it == 'Y';
    }
}

