/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.space;

import java.util.ArrayList;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.space.ISpaceMeasure;
import org.aksw.limes.core.measures.measure.space.SpaceMeasureFactory;

public class BlockIdGenerator {
    int dim = 2;
    ArrayList<Double> thresholds = new ArrayList();
    ArrayList<String> properties = new ArrayList();
    ISpaceMeasure measure;
    Instance zero;

    public BlockIdGenerator(String props, String measureName, double threshold) {
        String[] split = props.split("\\|");
        this.dim = split.length;
        this.measure = SpaceMeasureFactory.getMeasure(measureName, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.thresholds.add(this.measure.getThreshold(i, threshold));
            this.properties.add(split[i]);
        }
    }

    public static ArrayList<ArrayList<Integer>> getBlocksToCompare(ArrayList<Integer> blockId) {
        int dim = blockId.size();
        if (dim == 0) {
            return new ArrayList<ArrayList<Integer>>();
        }
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        result.add(blockId);
        ArrayList<Integer> minus = new ArrayList<Integer>();
        ArrayList<Integer> plus = new ArrayList<Integer>();
        ArrayList<Integer> copy = new ArrayList<Integer>();
        for (int i = 0; i < dim; ++i) {
            minus.add(0);
            copy.add(0);
            plus.add(0);
        }
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while ((double)j < Math.pow(3.0, i)) {
                ArrayList<Integer> id = result.get(j);
                minus = new ArrayList();
                plus = new ArrayList();
                for (int k = 0; k < dim; ++k) {
                    if (k != i) {
                        minus.add(id.get(k));
                        plus.add(id.get(k));
                        continue;
                    }
                    minus.add(id.get(k) - 1);
                    plus.add(id.get(k) + 1);
                }
                result.add(minus);
                result.add(plus);
                ++j;
            }
        }
        return result;
    }

    public ArrayList<Integer> getBlockId(Instance a) {
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (int i = 0; i < this.dim; ++i) {
            double value = Double.parseDouble(a.getProperty(this.properties.get(i)).first());
            int blockId = (int)Math.floor((value + this.thresholds.get(i) / 2.0) / this.thresholds.get(i));
            blockIds.add(blockId);
        }
        return blockIds;
    }
}

