/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.hausdorff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.CentroidIndexedHausdorffMeasure;

public class ScanIndexedHausdorffMeasure
extends CentroidIndexedHausdorffMeasure {
    @Override
    public double computeDistance(Polygon s, Polygon t, double threshold) {
        AMapping knownDistances = MappingFactory.createDefaultMapping();
        Map<Integer, List<Integer>> toCompute = this.initToCompute(s, t, threshold, knownDistances);
        while (!toCompute.isEmpty()) {
            boolean checkTermination = this.checkTermination(s, knownDistances, toCompute, threshold);
            if (checkTermination) {
                return threshold + 1.0;
            }
            toCompute = this.updateToCompute(s, t, threshold, knownDistances, toCompute);
        }
        for (int i = 0; i < s.points.size(); ++i) {
            if (knownDistances.getMap().containsKey(i + "")) continue;
            return threshold + 1.0;
        }
        double max = -1.0;
        for (String sIdx : knownDistances.getMap().keySet()) {
            double min = Double.MAX_VALUE;
            for (String tIdx : knownDistances.getMap().get(sIdx).keySet()) {
                min = Math.min(min, knownDistances.getConfidence(sIdx, tIdx));
            }
            max = Math.max(max, min);
        }
        if (max == -1.0) {
            return threshold + 1.0;
        }
        return max;
    }

    public boolean contains(Map<Integer, List<Integer>> map, int source, int target) {
        if (!map.containsKey(source)) {
            return false;
        }
        return map.get(source).contains(target);
    }

    public double getCurrentApproximation(int sourceIndex, AMapping knownDistances, Map<Integer, List<Integer>> toCompute, double threshold) {
        if (toCompute.containsKey(sourceIndex)) {
            return -1.0;
        }
        if (knownDistances.getMap().containsKey(sourceIndex + "")) {
            HashMap<String, Double> distances = knownDistances.getMap().get(sourceIndex + "");
            double min = Double.MAX_VALUE;
            for (String key : distances.keySet()) {
                double d = distances.get(key);
                min = Math.min(d, min);
            }
            return min;
        }
        return threshold + 1.0;
    }

    public boolean checkTermination(Polygon s, AMapping knownDistances, Map<Integer, List<Integer>> toCompute, double threshold) {
        for (int i = 0; i < s.points.size(); ++i) {
            if (!(this.getCurrentApproximation(i, knownDistances, toCompute, threshold) > threshold)) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, List<Integer>> initToCompute(Polygon sPoly, Polygon tPoly, double threshold, AMapping knownDistances) {
        int i;
        double approx;
        HashMap<Integer, List<Integer>> toCompute = new HashMap<Integer, List<Integer>>();
        double d = ScanIndexedHausdorffMeasure.pointToPointDistance(sPoly.points.get(0), tPoly.points.get(0));
        if (d <= threshold) {
            knownDistances.add("0", "0", d);
        }
        for (int j = 1; j < tPoly.points.size(); ++j) {
            approx = d - this.targetIndex.getDistance(tPoly.uri, tPoly.points.get(0), tPoly.points.get(j));
            if (!(approx <= threshold)) continue;
            if (!toCompute.containsKey(0)) {
                toCompute.put(0, new ArrayList());
            }
            ((List)toCompute.get(0)).add(j);
        }
        for (i = 1; i < sPoly.points.size(); ++i) {
            approx = d - this.targetIndex.getDistance(sPoly.uri, sPoly.points.get(0), sPoly.points.get(i));
            if (!(approx <= threshold)) continue;
            if (!toCompute.containsKey(i)) {
                toCompute.put(i, new ArrayList());
            }
            ((List)toCompute.get(i)).add(0);
        }
        for (i = 1; i < sPoly.points.size(); ++i) {
            approx = d - this.sourceIndex.getDistance(sPoly.uri, sPoly.points.get(0), sPoly.points.get(i));
            for (int j = 1; j < tPoly.points.size(); ++j) {
                if (!(approx - this.targetIndex.getDistance(tPoly.uri, tPoly.points.get(0), tPoly.points.get(j)) <= threshold)) continue;
                if (!toCompute.containsKey(i)) {
                    toCompute.put(i, new ArrayList());
                }
                ((List)toCompute.get(i)).add(j);
            }
        }
        return toCompute;
    }

    public Map<Integer, List<Integer>> updateToCompute(Polygon sPoly, Polygon tPoly, double threshold, AMapping knownDistances, Map<Integer, List<Integer>> toCompute) {
        Map.Entry<Integer, List<Integer>> entries = toCompute.entrySet().iterator().next();
        int sIndex = entries.getKey();
        int tIndex = entries.getValue().get(0);
        double d = ScanIndexedHausdorffMeasure.pointToPointDistance(sPoly.points.get(sIndex), tPoly.points.get(tIndex));
        if (d <= threshold) {
            knownDistances.add(sIndex + "", tIndex + "", d);
        }
        toCompute.get(sIndex).remove(0);
        if (toCompute.get(sIndex).isEmpty()) {
            toCompute.remove(sIndex);
        }
        ArrayList toDelete = new ArrayList();
        for (int n : toCompute.keySet()) {
            for (int tIdx : toCompute.get(n)) {
                double approx = n == sIndex ? Math.abs(d - this.targetIndex.getDistance(tPoly.uri, tPoly.points.get(tIdx), tPoly.points.get(tIndex))) : (tIdx == tIndex ? Math.abs(d - this.sourceIndex.getDistance(sPoly.uri, sPoly.points.get(n), sPoly.points.get(sIndex))) : d - this.targetIndex.getDistance(tPoly.uri, tPoly.points.get(tIdx), tPoly.points.get(tIndex)) - this.sourceIndex.getDistance(sPoly.uri, sPoly.points.get(n), sPoly.points.get(sIndex)));
                if (!(approx > threshold)) continue;
                ArrayList<Integer> entry = new ArrayList<Integer>();
                entry.add(n);
                entry.add(tIdx);
                toDelete.add(entry);
            }
        }
        for (List list : toDelete) {
            if (!toCompute.containsKey(list.get(0))) continue;
            toCompute.get(list.get(0)).remove(list.get(1));
            if (!toCompute.get(list.get(0)).isEmpty()) continue;
            toCompute.remove(list.get(0));
        }
        return toCompute;
    }
}

