/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonReader {
    private static final Logger logger = LoggerFactory.getLogger(PolygonReader.class);
    public static boolean keepPolygons = true;

    public static Set<Polygon> readPolygons(String file) {
        return PolygonReader.readPolygons(file, -1);
    }

    public static Set<Polygon> readPolygons(String file, int numberOfEntries) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Polygon> result = new HashMap<String, Polygon>();
        try {
            BufferedReader buf = new BufferedReader(new FileReader(file));
            String s = buf.readLine();
            while (s != null) {
                while (s.contains("  ")) {
                    s = s.replaceAll(Pattern.quote("  "), " ");
                }
                String[] split = (s = s.replaceAll(Pattern.quote(" "), "\t")).split("\t");
                if (split.length % 2 != 1) {
                    System.err.println("Error: " + split.length + " => " + s);
                } else {
                    if (!result.containsKey(split[0])) {
                        result.put(split[0], new Polygon(split[0]));
                    }
                    for (int i = 1; i < split.length; i += 2) {
                        ((Polygon)result.get(split[0])).add(new Point("", Arrays.asList(Double.parseDouble(split[i + 1]), Double.parseDouble(split[i]))));
                    }
                }
                if (result.keySet().size() != numberOfEntries) {
                    s = buf.readLine();
                    buf.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashSet<Polygon> r = new HashSet<Polygon>();
        if (keepPolygons) {
            for (Polygon p : result.values()) {
                r.add(p);
            }
            logger.info("Read " + r.size() + " polygons done in " + (System.currentTimeMillis() - startTime) + "ms.");
            return r;
        }
        logger.info("Read " + result.size() + " polygons done in " + (System.currentTimeMillis() - startTime) + "ms.");
        return new HashSet<Polygon>(result.values());
    }
}

