/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.AMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.ActiveMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.Eagle;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.SupervisedMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.UnsupervisedMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.WombatComplete;
import org.aksw.limes.core.ml.algorithm.WombatSimple;
import org.aksw.limes.core.ml.algorithm.dragon.Dragon;
import org.aksw.limes.core.ml.algorithm.euclid.BooleanEuclid;
import org.aksw.limes.core.ml.algorithm.euclid.LinearEuclid;
import org.aksw.limes.core.ml.algorithm.euclid.MeshEuclid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLAlgorithmFactory {
    public static final String EAGLE = "eagle";
    public static final String WOMBAT_SIMPLE = "wombat simple";
    public static final String WOMBAT_COMPLETE = "wombat complete";
    public static final String LION = "lion";
    public static final String EUCLID_LINEAR = "euclid linear";
    public static final String EUCLID_BOOLEAN = "euclid boolean";
    public static final String EUCLID_MESH = "euclid mesh";
    public static final String DRAGON = "dragon";
    public static final String SUPERVISED_ACTIVE = "supervised active";
    public static final String SUPERVISED_BATCH = "supervised batch";
    public static final String UNSUPERVISED = "unsupervised";
    public static final String DEFAULT_ML_ALGORITHM = "wombat simple";
    public static final Logger logger = LoggerFactory.getLogger(MLAlgorithmFactory.class);

    public static Class<? extends ACoreMLAlgorithm> getAlgorithmType(String name) {
        if (name.equalsIgnoreCase(EAGLE)) {
            return Eagle.class;
        }
        if (name.equalsIgnoreCase("wombat simple")) {
            return WombatSimple.class;
        }
        if (name.equalsIgnoreCase(WOMBAT_COMPLETE)) {
            return WombatComplete.class;
        }
        if (name.equalsIgnoreCase(EUCLID_LINEAR)) {
            return LinearEuclid.class;
        }
        if (name.equalsIgnoreCase(EUCLID_BOOLEAN)) {
            return BooleanEuclid.class;
        }
        if (name.equalsIgnoreCase(EUCLID_MESH)) {
            return MeshEuclid.class;
        }
        if (name.equalsIgnoreCase(LION)) {
            return Eagle.class;
        }
        if (name.equalsIgnoreCase(DRAGON)) {
            return Dragon.class;
        }
        logger.warn(name + " is not implemented yet. Using '" + "wombat simple" + "'...");
        return WombatSimple.class;
    }

    public static MLImplementationType getImplementationType(String name) {
        if (name.equalsIgnoreCase(SUPERVISED_ACTIVE)) {
            return MLImplementationType.SUPERVISED_ACTIVE;
        }
        if (name.equalsIgnoreCase(SUPERVISED_BATCH)) {
            return MLImplementationType.SUPERVISED_BATCH;
        }
        if (name.equalsIgnoreCase(UNSUPERVISED)) {
            return MLImplementationType.UNSUPERVISED;
        }
        logger.warn(name + " is not implemented yet. Using '" + UNSUPERVISED + "' as default...");
        return MLImplementationType.UNSUPERVISED;
    }

    public static AMLAlgorithm createMLAlgorithm(Class<? extends ACoreMLAlgorithm> clazz, MLImplementationType mlType) throws UnsupportedMLImplementationException {
        switch (mlType) {
            case SUPERVISED_BATCH: {
                return new SupervisedMLAlgorithm(clazz);
            }
            case UNSUPERVISED: {
                return new UnsupervisedMLAlgorithm(clazz);
            }
            case SUPERVISED_ACTIVE: {
                return new ActiveMLAlgorithm(clazz);
            }
        }
        throw new UnsupportedMLImplementationException(clazz.getName());
    }
}

