/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class SoundexMeasure
extends StringMeasure {
    public static final int codeLength = 6;

    public static String getCode(String string) {
        char[] in = string.toUpperCase().toCharArray();
        char[] out = new char[6];
        int j = 0;
        for (int i = 0; i < in.length && j < 6; ++i) {
            if (in[i] == 'A' || in[i] == 'E' || in[i] == 'I' || in[i] == 'O' || in[i] == 'U' || in[i] == 'Y' || in[i] == 'H' || in[i] == 'W') continue;
            if (j == 0) {
                out[j] = in[i];
                ++j;
            } else {
                int t = SoundexMeasure.getCode(in[i]);
                if (t > 0) {
                    out[j] = String.valueOf(t).charAt(0);
                    ++j;
                }
            }
            if (i < in.length - 1 && in[i] == in[i + 1]) {
                ++i;
                continue;
            }
            if (i >= in.length - 2 || in[i] != in[i + 2] || in[i + 1] != 'H' && in[i + 1] != 'W') continue;
            i += 2;
        }
        while (j < 6) {
            out[j] = 48;
            ++j;
        }
        return String.valueOf(out);
    }

    private static int getCode(char x) {
        switch (x) {
            case 'B': 
            case 'F': 
            case 'P': 
            case 'V': {
                return 1;
            }
            case 'C': 
            case 'G': 
            case 'J': 
            case 'K': 
            case 'Q': 
            case 'S': 
            case 'X': 
            case 'Z': {
                return 2;
            }
            case 'D': 
            case 'T': {
                return 3;
            }
            case 'L': {
                return 4;
            }
            case 'M': 
            case 'N': {
                return 5;
            }
            case 'R': {
                return 6;
            }
        }
        return -1;
    }

    public double proximity(String s1, String s2) {
        char[] c1 = SoundexMeasure.getCode(s1).toCharArray();
        char[] c2 = SoundexMeasure.getCode(s2).toCharArray();
        double distance = 0.0;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            distance += 1.0;
        }
        return 1.0 - distance / 6.0;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        return false;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return this.proximity(object1.toString(), object2.toString());
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.proximity(source, target);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "soundex";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

