/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.benchmarking;

import java.util.ArrayList;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.benchmarking.AbstractPolygonModifier;

public class MeasurementErrorModifier
extends AbstractPolygonModifier {
    @Override
    public Polygon modify(Polygon p, double threshold) {
        Polygon q = new Polygon(p.uri);
        ArrayList<Point> points = new ArrayList<Point>();
        for (Point point : p.points) {
            ArrayList<Double> coordinates = new ArrayList<Double>();
            for (Double f : point.coordinates) {
                double delta = Math.random() * threshold;
                double v = Math.random() <= 0.5 ? f + delta : f - delta;
                if (Math.abs(f) <= 90.0 && Math.abs(v) > 90.0) {
                    coordinates.add(Math.signum(v) * (180.0 - Math.abs(v)));
                }
                if (Math.abs(f) <= 180.0 && Math.abs(v) > 180.0) {
                    coordinates.add(Math.signum(v) * (360.0 - Math.abs(v)));
                    continue;
                }
                coordinates.add(v);
            }
            points.add(new Point(point.label, coordinates));
        }
        q.points = points;
        return q;
    }

    @Override
    public String getName() {
        return "MeasurementErrorModifier";
    }
}

