/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.serializer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.serializer.ISerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLSerializer
implements ISerializer {
    PrintWriter writer;
    Logger logger = LoggerFactory.getLogger((String)TTLSerializer.class.getName());
    TreeSet<String> statements;
    Map<String, String> prefixList;
    File folder = new File("");

    public TTLSerializer() {
        this.statements = new TreeSet();
        this.prefixList = new HashMap<String, String>();
    }

    @Override
    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add("<" + subject + "> <" + predicate + "> <" + object + "> .");
    }

    public void flush() {
        try {
            for (String s : this.statements) {
                this.writer.println(s);
            }
            this.statements = new TreeSet();
        }
        catch (Exception e) {
            this.logger.warn("Error writing");
        }
    }

    @Override
    public void writeToFile(AMapping mapping, String predicate, String file) {
        this.open(file);
        this.printPrefixes();
        this.statements = new TreeSet();
        for (String s : mapping.getMap().keySet()) {
            for (String t : mapping.getMap().get(s).keySet()) {
                this.writer.println("<" + s + "> <" + predicate + "> <" + t + "> .");
            }
        }
        this.close();
    }

    public void printPrefixes() {
        try {
            for (String prefix : this.prefixList.keySet()) {
                this.writer.println("@prefix " + prefix + ": <" + this.prefixList.get(prefix) + "> .");
            }
        }
        catch (Exception e) {
            this.logger.warn("Error writing");
        }
    }

    @Override
    public void printStatement(String subject, String predicate, String object, double similarity) {
        try {
            this.writer.println("<" + subject + "> <" + predicate + "> <" + object + "> .");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
            this.logger.warn("Error writing");
        }
    }

    @Override
    public boolean close() {
        try {
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    this.writer.println(s);
                }
            }
            this.writer.close();
        }
        catch (Exception e) {
            this.logger.warn("Error closing PrintWriter");
            this.logger.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean open(String file) {
        try {
            if (!file.contains("/") && !file.contains("\\")) {
                String filePath = this.folder.getAbsolutePath() + File.separatorChar + file;
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            } else {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
        }
        catch (Exception e) {
            this.logger.warn("Error creating PrintWriter");
            this.logger.warn(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "TtlSerializer";
    }

    @Override
    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixList = prefixes;
    }

    @Override
    public String getFileExtension() {
        return "ttl";
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.folder.getAbsolutePath() + File.separatorChar + fileName);
    }

    @Override
    public void setFolderPath(File f) {
        this.folder = f;
    }
}

