/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.preprocessing;

import java.util.regex.Pattern;
import org.aksw.limes.core.exceptions.IllegalNumberOfParametersException;
import org.aksw.limes.core.exceptions.MalformedPreprocessingFunctionException;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.preprocessing.IPreprocessingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APreprocessingFunction
implements IPreprocessingFunction {
    static Logger logger = LoggerFactory.getLogger((String)APreprocessingFunction.class.getName());
    public static final String AT = "@";
    public static final String commaNotInsideQuotation = ",(?!\")";
    public static final Pattern checkFunctionString = Pattern.compile("^\\w+\\(.*\\)$|^\\w+$");

    @Override
    public Instance applyFunction(Instance inst, String property, String ... arguments) {
        this.testIfNumberOfArgumentsIsLegal(arguments);
        return this.applyFunctionAfterCheck(inst, property, arguments);
    }

    public abstract Instance applyFunctionAfterCheck(Instance var1, String var2, String ... var3);

    public void testIfNumberOfArgumentsIsLegal(String ... arguments) throws IllegalNumberOfParametersException {
        if (arguments.length < this.minNumberOfArguments()) {
            throw new IllegalNumberOfParametersException("The function " + this.getClass().toString().replace("org.aksw.limes.core.io.preprocessing.functions.", "") + " takes at least " + this.minNumberOfArguments() + " arguments!");
        }
        if (arguments.length > this.maxNumberOfArguments() && this.maxNumberOfArguments() != -1) {
            throw new IllegalNumberOfParametersException("The function " + this.getClass().toString().replace("org.aksw.limes.core.io.preprocessing.functions.", "") + " takes at most " + this.maxNumberOfArguments() + " arguments!");
        }
    }

    public String[] retrieveArguments(String args) {
        this.sanityCheckArguments(args);
        if (!args.contains("(")) {
            return new String[0];
        }
        args = args.substring(args.indexOf("(") + 1, args.length() - 1);
        String[] argumentsSplit = args.split(commaNotInsideQuotation);
        for (int i = 0; i < argumentsSplit.length; ++i) {
            argumentsSplit[i] = argumentsSplit[i].replaceAll("^\\s+", "");
        }
        return argumentsSplit;
    }

    public void sanityCheckArguments(String args) {
        String permittedUnevenQuotationsRemoved;
        if (((args.length() - args.replace("\"", "").length()) % 2 != 0 || args.contains("\"\"\"")) && ((permittedUnevenQuotationsRemoved = args.replace("\"\"\"", "")).length() - permittedUnevenQuotationsRemoved.replace("\"", "").length()) % 2 != 0) {
            logger.error("Unmatched quotation mark!");
            throw new MalformedPreprocessingFunctionException(args);
        }
        if (!checkFunctionString.matcher(args).find()) {
            throw new MalformedPreprocessingFunctionException(args);
        }
    }

    public String retrieveKeywordArgumentValue(String arg, String keyword) {
        if (keyword != null && !keyword.equals("") && arg.contains(keyword)) {
            String afterKeyword = arg.substring(arg.indexOf(keyword) + keyword.length(), arg.length());
            if (!afterKeyword.startsWith("\"") || !afterKeyword.endsWith("\"")) {
                logger.error("Keyword values must be enclosed in quotation marks!");
                throw new MalformedPreprocessingFunctionException(arg);
            }
            return afterKeyword.substring(1, afterKeyword.length() - 1);
        }
        return "";
    }
}

