/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config.reader.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.rdf.LIMES;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFConfigurationReader
extends AConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(RDFConfigurationReader.class);
    private Model configModel = ModelFactory.createDefaultModel();
    private Resource specsSubject;

    public RDFConfigurationReader(String fileNameOrUri) {
        super(fileNameOrUri);
    }

    public static Model readModel(String fileNameOrUri) {
        long startTime = System.currentTimeMillis();
        Model model = ModelFactory.createDefaultModel();
        try (InputStream in = FileManager.get().open(fileNameOrUri);){
            if (fileNameOrUri.contains(".ttl") || fileNameOrUri.contains(".n3")) {
                logger.info("Opening Turtle file");
                model.read(in, null, "TTL");
            } else if (fileNameOrUri.contains(".rdf")) {
                logger.info("Opening RDFXML file");
                model.read(in, null);
            } else if (fileNameOrUri.contains(".nt")) {
                logger.info("Opening N-Triples file");
                model.read(in, null, "N-TRIPLE");
            } else {
                logger.info("Content negotiation to get RDFXML from " + fileNameOrUri);
                model.read(fileNameOrUri);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("Loading " + fileNameOrUri + " is done in " + (System.currentTimeMillis() - startTime) + "ms.");
        return model;
    }

    @Override
    public Configuration read() {
        return this.read(RDFConfigurationReader.readModel(this.fileNameOrUri));
    }

    public Configuration read(Model configurationModel) {
        RDFNode output;
        this.configModel = configurationModel;
        StmtIterator stats = this.configModel.listStatements(null, RDF.type, (RDFNode)LIMES.LimesSpecs);
        if (!stats.hasNext()) {
            logger.error("Missing " + LIMES.LimesSpecs + ", Exit with error.");
            throw new RuntimeException();
        }
        this.specsSubject = ((Statement)stats.next()).getSubject();
        this.configuration = new Configuration();
        this.configuration.setSourceInfo(new KBInfo());
        this.configuration.setTargetInfo(new KBInfo());
        this.configuration.setPrefixes((HashMap)this.configModel.getNsPrefixMap());
        this.readKBDescription((Resource)this.getObject(this.specsSubject, LIMES.hasSource, true));
        this.readKBDescription((Resource)this.getObject(this.specsSubject, LIMES.hasTarget, true));
        if (this.configModel.contains(this.specsSubject, LIMES.hasMetric, (RDFNode)null)) {
            Resource metric = (Resource)this.getObject(this.specsSubject, LIMES.hasMetric, true);
            this.configuration.setMetricExpression(this.getObject(metric, LIMES.expression, true).toString());
        } else if (this.configModel.contains(this.specsSubject, LIMES.hasMLAlgorithm, (RDFNode)null)) {
            Resource mlAlgorithmUri = this.getObject(this.specsSubject, LIMES.hasMLAlgorithm, true).asResource();
            this.readMLAlgorithmConfigurations(mlAlgorithmUri);
        } else {
            logger.error("Neither Metric nor ML Algorithm provided, exit with error ");
            throw new RuntimeException();
        }
        Resource acceptance = (Resource)this.getObject(this.specsSubject, LIMES.hasAcceptance, true);
        this.configuration.setAcceptanceThreshold(this.parseDouble(this.getObject(acceptance, LIMES.threshold, true).toString()));
        this.configuration.setAcceptanceFile(this.getObject(acceptance, LIMES.file, true).toString());
        this.configuration.setAcceptanceRelation(this.getObject(acceptance, LIMES.relation, true).toString());
        Resource review = (Resource)this.getObject(this.specsSubject, LIMES.hasReview, true);
        this.configuration.setVerificationThreshold(this.parseDouble(this.getObject(review, LIMES.threshold, true).toString()));
        this.configuration.setVerificationFile(this.getObject(review, LIMES.file, true).toString());
        this.configuration.setVerificationRelation(this.getObject(review, LIMES.relation, true).toString());
        RDFNode exeParamsSubject = this.getObject(this.specsSubject, LIMES.hasExecutionParameters, false);
        this.readExecutionParameters(exeParamsSubject);
        RDFNode g = this.getObject(this.specsSubject, LIMES.granularity, false);
        if (g != null) {
            this.configuration.setGranularity(Integer.parseInt(g.toString()));
        }
        if ((output = this.getObject(this.specsSubject, LIMES.outputFormat, false)) != null) {
            this.configuration.setOutputFormat(output.toString());
        }
        return this.configuration;
    }

    protected void readExecutionParameters(RDFNode exeParamsSubject) {
        if (exeParamsSubject != null) {
            Resource exeParamResource = exeParamsSubject.asResource();
            RDFNode exePlanner = this.getObject(exeParamResource, LIMES.executionPlanner, false);
            if (exePlanner != null) {
                this.configuration.setExecutionPlanner(exePlanner.toString());
            } else {
                logger.info("Use default execution planner.");
            }
            RDFNode exeRewriter = this.getObject(exeParamResource, LIMES.executionRewriter, false);
            if (exeRewriter != null) {
                this.configuration.setExecutionPlanner(exeRewriter.toString());
            } else {
                logger.info("Use default execution rewriter.");
            }
            RDFNode exeEngine = this.getObject(exeParamResource, LIMES.executionEngine, false);
            if (exeEngine != null) {
                this.configuration.setExecutionPlanner(exeEngine.toString());
            } else {
                logger.info("Use default execution engine.");
            }
        } else {
            logger.info("Use default execution parameters.");
        }
    }

    private void readMLAlgorithmConfigurations(Resource mlAlgorithmUri) {
        if (this.configModel.contains(mlAlgorithmUri, RDF.type, (RDFNode)LIMES.SupervisedMLAlgorithm)) {
            this.configuration.setMlImplementationType(MLImplementationType.SUPERVISED_BATCH);
            RDFNode trainingDataFile = this.getObject(mlAlgorithmUri, LIMES.hasTrainingDataFile, true);
            this.configuration.setTrainingDataFile(trainingDataFile.toString());
        } else if (this.configModel.contains(mlAlgorithmUri, RDF.type, (RDFNode)LIMES.UnsupervisedMLAlgorithm)) {
            this.configuration.setMlImplementationType(MLImplementationType.UNSUPERVISED);
            RDFNode pfm = this.getObject(mlAlgorithmUri, LIMES.pseudoFMeasure, false);
            if (pfm != null) {
                EvaluatorType evalType = EvaluatorType.valueOf(pfm.toString());
                if (evalType == null) {
                    logger.warn(pfm.toString() + " is not valid pseudo-F-Measure, continue with the default pseudo-F-Measure.");
                } else {
                    this.configuration.setMlPseudoFMeasure(evalType);
                }
            }
        } else if (this.configModel.contains(mlAlgorithmUri, RDF.type, (RDFNode)LIMES.ActiveMLAlgorithm)) {
            this.configuration.setMlImplementationType(MLImplementationType.SUPERVISED_ACTIVE);
        } else {
            logger.warn(mlAlgorithmUri + " missing ML type. use the default type: " + LIMES.UnsupervisedMLAlgorithm);
            this.configuration.setMlImplementationType(MLImplementationType.UNSUPERVISED);
        }
        RDFNode mlAlgorithmName = this.getObject(mlAlgorithmUri, LIMES.mlAlgorithmName, true);
        this.configuration.setMlAlgorithmName(mlAlgorithmName.toString());
        StmtIterator parametersItr = this.configModel.listStatements(null, RDF.type, (RDFNode)LIMES.MLParameter);
        while (parametersItr.hasNext()) {
            Resource ParameterSubject = ((Statement)parametersItr.next()).getSubject();
            RDFNode mlParameterName = this.getObject(ParameterSubject, LIMES.mlParameterName, false);
            RDFNode mlParametervalue = this.getObject(ParameterSubject, LIMES.mlParameterValue, false);
            this.configuration.addMlAlgorithmParameter(mlParameterName.toString(), mlParametervalue.toString());
        }
    }

    public void readKBDescription(Resource kb) {
        Set<RDFNode> restriction;
        KBInfo kbinfo = null;
        if (this.configModel.contains(kb, RDF.type, (RDFNode)LIMES.SourceDataset)) {
            kbinfo = this.configuration.getSourceInfo();
        } else if (this.configModel.contains(kb, RDF.type, (RDFNode)LIMES.TargetDataset)) {
            kbinfo = this.configuration.getTargetInfo();
        } else {
            logger.error("Dataset type missing, either " + LIMES.SourceDataset + " or " + LIMES.TargetDataset + " is required.");
            throw new RuntimeException();
        }
        kbinfo.setId(this.getObject(kb, RDFS.label, true).toString());
        kbinfo.setEndpoint(this.getObject(kb, LIMES.endPoint, true).toString());
        RDFNode graph = this.getObject(kb, LIMES.graph, false);
        if (graph != null) {
            kbinfo.setGraph(graph.toString());
        }
        if ((restriction = this.getObjects(kb, LIMES.restriction, false)) != null) {
            for (RDFNode rDFNode : restriction) {
                String restrictionStr = rDFNode.toString();
                if (restrictionStr.endsWith(".")) {
                    restrictionStr = restrictionStr.substring(0, restrictionStr.length() - 1);
                }
                kbinfo.addRestriction(restrictionStr);
            }
        }
        for (RDFNode rDFNode : this.getObjects(kb, LIMES.property, true)) {
            XMLConfigurationReader.processProperty(kbinfo, rDFNode.toString());
        }
        Set<RDFNode> optionalProperties = this.getObjects(kb, LIMES.optionalProperty, false);
        if (optionalProperties != null) {
            for (RDFNode optionalProperty : optionalProperties) {
                XMLConfigurationReader.processOptionalProperty(kbinfo, optionalProperty.toString());
            }
        }
        kbinfo.setPageSize(this.parseInt(this.getObject(kb, LIMES.pageSize, true).toString()));
        kbinfo.setVar(this.getObject(kb, LIMES.variable, true).toString());
        RDFNode rDFNode = this.getObject(kb, LIMES.type, false);
        if (rDFNode != null) {
            kbinfo.setType(rDFNode.toString().toLowerCase());
        }
        kbinfo.setPrefixes(this.configuration.getPrefixes());
    }

    private int parseInt(String s) {
        if (s.contains("^")) {
            s = s.substring(0, s.indexOf("^"));
        }
        if (s.contains("@")) {
            s = s.substring(0, s.indexOf("@"));
        }
        return Integer.parseInt(s);
    }

    private RDFNode getObject(Resource s, Property p, boolean isMandatory) {
        StmtIterator statements = this.configModel.listStatements(s, p, (RDFNode)null);
        if (statements.hasNext()) {
            return ((Statement)statements.next()).getObject();
        }
        if (isMandatory) {
            logger.error("Missing mandatory property " + p + ", Exit with error.");
            throw new RuntimeException();
        }
        return null;
    }

    private Set<RDFNode> getObjects(Resource s, Property p, boolean isMandatory) {
        HashSet<RDFNode> result = new HashSet<RDFNode>();
        StmtIterator statements = this.configModel.listStatements(s, p, (RDFNode)null);
        while (statements.hasNext()) {
            result.add(((Statement)statements.next()).getObject());
        }
        if (isMandatory && result.size() == 0) {
            logger.error("Missing mandatory property: " + p + ", Exit with error.");
            throw new RuntimeException();
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    private double parseDouble(String s) {
        if (s.contains("^")) {
            s = s.substring(0, s.indexOf("^"));
        }
        if (s.contains("@")) {
            s = s.substring(0, s.indexOf("@"));
        }
        return Double.parseDouble(s);
    }
}

