/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.planner;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.ExtendedLinkSpecification;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.MapperFactory;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureProcessor;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliosPlanner
extends Planner {
    static Logger logger = LoggerFactory.getLogger(HeliosPlanner.class);
    public ACache source;
    public ACache target;
    public IMapper.Language lang;

    public HeliosPlanner(ACache source, ACache target) {
        this.source = source;
        this.target = target;
        this.lang = IMapper.Language.EN;
    }

    public double getAtomicRuntimeCosts(String measure, double threshold) {
        AMapper mapper = null;
        MeasureType type = MeasureFactory.getMeasureType(measure);
        mapper = MapperFactory.createMapper(type);
        return mapper.getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
    }

    public double getAtomicMappingSizes(String measure, double threshold) {
        AMapper mapper = null;
        MeasureType type = MeasureFactory.getMeasureType(measure);
        mapper = MapperFactory.createMapper(type);
        return mapper.getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
    }

    public double getFilterCosts(List<String> measures, int mappingSize) {
        double cost = 0.0;
        if (measures != null) {
            for (String measure : measures) {
                double tempCost = 0.0;
                MeasureType type = MeasureFactory.getMeasureType(measure);
                tempCost = MeasureFactory.createMeasure(type).getRuntimeApproximation(mappingSize);
                cost += tempCost;
            }
        }
        return cost;
    }

    @Override
    public NestedPlan plan(LinkSpecification spec) {
        return this.plan(spec, this.source, this.target, MappingFactory.createDefaultMapping(), MappingFactory.createDefaultMapping());
    }

    public NestedPlan plan(LinkSpecification spec, ACache source, ACache target, AMapping sourceMapping, AMapping targetMapping) {
        NestedPlan plan = new NestedPlan();
        if (spec == null) {
            return plan;
        }
        if (spec.isEmpty()) {
            return plan;
        }
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.getFilterExpression(), spec.getThreshold());
            plan.setInstructionList(new ArrayList<Instruction>());
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            plan.setRuntimeCost(this.getAtomicRuntimeCosts(p.getOperator(), spec.getThreshold()));
            plan.setMappingSize(this.getAtomicMappingSizes(p.getOperator(), spec.getThreshold()));
            plan.setSelectivity(plan.getMappingSize() / (double)(source.size() * target.size()));
        } else if (!spec.getOperator().equals((Object)LogicOperator.AND)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.setRuntimeCost(0.0);
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
                plan.setRuntimeCost(plan.getRuntimeCost() + childPlan.getRuntimeCost());
            }
            plan.setRuntimeCost(plan.getRuntimeCost() + (double)(spec.getChildren().size() - 1));
            plan.setSubPlans(children);
            plan.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            if (spec.getOperator().equals((Object)LogicOperator.OR)) {
                plan.setOperator(Instruction.Command.UNION);
                double selectivity = 1.0 - ((NestedPlan)children.get(0)).getSelectivity();
                for (int i = 1; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
                }
                plan.setSelectivity(1.0 - selectivity);
            } else if (spec.getOperator().equals((Object)LogicOperator.MINUS)) {
                plan.setOperator(Instruction.Command.DIFF);
                double selectivity = ((NestedPlan)children.get(0)).getSelectivity();
                for (int i = 1; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
                }
                plan.setSelectivity(selectivity);
            } else if (spec.getOperator().equals((Object)LogicOperator.XOR)) {
                plan.setOperator(Instruction.Command.XOR);
                double selectivity = ((NestedPlan)children.get(0)).getSelectivity();
                for (int i = 1; i < children.size(); ++i) {
                    selectivity = (1.0 - (1.0 - selectivity) * (1.0 - ((NestedPlan)children.get(i)).getSelectivity())) * (1.0 - selectivity * ((NestedPlan)children.get(i)).getSelectivity());
                }
                plan.setSelectivity(selectivity);
            }
            if (plan.getFilteringInstruction().getMeasureExpression() != null) {
                plan.setRuntimeCost(plan.getRuntimeCost() + MeasureProcessor.getCosts(plan.getFilteringInstruction().getMeasureExpression(), (double)(source.size() * target.size()) * plan.getSelectivity()));
            }
        } else if (spec.getOperator().equals((Object)LogicOperator.AND)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.setRuntimeCost(0.0);
            double selectivity = 1.0;
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child);
                children.add(childPlan);
                plan.setRuntimeCost(plan.getRuntimeCost() + childPlan.getRuntimeCost());
                selectivity *= childPlan.getSelectivity();
            }
            plan = this.getBestConjunctivePlan(spec, children, selectivity);
        }
        return plan;
    }

    public NestedPlan getBestConjunctivePlan(LinkSpecification spec, List<NestedPlan> plans, double selectivity) {
        if (plans == null) {
            return null;
        }
        if (plans.isEmpty()) {
            return new NestedPlan();
        }
        if (plans.size() == 1) {
            return plans.get(0);
        }
        if (plans.size() == 2) {
            return this.getBestConjunctivePlan(spec, plans.get(0), plans.get(1), selectivity);
        }
        NestedPlan left = plans.get(0);
        plans.remove(plans.get(0));
        return this.getBestConjunctivePlan(spec, left, plans, selectivity);
    }

    public NestedPlan getBestConjunctivePlan(LinkSpecification spec, NestedPlan left, List<NestedPlan> plans, double selectivity) {
        if (plans == null) {
            return left;
        }
        if (plans.isEmpty()) {
            return left;
        }
        if (plans.size() == 1) {
            return this.getBestConjunctivePlan(spec, left, plans.get(0), selectivity);
        }
        NestedPlan right = this.getBestConjunctivePlan(spec, plans, selectivity);
        return this.getBestConjunctivePlan(spec, left, right, selectivity);
    }

    public NestedPlan getBestConjunctivePlan(LinkSpecification spec, NestedPlan left, NestedPlan right, double selectivity) {
        double runtime1 = 0.0;
        NestedPlan result = new NestedPlan();
        runtime1 = left.getRuntimeCost() + right.getRuntimeCost();
        result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
        if (result.getFilteringInstruction().getMeasureExpression() != null) {
            runtime1 += MeasureProcessor.getCosts(result.getFilteringInstruction().getMeasureExpression(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * selectivity));
        }
        double runtime2 = left.getRuntimeCost();
        double runtime3 = right.getRuntimeCost();
        double min = Math.min(Math.min(runtime3 += this.getFilterCosts(left.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * left.getSelectivity())), runtime2 += this.getFilterCosts(right.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * right.getSelectivity()))), runtime1);
        if (min == runtime1) {
            result.setOperator(Instruction.Command.INTERSECTION);
            ArrayList<NestedPlan> subplans = new ArrayList<NestedPlan>();
            subplans.add(left);
            subplans.add(right);
            result.setSubPlans(subplans);
        } else if (min == runtime2) {
            String rightChild = spec.getChildren().get(1).getFullExpression();
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, rightChild, spec.getChildren().get(1).getThreshold() + "", -1, -1, 0));
            result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
            result.setOperator(null);
            ArrayList<NestedPlan> subplans = new ArrayList<NestedPlan>();
            subplans.add(left);
            result.setSubPlans(subplans);
        } else {
            String leftChild = spec.getChildren().get(0).getFullExpression();
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, leftChild, spec.getChildren().get(0).getThreshold() + "", -1, -1, 0));
            result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
            result.setOperator(null);
            ArrayList<NestedPlan> subplans = new ArrayList<NestedPlan>();
            subplans.add(right);
            result.setSubPlans(subplans);
        }
        result.setRuntimeCost(min);
        result.setSelectivity(selectivity);
        result.setMappingSize((double)(this.source.size() * this.target.size()) * selectivity);
        return result;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public LinkSpecification normalize(LinkSpecification spec) {
        if (spec.isEmpty()) {
            return spec;
        }
        ExtendedLinkSpecification ls = new ExtendedLinkSpecification(spec.getFullExpression(), spec.getThreshold());
        return ls;
    }
}

