/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine.filter;

import org.aksw.limes.core.execution.engine.filter.IFilter;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.measures.measure.MeasureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearFilter
implements IFilter {
    static Logger logger = LoggerFactory.getLogger(LinearFilter.class);

    @Override
    public AMapping filter(AMapping map, double threshold) {
        double sim = 0.0;
        if (threshold <= 0.0) {
            return map;
        }
        AMapping result = MappingFactory.createDefaultMapping();
        for (String key : map.getMap().keySet()) {
            for (String value : map.getMap().get(key).keySet()) {
                sim = map.getConfidence(key, value);
                if (!(sim >= threshold)) continue;
                result.add(key, value, sim);
            }
        }
        return result;
    }

    @Override
    public AMapping filter(AMapping map, String condition, double threshold, ACache source, ACache target, String sourceVar, String targetVar) {
        double sim = 0.0;
        if (condition == null) {
            logger.error("Null condition in filter function (LinearFilter). Exiting..");
            throw new RuntimeException();
        }
        AMapping result = MappingFactory.createDefaultMapping();
        for (String key : map.getMap().keySet()) {
            Instance s = source.getInstance(key);
            for (String value : map.getMap().get(key).keySet()) {
                Instance t = target.getInstance(value);
                sim = MeasureProcessor.getSimilarity(s, t, condition, threshold, sourceVar, targetVar);
                if (!(sim >= threshold)) continue;
                result.add(s.getUri(), t.getUri(), sim);
            }
        }
        return result;
    }

    @Override
    public AMapping filter(AMapping map, String condition, double threshold, double mainThreshold, ACache source, ACache target, String sourceVar, String targetVar) {
        double sim = 0.0;
        AMapping result = MappingFactory.createDefaultMapping();
        if (condition == null) {
            logger.info("Null condition in extended filter function (LinearFilter). Exiting..");
            throw new RuntimeException();
        }
        for (String key : map.getMap().keySet()) {
            Instance s = source.getInstance(key);
            for (String value : map.getMap().get(key).keySet()) {
                double sim2;
                double minSimilarity;
                Instance t = target.getInstance(value);
                sim = MeasureProcessor.getSimilarity(s, t, condition, threshold, sourceVar, targetVar);
                if (!(sim >= threshold) || !((minSimilarity = Math.min(sim, sim2 = map.getConfidence(key, value))) >= mainThreshold)) continue;
                result.add(key, value, minSimilarity);
            }
        }
        return result;
    }

    @Override
    public AMapping reversefilter(AMapping map, String condition, double threshold, double mainThreshold, ACache source, ACache target, String sourceVar, String targetVar) {
        double sim = 0.0;
        AMapping result = MappingFactory.createDefaultMapping();
        if (condition == null) {
            System.err.println("Null condition in extended reverse filter function (LinearFilter). Exiting..");
            throw new RuntimeException();
        }
        for (String key : map.getMap().keySet()) {
            Instance s = source.getInstance(key);
            for (String value : map.getMap().get(key).keySet()) {
                double sim2;
                Instance t = target.getInstance(value);
                sim = MeasureProcessor.getSimilarity(s, t, condition, threshold, sourceVar, targetVar);
                if (sim != 0.0 || !((sim2 = map.getConfidence(key, value)) >= mainThreshold)) continue;
                result.add(key, value, sim2);
            }
        }
        return result;
    }

    @Override
    public AMapping filter(AMapping map1, AMapping map2, double coef1, double coef2, double threshold, String operation) {
        AMapping m = MappingOperations.intersection(map1, map2);
        AMapping result = MappingFactory.createDefaultMapping();
        if (operation.equalsIgnoreCase("add")) {
            for (String key : m.getMap().keySet()) {
                for (String value : m.getMap().get(key).keySet()) {
                    double sim = coef1 * map1.getConfidence(key, value) + coef2 * map2.getConfidence(key, value);
                    if (!(sim >= threshold)) continue;
                    result.add(key, value, sim);
                }
            }
        } else {
            for (String key : m.getMap().keySet()) {
                for (String value : m.getMap().get(key).keySet()) {
                    double sim = coef1 * coef2 * map1.getConfidence(key, value) * map2.getConfidence(key, value);
                    if (!(sim >= threshold)) continue;
                    result.add(key, value, sim);
                }
            }
        }
        return result;
    }
}

