/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import java.util.HashSet;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.APseudoPRF;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoRecall
extends APseudoPRF {
    static Logger logger = LoggerFactory.getLogger(PseudoRecall.class);

    public PseudoRecall() {
    }

    public PseudoRecall(boolean symmetricPrecision) {
        this();
        this.setSymmetricPrecision(symmetricPrecision);
    }

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        AMapping res = predictions;
        if (this.useOneToOneMapping) {
            res = predictions.getBestOneToNMapping();
        }
        double q = res.getMap().keySet().size();
        HashSet<String> values = new HashSet<String>();
        for (String s : res.getMap().keySet()) {
            for (String t : res.getMap().get(s).keySet()) {
                values.add(t);
            }
        }
        double reference = goldStandard.sourceUris.size() + goldStandard.targetUris.size();
        return (q + (double)values.size()) / reference;
    }
}

