/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.ExecutionEngineFactory;
import org.aksw.limes.core.execution.planning.planner.ExecutionPlannerFactory;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.execution.rewriter.Rewriter;
import org.aksw.limes.core.execution.rewriter.RewriterFactory;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;

public class LSPipeline {
    public static AMapping execute(ACache sourceCache, ACache targetCache, String metricExpression, double threshold, String sourceVar, String targetVar, RewriterFactory.RewriterType rewriterType, ExecutionPlannerFactory.ExecutionPlannerType executionPlannerType, ExecutionEngineFactory.ExecutionEngineType executionEngineType) {
        LinkSpecification ls = new LinkSpecification(metricExpression, threshold);
        return LSPipeline.execute(sourceCache, targetCache, ls, sourceVar, targetVar, rewriterType, executionPlannerType, executionEngineType);
    }

    public static AMapping execute(ACache sourceCache, ACache targetCache, LinkSpecification ls, String sourceVar, String targetVar, RewriterFactory.RewriterType rewriterType, ExecutionPlannerFactory.ExecutionPlannerType executionPlannerType, ExecutionEngineFactory.ExecutionEngineType executionEngineType) {
        Rewriter rw = RewriterFactory.getRewriter(rewriterType);
        assert (rw != null);
        LinkSpecification rwLs = rw.rewrite(ls);
        Planner planner = ExecutionPlannerFactory.getPlanner(executionPlannerType, sourceCache, targetCache);
        assert (planner != null);
        ExecutionEngine engine = ExecutionEngineFactory.getEngine(executionEngineType, sourceCache, targetCache, sourceVar, targetVar);
        assert (engine != null);
        return engine.execute(rwLs, planner);
    }

    public static AMapping execute(ACache sourceCache, ACache targetCache, LinkSpecification ls) {
        return LSPipeline.execute(sourceCache, targetCache, ls, "?x", "?y", RewriterFactory.RewriterType.DEFAULT, ExecutionPlannerFactory.ExecutionPlannerType.DEFAULT, ExecutionEngineFactory.ExecutionEngineType.DEFAULT);
    }
}

