/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.util;

import java.util.HashMap;
import java.util.List;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static Logger logger = LoggerFactory.getLogger((String)Utils.class.getName());

    public static double getPrecision(AMapping reference, AMapping computed) {
        double size = computed.size();
        double count = 0.0;
        for (String key : computed.getMap().keySet()) {
            for (String value : computed.getMap().get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        return count / size;
    }

    public static double getRecall(AMapping reference, AMapping computed) {
        double size = reference.size();
        double count = 0.0;
        for (String key : computed.getMap().keySet()) {
            for (String value : computed.getMap().get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        return count / size;
    }

    public static double getFscore(AMapping reference, AMapping computed) {
        double sizeC = computed.size();
        double sizeR = reference.size();
        double count = 0.0;
        for (String key : computed.getMap().keySet()) {
            for (String value : computed.getMap().get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        double p = count / sizeC;
        double r = count / sizeR;
        return 2.0 * p * r / (p + r);
    }

    public static HashMap<String, Double> getPRF(AMapping reference, AMapping computed) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        double sizeC = computed.size();
        double sizeR = reference.size();
        double count = 0.0;
        for (String key : computed.getMap().keySet()) {
            for (String value : computed.getMap().get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        double p = count / sizeC;
        result.put("precision", p);
        double r = count / sizeR;
        result.put("recall", r);
        result.put("fscore", 2.0 * p * r / (p + r));
        return result;
    }

    private static String splitAtCamelCase(String s) {
        String regex = "([a-z])([A-Z])";
        String replacement = "$1 $2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    public static double getStandardDeviation(List<Double> data) {
        double mean = 0.0;
        int n = data.size();
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data.get(i).doubleValue();
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = data.get(i) - mean;
            sum += v * v;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double getMean(List<Double> data) {
        double mean = 0.0;
        int n = data.size();
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data.get(i).doubleValue();
        }
        return mean /= (double)n;
    }
}

