/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.wombat;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Precision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Recall;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;

public class RefinementNode
implements Comparable<RefinementNode> {
    protected static double rMax = -1.7976931348623157E308;
    protected static boolean saveMapping = true;
    protected double precision = -1.7976931348623157E308;
    protected double recall = -1.7976931348623157E308;
    protected double fMeasure = -1.7976931348623157E308;
    protected double maxFMeasure = 1.0;
    protected AMapping map = MappingFactory.createDefaultMapping();
    protected String metricExpression = new String();

    public RefinementNode() {
    }

    public RefinementNode(double fMeasure, AMapping map, String metricExpression) {
        this.setfMeasure(fMeasure);
        this.setMap(map);
        this.setMetricExpression(metricExpression);
    }

    public RefinementNode(AMapping map, String metricExpression, double fMeasure) {
        this.setfMeasure(fMeasure);
        this.setMap(saveMapping ? map : null);
        this.setMetricExpression(metricExpression);
    }

    public RefinementNode(AMapping map, String metricExpression, AMapping refMap) {
        this.setPrecision(new Precision().calculate(map, new GoldStandard(refMap)));
        this.setRecall(new Recall().calculate(map, new GoldStandard(refMap)));
        this.setfMeasure(this.precision == 0.0 && this.recall == 0.0 ? 0.0 : 2.0 * this.precision * this.recall / (this.precision + this.recall));
        double pMax = this.computeMaxPrecision(map, refMap);
        this.setMaxFMeasure(2.0 * pMax * rMax / (pMax + rMax));
        this.setMap(saveMapping ? map : null);
        this.setMetricExpression(metricExpression);
    }

    public static double getrMax() {
        return rMax;
    }

    public static void setrMax(double rMax) {
        RefinementNode.rMax = rMax;
    }

    public static boolean isSaveMapping() {
        return saveMapping;
    }

    public static void setSaveMapping(boolean saveMapping) {
        RefinementNode.saveMapping = saveMapping;
    }

    @Override
    public int compareTo(RefinementNode o) {
        return (int)(this.fMeasure - o.getFMeasure());
    }

    private double computeMaxPrecision(AMapping map, AMapping refMap) {
        AMapping falsePos = MappingFactory.createDefaultMapping();
        for (String key : map.getMap().keySet()) {
            for (String value : map.getMap().get(key).keySet()) {
                if (!refMap.getMap().containsKey(key) && !refMap.getReversedMap().containsKey(value)) continue;
                falsePos.add(key, value, map.getMap().get(key).get(value));
            }
        }
        AMapping m = MappingOperations.difference(falsePos, refMap);
        return (double)refMap.size() / (double)(refMap.size() + m.size());
    }

    public double getFMeasure() {
        return this.fMeasure;
    }

    public AMapping getMapping() {
        return this.map;
    }

    public double getMaxFMeasure() {
        return 0.0;
    }

    public void setMaxFMeasure(double maxFMeasure) {
        this.maxFMeasure = maxFMeasure;
    }

    public String getMetricExpression() {
        return this.metricExpression;
    }

    public void setMetricExpression(String metricExpression) {
        this.metricExpression = metricExpression;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public void setRecall(double recall) {
        this.recall = recall;
    }

    public void setfMeasure(double fMeasure) {
        this.fMeasure = fMeasure;
    }

    public void setMap(AMapping map) {
        this.map = map;
    }

    public String toString() {
        return this.getMetricExpression() + " (F = " + this.getFMeasure() + ")";
    }
}

