/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching.stablematching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hospital {
    Logger logger = LoggerFactory.getLogger((String)"LIMES");
    HashMap<Integer, Double> residentToWeight;
    int currentChoice;
    int capacity;
    List<Double> sortedPreferences;
    ArrayList<Integer> acceptedResidents;
    int ID;
    public String label;

    public Hospital(int idValue, int capacityValue, double[] preferences) {
        this.ID = idValue;
        this.residentToWeight = new HashMap();
        this.sortedPreferences = new ArrayList<Double>();
        for (int i = 0; i < preferences.length; ++i) {
            this.residentToWeight.put(i, preferences[i]);
            this.sortedPreferences.add(preferences[i]);
        }
        this.capacity = capacityValue;
        Collections.sort(this.sortedPreferences);
        this.acceptedResidents = new ArrayList();
        this.logger.debug("Preferences of hospital " + this.ID + " with capacity " + this.capacity + " is " + this.residentToWeight);
    }

    public int grantAdmission(int resident) {
        if (this.acceptedResidents.size() < this.capacity) {
            this.acceptedResidents.add(resident);
            this.logger.debug("Admission granted by " + this.ID + " to " + resident);
            this.logger.debug("Accepted residents are now " + this.acceptedResidents.size() + "/" + this.capacity);
            this.logger.debug(this.ID + "->" + this.acceptedResidents);
            return -1;
        }
        double min = this.residentToWeight.get(resident);
        int index = -1;
        for (int i = 0; i < this.acceptedResidents.size(); ++i) {
            if (!(this.residentToWeight.get(this.acceptedResidents.get(i)) < min)) continue;
            min = this.residentToWeight.get(resident);
            index = i;
        }
        if (index == -1) {
            this.logger.debug("Rejection of " + resident + " by " + this.ID);
            this.logger.debug(this.ID + "->" + this.acceptedResidents);
            return resident;
        }
        this.logger.debug("Admission granted by " + this.ID + " to " + resident);
        int reject = this.acceptedResidents.get(index);
        this.acceptedResidents.set(index, resident);
        this.logger.debug("Rejection of " + index + " by " + this.ID);
        this.logger.debug(this.ID + "->" + this.acceptedResidents);
        return reject;
    }
}

