/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching;

import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.log4j.Logger;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class LabelBasedClassMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    QGramsDistance metric = new QGramsDistance();
    private Model sourceModel;
    private Model targetModel;

    public LabelBasedClassMapper() {
    }

    public LabelBasedClassMapper(Model sourceModel, Model targetModel) {
        this();
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public AMapping getEntityMapping(String endpoint1, String endpoint2) {
        Set<Node> classes1 = this.getClasses(endpoint1, this.sourceModel);
        Set<Node> classes2 = this.getClasses(endpoint2, this.targetModel);
        AMapping result = MappingFactory.createDefaultMapping();
        for (Node a : classes1) {
            for (Node b : classes2) {
                String s = a.getLocalName().toLowerCase();
                String t = b.getLocalName().toLowerCase();
                result.add(a.getURI(), b.getURI(), this.metric.getSimilarity(s, t));
            }
        }
        return result;
    }

    private Set<Node> getClasses(String endpoint, Model model) {
        HashSet<Node> result = new HashSet<Node>();
        try {
            String query = "SELECT DISTINCT ?y WHERE { ?s a ?y }";
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = model == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln.get("y").asNode());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error while processing classes");
        }
        return result;
    }
}

