/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.classifier.ComplexClassifier;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.BooleanSelfConfigurator;
import org.apache.log4j.Logger;

public class MeshBasedSelfConfigurator
extends BooleanSelfConfigurator {
    static Logger logger = Logger.getLogger(MeshBasedSelfConfigurator.class);
    public static String MAX_STRATEGY = "max";
    public static String MIN_STRATEFY = "min";
    String strategy = MAX_STRATEGY;

    public MeshBasedSelfConfigurator(ACache source, ACache target) {
        super(source, target);
    }

    public MeshBasedSelfConfigurator(ACache source, ACache target, double minCoverage) {
        super(source, target, minCoverage, 1.0);
    }

    public static List<Double> copy(List<Double> l) {
        ArrayList<Double> copy = new ArrayList<Double>();
        for (int i = 0; i < l.size(); ++i) {
            copy.add(l.get(i));
        }
        return copy;
    }

    public static List<List<Double>> generateCoordinates(List<Double> min, List<Double> max, int n) {
        int dimensions = min.size();
        if (dimensions == 0) {
            return null;
        }
        ArrayList<List<Double>> result = new ArrayList<List<Double>>();
        double delta = (max.get(0) - min.get(0)) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> entry = new ArrayList<Double>();
            entry.add(min.get(0) + (double)i * delta);
            result.add(entry);
        }
        for (int dim = 1; dim < dimensions; ++dim) {
            ArrayList buffer = new ArrayList();
            for (int i = 0; i < result.size(); ++i) {
                int j;
                ArrayList<List<Double>> clones = new ArrayList<List<Double>>();
                for (j = 0; j < n; ++j) {
                    clones.add(MeshBasedSelfConfigurator.copy((List)result.get(i)));
                }
                delta = (max.get(dim) - min.get(dim)) / (double)(n - 1);
                for (j = 0; j < n; ++j) {
                    ((List)clones.get(j)).add(min.get(dim) + (double)j * delta);
                    buffer.add(clones.get(j));
                }
            }
            result = buffer;
        }
        return result;
    }

    public Map<Double, AMapping> getMappings(double min, double max, int n, SimpleClassifier cp) {
        HashMap<Double, AMapping> result = new HashMap<Double, AMapping>();
        double delta = (max - min) / (double)(n - 1);
        if (min == 0.0 && max == min) {
            return new HashMap<Double, AMapping>();
        }
        AMapping m = min == 0.0 && max != min ? this.executeClassifier(cp, min + delta) : this.executeClassifier(cp, min);
        for (int i = 0; i < n; ++i) {
            double threshold = min + (double)i * delta;
            if (!(threshold > 0.0)) continue;
            result.put(threshold, m.getSubMap(threshold));
        }
        return result;
    }

    public ComplexClassifier getZoomedHillTop(int gridPoints, int iterations, List<SimpleClassifier> sc) {
        ComplexClassifier cc;
        if (gridPoints < 5) {
            gridPoints = 5;
        }
        ComplexClassifier bestCc = cc = this.getHillTop(gridPoints, sc);
        double delta = 1.0 / ((double)gridPoints - 1.0);
        for (int i = 1; i < iterations; ++i) {
            if (cc.getfMeasure() == 1.0) {
                return cc;
            }
            ArrayList<Double> min = new ArrayList<Double>();
            ArrayList<Double> max = new ArrayList<Double>();
            for (int j = 0; j < cc.getClassifiers().size(); ++j) {
                if (cc.getClassifiers().get(j).getThreshold() >= delta) {
                    min.add(cc.getClassifiers().get(j).getThreshold() - delta);
                } else {
                    min.add(0.0);
                }
                if (cc.getClassifiers().get(j).getThreshold() + delta >= 1.0) {
                    max.add(1.0);
                    continue;
                }
                max.add(cc.getClassifiers().get(j).getThreshold() + delta);
            }
            cc = this.getHillTop(min, max, gridPoints, cc.getClassifiers());
            if (bestCc.getfMeasure() <= cc.getfMeasure()) {
                bestCc = cc;
            } else {
                cc = bestCc;
            }
            delta = 2.0 * delta / ((double)gridPoints - 1.0);
        }
        return bestCc;
    }

    public ComplexClassifier getZoomedHillTop(int gridPoints, long duration, List<SimpleClassifier> sc) {
        ComplexClassifier cc;
        if (gridPoints < 5) {
            gridPoints = 5;
        }
        long start = System.currentTimeMillis();
        ComplexClassifier bestCc = cc = this.getHillTop(gridPoints, sc);
        double delta = 1.0 / ((double)gridPoints - 1.0);
        for (int i = 1; i > 0; ++i) {
            if (cc.getfMeasure() == 1.0) {
                return cc;
            }
            if ((System.currentTimeMillis() - start) / 1000L >= duration) break;
            ArrayList<Double> min = new ArrayList<Double>();
            ArrayList<Double> max = new ArrayList<Double>();
            for (int j = 0; j < cc.getClassifiers().size(); ++j) {
                if (cc.getClassifiers().get(j).getThreshold() >= delta) {
                    min.add(cc.getClassifiers().get(j).getThreshold() - delta);
                } else {
                    min.add(0.0);
                }
                if (cc.getClassifiers().get(j).getThreshold() + delta >= 1.0) {
                    max.add(1.0);
                    continue;
                }
                max.add(cc.getClassifiers().get(j).getThreshold() + delta);
            }
            cc = this.getHillTop(min, max, gridPoints, cc.getClassifiers());
            if (bestCc.getfMeasure() <= cc.getfMeasure()) {
                bestCc = cc;
            } else {
                cc = bestCc;
            }
            delta = 2.0 * delta / ((double)gridPoints - 1.0);
        }
        return bestCc;
    }

    public ComplexClassifier getHillTop(int n, List<SimpleClassifier> sc) {
        ArrayList<Double> min = new ArrayList<Double>();
        ArrayList<Double> max = new ArrayList<Double>();
        for (int i = 0; i < sc.size(); ++i) {
            min.add(0.0);
            max.add(1.0);
        }
        return this.getHillTop(min, max, n, sc);
    }

    public ComplexClassifier getHillTop(List<Double> min, List<Double> max, int n, List<SimpleClassifier> sc) {
        int j;
        double sum;
        List point;
        List<List<Double>> coordinates = MeshBasedSelfConfigurator.generateCoordinates(min, max, n);
        HashMap<Double, Map<Double, AMapping>> mappings = new HashMap<Double, Map<Double, AMapping>>();
        for (int i = 0; i < sc.size(); ++i) {
            mappings.put(new Double(i), this.getMappings(min.get(i), max.get(i), n, sc.get(i)));
        }
        double bestF = -1.0;
        ArrayList<List<Double>> highestPoints = new ArrayList<List<Double>>();
        AMapping bestMapping = MappingFactory.createDefaultMapping();
        AMapping m = MappingFactory.createDefaultMapping();
        for (int i = 0; i < coordinates.size(); ++i) {
            double f;
            List<Double> meshPoint = coordinates.get(i);
            ArrayList<AMapping> currentMappings = new ArrayList<AMapping>();
            for (int j2 = 0; j2 < meshPoint.size(); ++j2) {
                if (!(meshPoint.get(j2) > 0.0)) continue;
                currentMappings.add((AMapping)((Map)mappings.get(new Double(j2))).get(meshPoint.get(j2)));
            }
            if (currentMappings.isEmpty()) {
                f = 0.0;
            } else {
                m = MeshBasedSelfConfigurator.getIntersection(currentMappings);
                f = this.computeQuality(m);
            }
            if (f > bestF) {
                highestPoints = new ArrayList();
                highestPoints.add(meshPoint);
                bestF = f;
                bestMapping = m;
                continue;
            }
            if (f != bestF) continue;
            highestPoints.add(meshPoint);
        }
        double bestSum = -1.0;
        List bestPoint = null;
        if (highestPoints.size() == 1) {
            bestPoint = (List)highestPoints.get(0);
        } else if (this.strategy.toLowerCase().startsWith(MAX_STRATEGY)) {
            for (int i = 0; i < highestPoints.size(); ++i) {
                point = (List)highestPoints.get(i);
                sum = 0.0;
                for (j = 0; j < point.size(); ++j) {
                    sum += ((Double)point.get(j)).doubleValue();
                }
                if (!(sum > bestSum)) continue;
                bestPoint = point;
                bestSum = sum;
            }
        } else {
            bestSum = sc.size();
            for (int i = 0; i < highestPoints.size(); ++i) {
                point = (List)highestPoints.get(i);
                sum = 0.0;
                for (j = 0; j < point.size(); ++j) {
                    sum += ((Double)point.get(j)).doubleValue();
                }
                if (!(sum < bestSum)) continue;
                bestPoint = point;
                bestSum = sum;
            }
        }
        ArrayList<SimpleClassifier> scList = new ArrayList<SimpleClassifier>();
        for (int i = 0; i < sc.size(); ++i) {
            if (!((Double)bestPoint.get(i) > 0.0)) continue;
            scList.add(sc.get(i).clone());
            ((SimpleClassifier)scList.get(scList.size() - 1)).setThreshold((Double)bestPoint.get(i));
        }
        ComplexClassifier cc = new ComplexClassifier(scList, bestF);
        cc.setMapping(bestMapping);
        return cc;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }
}

