/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.controller.LSPipeline;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorFactory;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.measure.AMeasure;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.ISelfConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearSelfConfigurator
implements ISelfConfigurator {
    public boolean STRICT = true;
    public int ITERATIONS_MAX = 1000;
    public double MIN_THRESHOLD = 0.3;
    static Logger logger = LoggerFactory.getLogger(LinearSelfConfigurator.class);
    Strategy strategy = Strategy.FMEASURE;
    QMeasureType qMeasureType = QMeasureType.UNSUPERVISED;
    public ACache source;
    public ACache target;
    Map<String, Double> sourcePropertiesCoverageMap;
    Map<String, Double> targetPropertiesCoverageMap;
    List<SimpleClassifier> buffer;
    double beta = 1.0;
    Map<String, String> measures = new HashMap<String, String>();
    public double learningRate = 0.25;
    public double kappa = 0.9;
    public double min_coverage = 0.9;
    private IQualitativeMeasure qMeasure = null;
    AMapping reference = MappingFactory.createDefaultMapping();
    public AMapping asked = MappingFactory.createDefaultMapping();

    public void setPFMType(QMeasureType qMeasureType) {
        this.qMeasureType = qMeasureType;
        switch (qMeasureType) {
            case SUPERVISED: {
                this.qMeasure = EvaluatorFactory.create(EvaluatorType.F_MEASURE);
                break;
            }
            case UNSUPERVISED: {
                this.qMeasure = EvaluatorFactory.create(EvaluatorType.PF_MEASURE);
            }
        }
    }

    public void setMeasure(IQualitativeMeasure pfm) {
        this.qMeasureType = QMeasureType.UNSUPERVISED;
        this.qMeasure = pfm;
    }

    public LinearSelfConfigurator(ACache source, ACache target) {
        this(source, target, 0.9, 1.0);
    }

    public LinearSelfConfigurator(ACache source, ACache target, double minCoverage, double beta, Map<String, String> measures) {
        this(source, target, minCoverage, beta);
        this.measures = measures;
    }

    public LinearSelfConfigurator(ACache source, ACache target, double minCoverage, double beta) {
        this.source = source;
        this.target = target;
        this.beta = beta;
        this.sourcePropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(source, minCoverage);
        this.targetPropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(target, minCoverage);
        this.setPFMType(this.qMeasureType);
        this.setDefaultMeasures();
    }

    public void setDefaultMeasures() {
        this.measures = new HashMap<String, String>();
        this.measures.put("euclidean", "numeric");
        this.measures.put("levenshtein", "string");
        this.measures.put("jaccard", "string");
        this.measures.put("trigrams", "string");
    }

    @Override
    public void computeMeasure(ACache source, ACache target, String[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getThreshold() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AMapping getResults() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Map<String, Double> getPropertyStats(ACache c, double minCoverage) {
        HashMap<String, Double> buffer = new HashMap<String, Double>();
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Instance i : c.getAllInstances()) {
            for (String p : i.getAllProperties()) {
                if (!buffer.containsKey(p)) {
                    buffer.put(p, 1.0);
                    continue;
                }
                buffer.put(p, (Double)buffer.get(p) + 1.0);
            }
        }
        double total = c.getAllInstances().size();
        for (String p : buffer.keySet()) {
            double coverage = (Double)buffer.get(p) / total;
            if (!(coverage >= minCoverage)) continue;
            result.put(p, coverage);
        }
        return result;
    }

    @Override
    public String getMeasure() {
        return null;
    }

    @Override
    public void setMeasure(AMeasure measure) {
    }

    public static String getPropertyType(ACache c, String p) {
        for (Instance i : c.getAllInstances()) {
            if (!i.getAllProperties().contains(p)) continue;
            for (String value : i.getProperty(p)) {
                if (value.matches("[0-9]*\\.*[0-9]*")) continue;
                return "string";
            }
        }
        return "numeric";
    }

    public List<SimpleClassifier> getAllInitialClassifiers() {
        ArrayList<SimpleClassifier> initialClassifiers = new ArrayList<SimpleClassifier>();
        for (String p : this.sourcePropertiesCoverageMap.keySet()) {
            for (String q : this.sourcePropertiesCoverageMap.keySet()) {
                SimpleClassifier cp = this.getInitialClassifier(p, q, "jaccard");
                initialClassifiers.add(cp);
            }
        }
        return initialClassifiers;
    }

    public List<SimpleClassifier> getBestInitialClassifiers() {
        HashSet<String> measureList = new HashSet<String>();
        measureList.add("cosine");
        measureList.add("levenshtein");
        measureList.add("trigram");
        return this.getBestInitialClassifiers(measureList);
    }

    public List<SimpleClassifier> getBestInitialClassifiers(Set<String> measureList) {
        ArrayList<SimpleClassifier> initialClassifiers = new ArrayList<SimpleClassifier>();
        for (String p : this.sourcePropertiesCoverageMap.keySet()) {
            double fMeasure = 0.0;
            SimpleClassifier bestClassifier = null;
            for (String q : this.targetPropertiesCoverageMap.keySet()) {
                for (String measure : measureList) {
                    SimpleClassifier cps = this.getInitialClassifier(p, q, measure);
                    if (!(cps.getfMeasure() > fMeasure)) continue;
                    bestClassifier = cps.clone();
                    fMeasure = cps.getfMeasure();
                }
            }
            if (bestClassifier == null) continue;
            initialClassifiers.add(bestClassifier);
        }
        return initialClassifiers;
    }

    private SimpleClassifier getInitialClassifier(String sourceProperty, String targetProperty, String measure) {
        double fMax = 0.0;
        double theta = 1.0;
        for (double threshold = 1.0; threshold > this.MIN_THRESHOLD; threshold -= this.learningRate) {
            AMapping mapping = this.execute(sourceProperty, targetProperty, measure, threshold);
            double fMeasure = this.computeQuality(mapping);
            if (this.STRICT) {
                if (fMeasure > fMax) {
                    fMax = fMeasure;
                    theta = threshold;
                }
            } else if (fMeasure >= fMax) {
                fMax = fMeasure;
                theta = threshold;
            }
            if (fMeasure < fMax) break;
        }
        SimpleClassifier cp = new SimpleClassifier(measure, theta);
        cp.setfMeasure(fMax);
        cp.setSourceProperty(sourceProperty);
        cp.setTargetProperty(targetProperty);
        return cp;
    }

    public AMapping getMapping(List<SimpleClassifier> classifiers) {
        classifiers = this.normalizeClassifiers(classifiers);
        HashMap<SimpleClassifier, AMapping> mappings = new HashMap<SimpleClassifier, AMapping>();
        for (int i = 0; i < classifiers.size(); ++i) {
            double threshold = 1.0 + classifiers.get(i).getWeight() - 1.0 / this.kappa;
            if (!(threshold > 0.0)) continue;
            AMapping m = this.executeClassifier(classifiers.get(i), threshold);
            mappings.put(classifiers.get(i), m);
        }
        return this.getOverallMapping(mappings, 1.0);
    }

    public AMapping getOverallMapping(Map<SimpleClassifier, AMapping> mappings, double threshold) {
        if (mappings.isEmpty()) {
            return MappingFactory.createDefaultMapping();
        }
        AMapping reference = mappings.get(mappings.keySet().iterator().next());
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : reference.getMap().keySet()) {
            for (String t : reference.getMap().get(s).keySet()) {
                double score = 0.0;
                for (SimpleClassifier cp : mappings.keySet()) {
                    score += cp.getWeight() * mappings.get(cp).getConfidence(s, t);
                }
                if (!(score >= threshold)) continue;
                result.add(s, t, score);
            }
        }
        return result;
    }

    public List<SimpleClassifier> normalizeClassifiers(List<SimpleClassifier> classifiers) {
        double total = 0.0;
        for (SimpleClassifier cp : classifiers) {
            total += cp.getWeight();
        }
        for (SimpleClassifier cp : classifiers) {
            cp.setWeight(cp.getWeight() / (total * this.kappa));
        }
        return classifiers;
    }

    public List<SimpleClassifier> getInitialOverallClassifiers(List<SimpleClassifier> classifiers) {
        if (this.strategy.equals((Object)Strategy.FMEASURE)) {
            double total = 0.0;
            for (SimpleClassifier cp : classifiers) {
                total += cp.getfMeasure();
            }
            for (SimpleClassifier cp : classifiers) {
                cp.setWeight(cp.getfMeasure() / (total * this.kappa));
            }
        }
        return classifiers;
    }

    public double computeNext(List<SimpleClassifier> classifiers, int index) {
        double newWeight = Math.max(0.0, classifiers.get(index).getWeight() - this.learningRate);
        if (newWeight == classifiers.get(index).getWeight()) {
            logger.info("Computed weight under zero. Skipping.");
        } else {
            classifiers.get(index).setWeight(newWeight);
            classifiers = this.normalizeClassifiers(classifiers);
        }
        AMapping m = this.getMapping(classifiers);
        this.buffer = classifiers;
        return this.computeQuality(m);
    }

    public List<SimpleClassifier> learnClassifer(List<SimpleClassifier> classifiers) {
        AMapping m = this.getMapping(classifiers = this.normalizeClassifiers(classifiers));
        double f = this.computeQuality(m);
        if (f == 1.0) {
            return classifiers;
        }
        int dimensions = classifiers.size();
        int direction = 0;
        int iterations = 0;
        List<SimpleClassifier> bestClassifiers = null;
        double bestF = f;
        while (iterations <= this.ITERATIONS_MAX) {
            ++iterations;
            for (int i = 0; i < dimensions; ++i) {
                double fMeasure = this.computeNext(classifiers, i);
                if (!(fMeasure > bestF)) continue;
                bestF = fMeasure;
                bestClassifiers = this.buffer;
            }
            if (bestF == f) {
                logger.info(">>>> Walking along direction " + direction);
                this.computeNext(classifiers, direction);
                bestClassifiers = this.buffer;
                ++direction;
                direction %= dimensions;
            } else if (bestF < f) {
                return bestClassifiers;
            }
            classifiers = bestClassifiers;
            logger.info(">> Iteration " + iterations + ": " + classifiers + " F-Measure = " + bestF);
        }
        return classifiers;
    }

    public AMapping executeClassifier(SimpleClassifier c, double threshold) {
        return this.execute(c.getSourceProperty(), c.getTargetProperty(), c.getMeasure(), threshold);
    }

    public AMapping execute(String sourceProperty, String targetProperty, String measure, double threshold) {
        String measureExpression = measure + "(x." + sourceProperty + ", y." + targetProperty + ")";
        return LSPipeline.execute(this.source, this.target, new LinkSpecification(measureExpression, threshold));
    }

    public AMapping getBestOneToOneMapping(AMapping m) {
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : m.getMap().keySet()) {
            double maxSim = 0.0;
            HashSet<String> target = new HashSet<String>();
            for (String t : m.getMap().get(s).keySet()) {
                if (m.getConfidence(s, t) == maxSim) {
                    target.add(t);
                }
                if (!(m.getConfidence(s, t) > maxSim)) continue;
                maxSim = m.getConfidence(s, t);
                target = new HashSet();
                target.add(t);
            }
            for (String t : target) {
                result.add(s, t, maxSim);
            }
        }
        return result;
    }

    public Double computeQuality(AMapping map) {
        return this.qMeasure.calculate(map, new GoldStandard(this.reference, this.source.getAllUris(), this.target.getAllUris()));
    }

    public void setSupervisedBatch(AMapping reference) {
        logger.info("Setting training data to " + reference.size() + " links");
        this.qMeasureType = QMeasureType.SUPERVISED;
        this.setPFMType(this.qMeasureType);
        for (String sUri : reference.getMap().keySet()) {
            for (String tUri : reference.getMap().get(sUri).keySet()) {
                double sim = reference.getConfidence(sUri, tUri);
                if (sim > 0.0) {
                    this.reference.add(sUri, tUri, sim);
                }
                this.asked.add(sUri, tUri, sim);
            }
        }
    }

    public AMapping minimizeToKnow(AMapping map) {
        AMapping minimal = MappingFactory.createDefaultMapping();
        for (String sUri : map.getMap().keySet()) {
            for (String tUri : map.getMap().get(sUri).keySet()) {
                if (!this.asked.getMap().containsKey(sUri)) continue;
                for (String knownSuri : this.asked.getMap().keySet()) {
                    if (!this.asked.getMap().get(knownSuri).containsKey(tUri)) continue;
                    minimal.add(sUri, tUri, map.getConfidence(sUri, tUri));
                }
            }
        }
        return minimal;
    }

    public ACache getSource() {
        return this.source;
    }

    public void setSource(ACache source) {
        this.source = source;
    }

    public ACache getTarget() {
        return this.target;
    }

    public void setTarget(ACache target) {
        this.target = target;
    }

    public LinkSpecification getLinkSpecification(List<SimpleClassifier> list) {
        LinkSpecification parent = new LinkSpecification();
        for (SimpleClassifier sc : list) {
            LinkSpecification child = new LinkSpecification();
            child.readSpec(sc.getMetricExpression(), sc.getThreshold());
            child.setParent(parent);
            parent.addChild(child);
        }
        return parent;
    }

    public static enum QMeasureType {
        SUPERVISED,
        UNSUPERVISED;

    }

    public static enum Strategy {
        FMEASURE,
        THRESHOLD,
        PRECISION,
        RECALL;

    }
}

