/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.List;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.BooleanSelfConfigurator;
import org.aksw.limes.core.ml.algorithm.euclid.LinearEuclid;
import org.aksw.limes.core.ml.algorithm.euclid.LinearSelfConfigurator;
import org.apache.log4j.Logger;

public class BooleanEuclid
extends LinearEuclid {
    protected static Logger logger = Logger.getLogger(BooleanEuclid.class);
    static final String ALGORITHM_NAME = "euclid boolean";
    public static final String MAX_THRESHOLD = "max_threshold";

    @Override
    protected void init(List<LearningParameter> learningParameters, ACache sourceCache, ACache targetCache) {
        this.setDefaultParameters();
        super.init(learningParameters, sourceCache, targetCache);
        this.lsc = new BooleanSelfConfigurator(sourceCache, targetCache);
    }

    @Override
    public void setDefaultParameters() {
        double max_thres = 1.0;
        super.setDefaultParameters();
        this.learningParameters.add(new LearningParameter(MAX_THRESHOLD, max_thres, Double.class, 0.0, 1.0, Double.NaN, MAX_THRESHOLD));
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) throws UnsupportedMLImplementationException {
        this.configureEuclid(this.lsc);
        this.lsc.setPFMType(LinearSelfConfigurator.QMeasureType.UNSUPERVISED);
        List<SimpleClassifier> init_classifiers = this.lsc.getBestInitialClassifiers();
        List<SimpleClassifier> result_classifiers = this.lsc.learnClassifer(init_classifiers);
        MLResults result = new MLResults();
        AMapping mapping = this.lsc.getMapping(result_classifiers);
        result.setMapping(mapping);
        result.setQuality(this.lsc.computeQuality(mapping));
        result.setLinkSpecification(this.lsc.getLinkSpecification(result_classifiers));
        result.setClassifiers(result_classifiers);
        for (int i = 0; i < result_classifiers.size(); ++i) {
            result.addDetail(i + ". Classifier ", result_classifiers.get(i));
            AMapping map = this.lsc.executeClassifier(result_classifiers.get(i), result_classifiers.get(i).getThreshold());
            result.addDetail(i + ". Mapping.size= ", map.size());
        }
        return result;
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        assert (mlModel.classifiersSet());
        List<SimpleClassifier> classifiers = mlModel.getClassifiers();
        assert (classifiers.size() > 0);
        BooleanSelfConfigurator le = new BooleanSelfConfigurator(source, target);
        this.configureEuclid(le);
        AMapping map = le.getMapping(classifiers);
        return map;
    }

    @Override
    protected String getName() {
        return ALGORITHM_NAME;
    }
}

