/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTrimmer {
    private static Logger logger = LoggerFactory.getLogger(CacheTrimmer.class);
    AMapping reference = MappingFactory.createDefaultMapping();

    public static AMapping trimExamples(AMapping m, int max) {
        AMapping output = MappingFactory.createDefaultMapping();
        HashMap<String, HashMap<String, Double>> map = m.getMap();
        int count = 0;
        for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
            if (count >= max) break;
            String key = e.getKey();
            HashMap<String, Double> value = e.getValue();
            output.add(key, value);
            ++count;
        }
        return output;
    }

    public static AMapping trimExamplesRandomly(AMapping m, int max) {
        AMapping output = MappingFactory.createDefaultMapping();
        block0: while (output.size() < Math.min(max, m.size())) {
            Random rand = new Random(System.currentTimeMillis());
            if (m.getMap().keySet().size() <= 0) continue;
            String key = m.getMap().keySet().toArray(new String[0])[rand.nextInt(m.getMap().keySet().size())];
            for (String target : m.getMap().get(key).keySet()) {
                if (output.contains(key, target)) continue;
                output.add(key, target, m.getConfidence(key, target));
                continue block0;
            }
        }
        return output;
    }

    public static AMapping getRandomTrainingData(AMapping m, int max) {
        AMapping output = MappingFactory.createDefaultMapping();
        int breakPoint = Math.min(max, m.getMap().keySet().size());
        while (output.getMap().keySet().size() < breakPoint) {
            Random rand = new Random(System.currentTimeMillis());
            String key = m.getMap().keySet().toArray(new String[0])[rand.nextInt(m.getMap().keySet().size())];
            for (String target : m.getMap().get(key).keySet()) {
                if (output.contains(key, target)) continue;
                output.add(key, target, m.getConfidence(key, target));
            }
        }
        return output;
    }

    public static ACache[] processData(ACache sC, ACache tC, AMapping m) {
        if (m.getSize() <= 100) {
            logger.info("Scaling Caches down to " + m);
        }
        ACache[] ret = new ACache[2];
        MemoryCache h1 = new MemoryCache();
        MemoryCache h2 = new MemoryCache();
        HashMap<String, HashMap<String, Double>> map = m.getMap();
        for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
            String key = e.getKey();
            Instance i = sC.getInstance(key);
            if (i == null) {
                logger.info("unable to find instance with key " + key);
                continue;
            }
            ((ACache)h1).addInstance(i);
            HashMap<String, Double> value = e.getValue();
            for (Map.Entry<String, Double> e2 : value.entrySet()) {
                Instance j = tC.getInstance(e2.getKey());
                if (j != null) {
                    ((ACache)h2).addInstance(j);
                    continue;
                }
                logger.info("unable to find instance with key " + e2.getKey());
            }
        }
        ret[0] = h1;
        ret[1] = h2;
        return ret;
    }

    public ACache[] processDataEqually(ACache hc1, ACache hc2, AMapping m, int numberOfQuestions) {
        this.reference.getMap().clear();
        ACache[] ret = new ACache[2];
        MemoryCache h1 = new MemoryCache();
        MemoryCache h2 = new MemoryCache();
        int countQuestions = 0;
        AMapping alreadyAsked = MappingFactory.createDefaultMapping();
        ArrayList<String> uris1 = hc1.getAllUris();
        ArrayList<String> uris2 = hc2.getAllUris();
        while (countQuestions < numberOfQuestions) {
            String uri2;
            Random random = new Random(System.currentTimeMillis());
            String uri1 = uris1.get(random.nextInt(uris1.size()));
            if (alreadyAsked.contains(uri1, uri2 = uris2.get(random.nextInt(uris2.size())))) continue;
            ((ACache)h1).addInstance(hc1.getInstance(uri1));
            ((ACache)h2).addInstance(hc2.getInstance(uri2));
            ++countQuestions;
            if (!m.contains(uri1, uri2)) continue;
            this.reference.add(uri1, uri2, 1.0);
        }
        ret[0] = h1;
        ret[1] = h2;
        logger.info("asking random " + numberOfQuestions + " questions got me " + this.reference.size() + " valid links");
        if (this.reference.getSize() < numberOfQuestions / 2) {
            AMapping ref2 = CacheTrimmer.trimExamplesRandomly(m, numberOfQuestions / 2);
            ACache[] adding = CacheTrimmer.processData(hc1, hc2, ref2);
            HashMap<String, HashMap<String, Double>> map = ref2.getMap();
            for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
                this.reference.add(e.getKey(), e.getValue());
            }
            for (Instance i : adding[0].getAllInstances()) {
                ret[0].addInstance(i);
            }
            for (Instance i : adding[1].getAllInstances()) {
                ret[1].addInstance(i);
            }
            logger.info("adding " + ref2.size() + " valid links and instances.");
        }
        return ret;
    }

    public AMapping getReferenceMapping() {
        return this.reference;
    }
}

