/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import java.math.BigDecimal;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionProblem;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class AddMetric
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = -1303055852196726757L;
    private boolean is_mutateable;

    public AddMetric(GPConfiguration config) throws InvalidConfigurationException {
        this(config, String.class, false);
    }

    public AddMetric(GPConfiguration config, Class<?> a_returnType, boolean mutateable) throws InvalidConfigurationException {
        super(config, 4, a_returnType, 8, new int[]{1, ExpressionProblem.ResourceTerminalType.THRESHOLD.intValue(), 1, ExpressionProblem.ResourceTerminalType.THRESHOLD.intValue()});
        this.is_mutateable = mutateable;
    }

    public static String removeThresholdFromMeasure(String measure) {
        if (measure.lastIndexOf("|") > measure.lastIndexOf(")")) {
            return measure.substring(0, measure.lastIndexOf("|"));
        }
        return measure;
    }

    public String toString() {
        return "ADD(&2*&1,&4*&3)";
    }

    public Class<?> getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0 || a_chromNum == 2) {
            return String.class;
        }
        return CommandGene.DoubleClass;
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        double coef1 = 0.5;
        double coef2 = 0.5;
        String sim1 = (String)a_chrom.execute_object(a_n, 0, args);
        coef1 = a_chrom.execute_double(a_n, 1, args);
        String sim2 = (String)a_chrom.execute_object(a_n, 2, args);
        coef2 = a_chrom.execute_double(a_n, 3, args);
        StringBuffer value = new StringBuffer("ADD");
        value.append("(");
        value.append(new BigDecimal(coef1).setScale(4, 6));
        value.append("*");
        value.append(AddMetric.removeThresholdFromMeasure(sim1));
        value.append(",");
        value.append(new BigDecimal(coef2).setScale(4, 6));
        value.append("*");
        value.append(AddMetric.removeThresholdFromMeasure(sim2));
        value.append(")");
        return value.toString();
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        if (!this.is_mutateable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    public CommandGene applyMutation() throws InvalidConfigurationException {
        return this;
    }

    public Object clone() {
        try {
            AddMetric result = new AddMetric(this.getGPConfiguration(), this.getReturnType(), this.is_mutateable);
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }
}

