/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.core;

import java.util.LinkedList;
import java.util.List;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.aksw.limes.core.ml.algorithm.eagle.genes.AtomicPreprocessingCommand;
import org.aksw.limes.core.ml.algorithm.eagle.genes.ChainedPreprocessingCommand;
import org.aksw.limes.core.ml.algorithm.eagle.genes.MetricCommand;
import org.aksw.limes.core.ml.algorithm.eagle.genes.NestedBoolean;
import org.aksw.limes.core.ml.algorithm.eagle.genes.PointSetMeasure;
import org.aksw.limes.core.ml.algorithm.eagle.genes.PointSetPropertyPair;
import org.aksw.limes.core.ml.algorithm.eagle.genes.StringMeasure;
import org.aksw.limes.core.ml.algorithm.eagle.genes.StringPreprocessMeasure;
import org.aksw.limes.core.ml.algorithm.eagle.genes.StringPropertyPair;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPProblem;
import org.jgap.gp.function.SubProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProblem
extends GPProblem {
    public static CommandGene SUBPROGRAM;
    static Logger logger;
    private boolean learnPreProcessing = false;

    public ExpressionProblem(GPConfiguration a_conf) throws InvalidConfigurationException {
        super(a_conf);
    }

    public ExpressionProblem(GPConfiguration a_conf, boolean learnPreprocessing) throws InvalidConfigurationException {
        this(a_conf);
        this.learnPreProcessing = learnPreprocessing;
    }

    public GPGenotype create() throws InvalidConfigurationException {
        List<CommandGene> nodes;
        LinkSpecGeneticLearnerConfig config = (LinkSpecGeneticLearnerConfig)this.getGPConfiguration();
        Class[] types = new Class[]{LinkSpecification.class};
        Class[][] argTypes = new Class[][]{new Class[0]};
        SUBPROGRAM = new SubProgram((GPConfiguration)config, new Class[]{String.class, String.class, CommandGene.DoubleClass}, true);
        if (!this.learnPreProcessing) {
            logger.info("Creating basic commands ");
            nodes = this.getNormalSetup(config);
        } else {
            logger.info("Creating preprocessing commands ");
            nodes = this.getPreprocessingLearningSetup(config);
        }
        CommandGene[] nodeArray = new CommandGene[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            nodeArray[i] = nodes.get(i);
        }
        CommandGene[][] nodeSets = new CommandGene[][]{nodeArray};
        int[] minDepths = new int[1];
        int[] maxDepths = new int[1];
        minDepths[0] = 0;
        maxDepths[0] = 6;
        boolean[] fullModeAllowed = new boolean[]{true};
        int maxNodes = 100;
        return GPGenotype.randomInitialGenotype((GPConfiguration)config, (Class[])types, (Class[][])argTypes, (CommandGene[][])nodeSets, (int[])minDepths, (int[])maxDepths, (int)maxNodes, (boolean[])fullModeAllowed, (boolean)true);
    }

    private List<CommandGene> getNormalSetup(LinkSpecGeneticLearnerConfig config) throws InvalidConfigurationException {
        List<CommandGene> nodes = this.getBasicNodes(config);
        nodes.addAll(this.getStringMeasures(config));
        return nodes;
    }

    private List<CommandGene> getPreprocessingLearningSetup(LinkSpecGeneticLearnerConfig config) throws InvalidConfigurationException {
        List<CommandGene> nodes = this.getBasicNodes(config);
        nodes.addAll(this.getPreprocessingMeasures(config));
        return nodes;
    }

    private List<CommandGene> getBasicNodes(LinkSpecGeneticLearnerConfig config) throws InvalidConfigurationException {
        int i;
        SUBPROGRAM = new SubProgram((GPConfiguration)config, new Class[]{String.class, String.class, CommandGene.DoubleClass}, true);
        LinkedList<CommandGene> nodes = new LinkedList<CommandGene>();
        nodes.add(SUBPROGRAM);
        nodes.add((CommandGene)new SubProgram((GPConfiguration)config, 2, String.class, 2, 4, true));
        for (i = 0; i < config.getPropertyMapping().stringPropPairs.size(); ++i) {
            nodes.add(new StringPropertyPair(config, PairSimilar.class, ResourceTerminalType.STRINGPROPPAIR.intValue(), true, i));
        }
        nodes.add((CommandGene)new Terminal((GPConfiguration)config, CommandGene.DoubleClass, 0.0, 1.0, false, ResourceTerminalType.THRESHOLD.intValue(), true));
        nodes.add((CommandGene)new Terminal((GPConfiguration)config, CommandGene.DoubleClass, 0.0, 1.0, false, ResourceTerminalType.GOBALTHRESHOLD.intValue(), true));
        nodes.add(new NestedBoolean("AND", config));
        nodes.add(new NestedBoolean("OR", config));
        nodes.add(new MetricCommand(config, LinkSpecification.class));
        if (config.hasPointSetProperties()) {
            nodes.add(new PointSetMeasure("hausdorff", config, String.class, 1, true));
            for (i = 0; i < config.getPropertyMapping().pointsetPropPairs.size(); ++i) {
                nodes.add(new PointSetPropertyPair(config, PairSimilar.class, ResourceTerminalType.POINTSETPROPPAIR.intValue(), true, i));
            }
        }
        if (config.redundantCommands()) {
            int anz;
            nodes.add((CommandGene)new Terminal((GPConfiguration)config, CommandGene.DoubleClass, 0.0, 1.0, false, ResourceTerminalType.GOBALTHRESHOLD.intValue(), true));
            for (anz = 0; anz < 11; ++anz) {
                nodes.add(new MetricCommand(config, LinkSpecification.class));
            }
            for (anz = 0; anz < 11; ++anz) {
                for (int i2 = 0; i2 < config.getPropertyMapping().stringPropPairs.size(); ++i2) {
                    nodes.add(new StringPropertyPair(config, PairSimilar.class, ResourceTerminalType.STRINGPROPPAIR.intValue(), true, i2));
                }
            }
        }
        return nodes;
    }

    private List<CommandGene> getStringMeasures(LinkSpecGeneticLearnerConfig config) throws InvalidConfigurationException {
        LinkedList<CommandGene> nodes = new LinkedList<CommandGene>();
        nodes.add(new StringMeasure("cosine", config, String.class, 1, true));
        nodes.add(new StringMeasure("jaccard", config, String.class, 1, true));
        nodes.add(new StringMeasure("trigram", config, String.class, 1, true));
        nodes.add(new StringMeasure("levenshtein", config, String.class, 1, true));
        nodes.add(new StringMeasure("overlap", config, String.class, 1, true));
        nodes.add(new StringMeasure("qgrams", config, String.class, 1, true));
        return nodes;
    }

    private List<CommandGene> getPreprocessingMeasures(LinkSpecGeneticLearnerConfig config) throws InvalidConfigurationException {
        LinkedList<CommandGene> nodes = new LinkedList<CommandGene>();
        nodes.add(new AtomicPreprocessingCommand("nolang", config));
        nodes.add(new AtomicPreprocessingCommand("cleaniri", config));
        nodes.add(new AtomicPreprocessingCommand("uppercase", config));
        nodes.add(new AtomicPreprocessingCommand("lowercase", config));
        nodes.add(new AtomicPreprocessingCommand("removebraces", config));
        nodes.add(new AtomicPreprocessingCommand("regularAlphabet", config));
        nodes.add(new ChainedPreprocessingCommand("nolang", config));
        nodes.add(new ChainedPreprocessingCommand("uppercase", config));
        nodes.add(new ChainedPreprocessingCommand("lowercase", config));
        nodes.add(new StringPreprocessMeasure("trigrams", config, String.class, true));
        nodes.add(new StringPreprocessMeasure("jaccard", config, String.class, true));
        nodes.add(new StringPreprocessMeasure("cosine", config, String.class, true));
        nodes.add(new StringPreprocessMeasure("levenshtein", config, String.class, true));
        nodes.add(new StringPreprocessMeasure("overlap", config, String.class, true));
        return nodes;
    }

    public boolean getLearnPreProcessing() {
        return this.learnPreProcessing;
    }

    public void setLearnPreProcessing(boolean learnPreProcessing) {
        this.learnPreProcessing = learnPreProcessing;
    }

    static {
        logger = LoggerFactory.getLogger((String)ExpressionProblem.class.getName());
    }

    public static enum ResourceTerminalType {
        STRINGPROPPAIR(1),
        NUMBERPROPPAIR(2),
        THRESHOLD(3),
        DATEPROPPAIR(4),
        POINTSETPROPPAIR(5),
        NUMBERTHRESHOLD(6),
        GOBALTHRESHOLD(7),
        PREPROCESS(10);

        private int m_value;

        private ResourceTerminalType(int a_value) {
            this.m_value = a_value;
        }

        public int intValue() {
            return this.m_value;
        }
    }
}

