/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.core;

import java.util.HashMap;
import java.util.Map;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.ExecutionEngineFactory;
import org.aksw.limes.core.execution.planning.planner.ExecutionPlannerFactory;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.eagle.core.IGPFitnessFunction;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.aksw.limes.core.ml.algorithm.eagle.util.CacheTrimmer;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFitnessFunction
extends IGPFitnessFunction {
    public static final String fScore = "fScore";
    public static final String recall = "recall";
    public static final String precision = "precision";
    private static final long serialVersionUID = 1L;
    static Logger logger = LoggerFactory.getLogger((String)ExpressionFitnessFunction.class.getName());
    private static ExpressionFitnessFunction instance = null;
    protected LinkSpecGeneticLearnerConfig m_config;
    protected AMapping reference;
    protected ACache sC;
    protected ACache tC;
    protected ACache trimmedSourceCache;
    protected ACache trimmedTargetCache;
    protected IQualitativeMeasure measure;
    protected double crossProduct;
    private AMapping trainingData;
    private boolean useFullCaches = false;

    protected ExpressionFitnessFunction(LinkSpecGeneticLearnerConfig a_config) {
        this.m_config = a_config;
        this.sC = a_config.sC != null ? a_config.sC : HybridCache.getData(a_config.source);
        this.tC = a_config.tC != null ? a_config.tC : HybridCache.getData(a_config.target);
    }

    private ExpressionFitnessFunction(LinkSpecGeneticLearnerConfig a_config, IQualitativeMeasure measure, AMapping reference) {
        this(a_config);
        this.m_config = a_config;
        this.reference = reference;
        this.trimKnowledgeBases(reference);
        this.measure = measure;
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
    }

    public static ExpressionFitnessFunction getInstance(LinkSpecGeneticLearnerConfig a_config, IQualitativeMeasure measure, AMapping reference) {
        if (instance == null) {
            instance = new ExpressionFitnessFunction(a_config, measure, reference);
        }
        return instance;
    }

    protected double evaluate(IGPProgram a_subject) {
        return this.calculateRawFitness(a_subject);
    }

    @Override
    public double calculateRawFitness(IGPProgram p) {
        p.getGPConfiguration().clearStack();
        p.getGPConfiguration().clearMemory();
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        AMapping actualMapping = MappingFactory.createDefaultMapping();
        LinkSpecification spec = (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
        String expr = spec.getFilterExpression();
        if (expr == null) {
            return 5.0;
        }
        if (expr.indexOf("falseProp") > -1) {
            return 8.0;
        }
        try {
            actualMapping = !this.useFullCaches ? this.getMapping(this.trimmedSourceCache, this.trimmedTargetCache, spec) : this.getMapping(this.sC, this.tC, spec);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return 8.0;
        }
        double res = this.getMeasure(actualMapping, this.reference, this.crossProduct);
        if (res > 1.0) {
            logger.info("Error Measure > 1: " + res + ". May want to normalize it?");
        }
        actualMapping.getMap().clear();
        actualMapping = null;
        if (Double.isNaN(res)) {
            return 5.0;
        }
        if (res >= 0.0) {
            return Math.abs(1.0 - res);
        }
        return Math.abs(res) + 1.0;
    }

    @Override
    public double calculateRawMeasure(IGPProgram p) {
        ProgramChromosome pc = p.getChromosome(0);
        AMapping actualMapping = MappingFactory.createDefaultMapping();
        Object[] args = new Object[]{};
        LinkSpecification spec = (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
        String expr = spec.getFilterExpression();
        if (expr.indexOf("falseProp") > -1) {
            return 0.0;
        }
        try {
            actualMapping = !this.useFullCaches ? this.getMapping(this.trimmedSourceCache, this.trimmedTargetCache, spec) : this.getMapping(this.sC, this.tC, spec);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return 0.0;
        }
        return this.getMeasure(actualMapping, this.reference, this.crossProduct);
    }

    private double getMeasure(AMapping a_mapping, AMapping reference, double crossProduct) {
        GoldStandard goldStandard = new GoldStandard(reference);
        double quality = this.measure.calculate(a_mapping, goldStandard);
        return quality;
    }

    public ACache getSourceCache() {
        return this.sC;
    }

    public ACache getTargetCache() {
        return this.tC;
    }

    public void destroy() {
        instance = null;
    }

    @Override
    public AMapping getMapping(ACache sourceCache, ACache targetCache, LinkSpecification spec) {
        try {
            ExecutionEngine engine = ExecutionEngineFactory.getEngine(ExecutionEngineFactory.ExecutionEngineType.DEFAULT, sourceCache, targetCache, this.m_config.source.getVar(), this.m_config.target.getVar());
            Planner planner = ExecutionPlannerFactory.getPlanner(ExecutionPlannerFactory.ExecutionPlannerType.DEFAULT, this.sC, this.tC);
            return engine.execute(spec, planner);
        }
        catch (Exception e) {
            logger.error("Exception execution expression " + spec + " on Caches " + sourceCache.size() + ", " + targetCache.size());
            return MappingFactory.createDefaultMapping();
        }
        catch (OutOfMemoryError e) {
            logger.warn("Out of memory trying to get Map for expression\"" + spec + "\".");
            return MappingFactory.createDefaultMapping();
        }
    }

    public void trimKnowledgeBases(AMapping trainingData) {
        this.trimmedSourceCache = this.sC;
        this.trimmedTargetCache = this.tC;
        if (trainingData.size() <= 0) {
            logger.info("Trying to scale down caches to " + trainingData.size() + " reference mapping. Using full caches instead");
            this.trimmedSourceCache = this.sC;
            this.trimmedTargetCache = this.tC;
        }
        this.trainingData = trainingData;
        ACache[] trimmed = CacheTrimmer.processData(this.sC, this.tC, trainingData);
        if (trimmed[0].size() > 0) {
            this.trimmedSourceCache = trimmed[0];
        } else {
            logger.info("Scaling down source cache returned empty cache. Wrong training data was set. Using full Cache instead");
        }
        if (trimmed[1].size() > 0) {
            this.trimmedTargetCache = trimmed[1];
        } else {
            logger.info("Scaling down target cache returned empty cache. Wrong training data was set. Using full Cache instead");
        }
        logger.info("Trimming to " + trimmed[0].size() + " and " + trimmed[1].size() + " caches.");
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
    }

    public void setUseFullCaches(boolean value) {
        this.useFullCaches = value;
    }

    public LinkSpecification getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
    }

    public AMapping getReferenceMapping() {
        return this.reference;
    }

    public void setReferenceMapping(AMapping referenceData) {
        this.reference = referenceData;
    }

    @Override
    public void addToReference(AMapping m) {
        logger.info("Filling reference of size " + this.reference.size() + " with " + m.size() + " additional matches.");
        for (Map.Entry<String, HashMap<String, Double>> e1 : m.getMap().entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                this.reference.add(e1.getKey(), e2.getKey(), 1.0);
            }
        }
        logger.info("Reference has now " + this.reference.size() + " Matches.");
    }

    @Override
    public void fillCachesIncrementally(AMapping matches) {
        for (String sUri : matches.getMap().keySet()) {
            for (String tUri : matches.getMap().get(sUri).keySet()) {
                if (!this.trimmedSourceCache.containsUri(sUri)) {
                    logger.info("Adding instance " + sUri + " to sC");
                    if (this.sC.containsUri(sUri)) {
                        this.trimmedSourceCache.addInstance(this.sC.getInstance(sUri));
                    }
                }
                if (this.trimmedTargetCache.containsUri(tUri)) continue;
                logger.info("Adding instance " + tUri + " to tC");
                if (!this.tC.containsUri(tUri)) continue;
                this.trimmedTargetCache.addInstance(this.tC.getInstance(tUri));
            }
        }
        this.crossProduct = this.trimmedSourceCache.size() * this.trimmedTargetCache.size();
    }

    public void setCaches(ACache sC, ACache tC) {
        this.sC = sC;
        this.tC = tC;
    }
}

