/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.datastrutures.Tree;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.classifier.ExtendedClassifier;
import org.aksw.limes.core.ml.algorithm.wombat.AWombat;
import org.aksw.limes.core.ml.algorithm.wombat.RefinementNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WombatComplete
extends AWombat {
    protected static final String ALGORITHM_NAME = "Wombat Complete";
    protected static Logger logger = LoggerFactory.getLogger(WombatComplete.class);
    protected static boolean usePruning = false;
    protected RefinementNode bestSolutionNode = null;
    protected List<ExtendedClassifier> classifiers = null;
    protected int iterationNr = 0;
    protected Map<String, AMapping> diffs;
    protected int pruneNodeCount = 0;
    protected long pruningTime = 0L;

    protected WombatComplete() {
    }

    @Override
    protected String getName() {
        return ALGORITHM_NAME;
    }

    @Override
    protected void init(List<LearningParameter> lp, ACache sourceCache, ACache targetCache) {
        super.init(lp, sourceCache, targetCache);
        sourceUris = sourceCache.getAllUris();
        targetUris = targetCache.getAllUris();
    }

    @Override
    protected MLResults learn(AMapping trainingData) {
        this.trainingData = trainingData;
        return this.learn();
    }

    private MLResults learn() {
        if (this.bestSolutionNode == null) {
            this.bestSolutionNode = this.findBestSolution();
        }
        String bestMetricExpr = this.bestSolutionNode.getMetricExpression();
        double threshold = Double.parseDouble(bestMetricExpr.substring(bestMetricExpr.lastIndexOf("|") + 1, bestMetricExpr.length()));
        AMapping bestMapping = this.bestSolutionNode.getMapping();
        LinkSpecification bestLS = new LinkSpecification(bestMetricExpr, threshold);
        double bestFMeasure = this.bestSolutionNode.getFMeasure();
        return new MLResults(bestLS, bestMapping, bestFMeasure, null);
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) {
        this.pseudoFMeasure = pfm != null ? pfm : new PseudoFMeasure();
        this.isUnsupervised = true;
        return this.learn();
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        LinkSpecification ls = mlModel.getLinkSpecification();
        return this.getPredictions(ls, source, target);
    }

    @Override
    protected boolean supports(MLImplementationType mlType) {
        return mlType == MLImplementationType.SUPERVISED_BATCH || mlType == MLImplementationType.UNSUPERVISED;
    }

    @Override
    protected AMapping getNextExamples(int size) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException(this.getName());
    }

    @Override
    protected MLResults activeLearn(AMapping oracleMapping) throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException(this.getName());
    }

    public RefinementNode findBestSolution() {
        List<ExtendedClassifier> classifiers = this.findInitialClassifiers();
        this.diffs = this.computeClassifiersDiffPermutations(classifiers);
        this.createRefinementTreeRoot();
        RefinementNode.setrMax(this.computeMaxRecall(classifiers));
        Tree<RefinementNode> mostPromisingNode = this.findMostPromisingNode(this.refinementTreeRoot, false);
        long time = System.currentTimeMillis();
        this.pruneTree(this.refinementTreeRoot, mostPromisingNode.getValue().getFMeasure());
        this.pruningTime += System.currentTimeMillis() - time;
        logger.debug("Most promising node: " + mostPromisingNode.getValue());
        ++this.iterationNr;
        while (mostPromisingNode.getValue().getFMeasure() < this.getMaxFitnessThreshold() && this.refinementTreeRoot.size() - (long)this.pruneNodeCount <= (long)this.getMaxRefinmentTreeSize() && this.iterationNr <= this.getMaxIterationNumber()) {
            logger.debug("Running iteration number " + this.iterationNr);
            ++this.iterationNr;
            mostPromisingNode = this.expandNode(mostPromisingNode);
            mostPromisingNode = this.findMostPromisingNode(this.refinementTreeRoot, false);
            time = System.currentTimeMillis();
            this.pruneTree(this.refinementTreeRoot, mostPromisingNode.getValue().getFMeasure());
            this.pruningTime += System.currentTimeMillis() - time;
            if (mostPromisingNode.getValue().getFMeasure() == -1.7976931348623157E308) break;
            logger.debug("Most promising node: " + mostPromisingNode.getValue());
        }
        RefinementNode bestSolution = this.findMostPromisingNode(this.refinementTreeRoot, true).getValue();
        logger.debug("Overall Best Solution: " + bestSolution);
        if (!RefinementNode.isSaveMapping()) {
            bestSolution.setMap(this.getMapingOfMetricExpression(bestSolution.getMetricExpression()));
        }
        return bestSolution;
    }

    private void pruneTree(Tree<RefinementNode> r, double f) {
        if (!usePruning) {
            return;
        }
        if (r.getchildren() != null && r.getchildren().size() > 0) {
            for (Tree<RefinementNode> child : r.getchildren()) {
                if (child.getValue().getMaxFMeasure() < f) {
                    this.prune(child);
                    continue;
                }
                this.pruneTree(child, f);
            }
        }
    }

    private Map<String, AMapping> computeClassifiersDiffPermutations(List<ExtendedClassifier> c) {
        HashMap<String, AMapping> diffs = new HashMap<String, AMapping>();
        for (int i = 0; i < c.size(); ++i) {
            for (int j = 0; j < c.size(); ++j) {
                if (i == j) continue;
                AMapping m = MappingOperations.difference(c.get(i).getMapping(), c.get(j).getMapping());
                String e = "MINUS(" + c.get(i).getMetricExpression() + "," + c.get(j).getMetricExpression() + ")|0.0";
                diffs.put(e, m);
            }
        }
        return diffs;
    }

    private Tree<RefinementNode> findMostPromisingNode(Tree<RefinementNode> r, boolean overall) {
        if (r.getchildren() == null || r.getchildren().size() == 0) {
            return r;
        }
        Tree<RefinementNode> mostPromisingChild = new Tree<RefinementNode>(new RefinementNode());
        for (Tree<RefinementNode> child : r.getchildren()) {
            if (usePruning && child.getValue().getMaxFMeasure() < mostPromisingChild.getValue().getFMeasure()) {
                long time = System.currentTimeMillis();
                this.prune(child);
                this.pruningTime += System.currentTimeMillis() - time;
            }
            if (!(child.getValue().getFMeasure() >= 0.0)) continue;
            Tree<RefinementNode> promisingChild = this.findMostPromisingNode(child, overall);
            if (promisingChild.getValue().getFMeasure() > mostPromisingChild.getValue().getFMeasure()) {
                mostPromisingChild = promisingChild;
                continue;
            }
            if (promisingChild.getValue().getFMeasure() != mostPromisingChild.getValue().getFMeasure() || this.computeExpressionComplexity(promisingChild) >= this.computeExpressionComplexity(mostPromisingChild)) continue;
            mostPromisingChild = promisingChild;
        }
        if (overall) {
            return mostPromisingChild;
        }
        if (r.getValue().getFMeasure() > mostPromisingChild.getValue().getFMeasure() || r.getValue().getFMeasure() == mostPromisingChild.getValue().getFMeasure() && this.computeExpressionComplexity(r) < this.computeExpressionComplexity(mostPromisingChild)) {
            return r;
        }
        return mostPromisingChild;
    }

    private int computeExpressionComplexity(Tree<RefinementNode> node) {
        String e = node.getValue().getMetricExpression();
        return StringUtils.countMatches((CharSequence)e, (CharSequence)"OR(") + StringUtils.countMatches((CharSequence)e, (CharSequence)"AND(") + StringUtils.countMatches((CharSequence)e, (CharSequence)"MINUS(");
    }

    private void prune(Tree<RefinementNode> t) {
        ++this.pruneNodeCount;
        t.getValue().setMetricExpression("Pruned");
        t.getValue().setPrecision(-1.7976931348623157E308);
        t.getValue().setRecall(-1.7976931348623157E308);
        t.getValue().setfMeasure(-1.7976931348623157E308);
        t.getValue().setMaxFMeasure(-1.7976931348623157E308);
        t.getValue().setMap(null);
        if (t.getchildren() != null && t.getchildren().size() > 0) {
            for (Tree<RefinementNode> child : t.getchildren()) {
                t.removeChild(child);
            }
        }
    }

    private Tree<RefinementNode> expandNode(Tree<RefinementNode> node) {
        List<RefinementNode> childrenNodes = this.refine(node);
        for (RefinementNode n : childrenNodes) {
            if (this.inRefinementTree(n.getMetricExpression())) continue;
            node.addChild(new Tree<RefinementNode>(n));
        }
        if (node.level() == 1L) {
            List<RefinementNode> siblingNodes = this.createConjunctionsWithDiffNodes(node);
            for (RefinementNode n : siblingNodes) {
                if (this.inRefinementTree(n.getMetricExpression())) continue;
                node.getParent().addChild(new Tree<RefinementNode>(n));
            }
        }
        if (this.isVerbose()) {
            System.out.println("Tree size:" + this.refinementTreeRoot.size());
            this.refinementTreeRoot.print();
        }
        return node;
    }

    private List<RefinementNode> refine(Tree<RefinementNode> node) {
        ArrayList<RefinementNode> result = new ArrayList<RefinementNode>();
        String nodeMetricExpr = node.getValue().getMetricExpression();
        if (node.getParent() == null) {
            for (String diffExpr : this.diffs.keySet()) {
                AMapping diffMapping = this.diffs.get(diffExpr);
                result.add(this.createNode(diffMapping, diffExpr));
            }
            return result;
        }
        if (this.isAtomic(nodeMetricExpr)) {
            return this.createDisjunctionsWithDiffNodes(node);
        }
        if (this.isDifference(nodeMetricExpr)) {
            String firstMetricExpr = this.getSubMetricExpressions(nodeMetricExpr).get(0);
            AMapping firstMetricExprMapping = this.getMapingOfMetricExpression(firstMetricExpr);
            result.add(this.createNode(firstMetricExprMapping, firstMetricExpr));
            result.addAll(this.createDisjunctionsWithDiffNodes(node));
            return result;
        }
        if (this.isConjunction(nodeMetricExpr)) {
            return this.applyConOrDisjunction(node);
        }
        if (this.isDisjunction(nodeMetricExpr)) {
            return this.applyConOrDisjunction(node, true);
        }
        logger.error("Wrong metric expression: " + nodeMetricExpr);
        throw new RuntimeException();
    }

    private List<RefinementNode> applyConOrDisjunction(Tree<RefinementNode> node) {
        return this.applyConOrDisjunction(node, false);
    }

    private List<RefinementNode> applyConOrDisjunction(Tree<RefinementNode> node, boolean useDisjunction) {
        ArrayList<RefinementNode> result = new ArrayList<RefinementNode>();
        String childMetricExpr = "";
        String nodeMetricExpr = node.getValue().getMetricExpression();
        List<String> subMetricExpr = this.getSubMetricExpressions(nodeMetricExpr);
        result.add(this.createNode(subMetricExpr.get(0)));
        ArrayList<String> childSubMetricExpr = new ArrayList<String>();
        String operator = useDisjunction ? "OR" : "AND";
        for (int i = 0; i < subMetricExpr.size(); ++i) {
            for (int j = 0; j < subMetricExpr.size(); ++j) {
                if (i == j) {
                    for (RefinementNode n : this.refine(new Tree<RefinementNode>(this.createNode(subMetricExpr.get(i))))) {
                        childSubMetricExpr.add(n.getMetricExpression());
                    }
                    continue;
                }
                childSubMetricExpr.add(subMetricExpr.get(i));
            }
            childMetricExpr = childMetricExpr + operator + "(" + (String)childSubMetricExpr.get(0) + "," + (String)childSubMetricExpr.get(1) + ")|0.0";
            AMapping childMap = useDisjunction ? MappingOperations.intersection(this.getMapingOfMetricExpression((String)childSubMetricExpr.get(0)), this.getMapingOfMetricExpression((String)childSubMetricExpr.get(1))) : MappingOperations.union(this.getMapingOfMetricExpression((String)childSubMetricExpr.get(0)), this.getMapingOfMetricExpression((String)childSubMetricExpr.get(1)));
            for (int k = 2; k < childSubMetricExpr.size(); ++k) {
                childMetricExpr = operator + "(" + childMetricExpr + "," + (String)childSubMetricExpr.get(k) + ")|0.0";
                childMap = MappingOperations.intersection(childMap, this.getMapingOfMetricExpression((String)childSubMetricExpr.get(k)));
            }
            result.add(this.createNode(childMap, childMetricExpr));
            childMetricExpr = "";
        }
        result.addAll(this.createDisjunctionsWithDiffNodes(node));
        return result;
    }

    private List<RefinementNode> createDisjunctionsWithDiffNodes(Tree<RefinementNode> node) {
        ArrayList<RefinementNode> result = new ArrayList<RefinementNode>();
        for (String diffExpr : this.diffs.keySet()) {
            AMapping diffMapping = this.diffs.get(diffExpr);
            String childMetricExpr = "OR(" + node.getValue().getMetricExpression() + "," + diffExpr + ")|0.0";
            AMapping nodeMaping = MappingFactory.createDefaultMapping();
            nodeMaping = RefinementNode.isSaveMapping() ? node.getValue().getMapping() : this.getMapingOfMetricExpression(node.getValue().getMetricExpression());
            AMapping childMap = MappingOperations.union(nodeMaping, diffMapping);
            result.add(this.createNode(childMap, childMetricExpr));
        }
        return result;
    }

    private boolean isRoot(String nodeMetricExpr) {
        return false;
    }

    private List<String> getSubMetricExpressions(String metricExpr) {
        ArrayList<String> result = new ArrayList<String>();
        double threshold = Double.parseDouble(metricExpr.substring(metricExpr.lastIndexOf("|") + 1, metricExpr.length()));
        String metric = metricExpr.substring(0, metricExpr.lastIndexOf("|"));
        Parser p = new Parser(metric, threshold);
        result.add(p.getLeftTerm() + "|" + p.getLeftCoefficient());
        result.add(p.getRightTerm() + "|" + p.getRightCoefficient());
        return result;
    }

    private List<RefinementNode> createConjunctionsWithDiffNodes(Tree<RefinementNode> node) {
        ArrayList<RefinementNode> result = new ArrayList<RefinementNode>();
        for (String diffExpr : this.diffs.keySet()) {
            AMapping diffMapping = this.diffs.get(diffExpr);
            AMapping nodeMaping = MappingFactory.createDefaultMapping();
            nodeMaping = RefinementNode.isSaveMapping() ? node.getValue().getMapping() : this.getMapingOfMetricExpression(node.getValue().getMetricExpression());
            String childMetricExpr = "AND(" + node.getValue().getMetricExpression() + "," + diffExpr + ")|0.0";
            AMapping childMap = MappingOperations.intersection(nodeMaping, diffMapping);
            result.add(this.createNode(childMap, childMetricExpr));
        }
        return result;
    }

    private boolean inRefinementTree(String metricExpression) {
        return this.inRefinementTree(metricExpression, this.refinementTreeRoot);
    }

    private boolean inRefinementTree(String metricExpression, Tree<RefinementNode> treeRoot) {
        if (treeRoot == null) {
            return false;
        }
        if (treeRoot.getValue().getMetricExpression().equals(metricExpression)) {
            return true;
        }
        if (treeRoot.getchildren() != null) {
            for (Tree<RefinementNode> n : treeRoot.getchildren()) {
                if (!this.inRefinementTree(metricExpression, n)) continue;
                return true;
            }
        }
        return false;
    }

    private void createRefinementTreeRoot() {
        RefinementNode initialNode = new RefinementNode(-1.7976931348623157E308, MappingFactory.createDefaultMapping(), "");
        this.refinementTreeRoot = new Tree<RefinementNode>(null, initialNode, null);
        for (String diffExpr : this.diffs.keySet()) {
            AMapping diffMapping = this.diffs.get(diffExpr);
            RefinementNode n = this.createNode(diffMapping, diffExpr);
            this.refinementTreeRoot.addChild(new Tree<RefinementNode>(this.refinementTreeRoot, n, null));
        }
        if (this.isVerbose()) {
            System.out.println("Tree size:" + this.refinementTreeRoot.size());
            this.refinementTreeRoot.print();
        }
    }

    public double computeMaxRecall(List<ExtendedClassifier> classifiers) {
        AMapping unionMaping = classifiers.get(0).getMapping();
        for (int i = 1; i < classifiers.size(); ++i) {
            unionMaping = MappingOperations.union(unionMaping, classifiers.get(i).getMapping());
        }
        return this.recall(unionMaping);
    }

    private boolean isDisjunction(String l) {
        return l.startsWith("OR");
    }

    private boolean isConjunction(String l) {
        return l.startsWith("AND");
    }

    private boolean isDifference(String l) {
        return l.startsWith("MINUS");
    }

    private boolean isAtomic(String l) {
        return !this.isDifference(l) && !this.isConjunction(l) && !this.isDisjunction(l);
    }

    @Override
    protected MLResults activeLearn() throws UnsupportedMLImplementationException {
        throw new UnsupportedMLImplementationException(this.getName());
    }
}

