/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.exceptions.NotYetImplementedException;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.eagle.core.ALDecider;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionFitnessFunction;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionProblem;
import org.aksw.limes.core.ml.algorithm.eagle.core.IGPFitnessFunction;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.aksw.limes.core.ml.algorithm.eagle.core.PseudoFMeasureFitnessFunction;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.aksw.limes.core.ml.algorithm.eagle.util.TerminationCriteria;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

public class Eagle
extends ACoreMLAlgorithm {
    private IGPProgram allBest = null;
    private IGPFitnessFunction fitness;
    private GPGenotype gp;
    private int turn = 0;
    private List<IGPProgram> bestSolutions = new LinkedList<IGPProgram>();
    private ALDecider alDecider = new ALDecider();
    private List<LinkSpecification> specifications;
    protected static final String ALGORITHM_NAME = "Eagle";
    public static final String GENERATIONS = "generations";
    public static final String PRESERVE_FITTEST = "preserve_fittest";
    public static final String MAX_DURATION = "max_duration";
    public static final String INQUIRY_SIZE = "inquiry_size";
    public static final String MAX_ITERATIONS = "max_iterations";
    public static final String MAX_QUALITY = "max_quality";
    public static final String TERMINATION_CRITERIA = "termination_criteria";
    public static final String TERMINATION_CRITERIA_VALUE = "termination_criteria_value";
    public static final String BETA = "beta";
    public static final String POPULATION = "population";
    public static final String MUTATION_RATE = "mutation_rate";
    public static final String REPRODUCTION_RATE = "reproduction_rate";
    public static final String CROSSOVER_RATE = "crossover_rate";
    public static final String PSEUDO_FMEASURE = "pseudo_fmeasure";
    public static final String MEASURE = "measure";
    public static final String PROPERTY_MAPPING = "property_mapping";
    protected static Logger logger = Logger.getLogger(Eagle.class);

    protected Eagle() {
        this.setDefaultParameters();
    }

    @Override
    protected String getName() {
        return ALGORITHM_NAME;
    }

    @Override
    protected void init(List<LearningParameter> lp, ACache source, ACache target) {
        super.init(lp, source, target);
        this.turn = 0;
        this.bestSolutions = new LinkedList<IGPProgram>();
    }

    @Override
    protected MLResults learn(AMapping trainingData) {
        try {
            this.setUp(trainingData);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            return null;
        }
        ++this.turn;
        this.fitness.addToReference(this.extractPositiveMatches(trainingData));
        this.fitness.fillCachesIncrementally(trainingData);
        Integer nGen = (Integer)this.getParameter(GENERATIONS);
        for (int gen = 1; gen <= nGen; ++gen) {
            this.gp.evolve();
            this.bestSolutions.add(this.determineFittest(this.gp, gen));
        }
        MLResults result = this.createSupervisedResult();
        return result;
    }

    @Override
    protected MLResults learn(PseudoFMeasure pfm) {
        this.learningParameters.add(new LearningParameter(PSEUDO_FMEASURE, pfm, PseudoFMeasure.class, Double.NaN, Double.NaN, Double.NaN, PSEUDO_FMEASURE));
        try {
            this.setUp(null);
        }
        catch (InvalidConfigurationException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        Integer nGen = (Integer)this.getParameter(GENERATIONS);
        this.specifications = new LinkedList<LinkSpecification>();
        logger.info((Object)"Start learning");
        for (int gen = 1; gen <= nGen; ++gen) {
            this.gp.evolve();
            IGPProgram currentBest = this.determineFittestUnsup(this.gp, gen);
            LinkSpecification currentBestMetric = this.getLinkSpecification(currentBest);
            this.specifications.add(currentBestMetric);
        }
        this.allBest = this.determineFittestUnsup(this.gp, nGen);
        return this.createUnsupervisedResult();
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        return this.fitness.getMapping(source, target, mlModel.getLinkSpecification());
    }

    @Override
    protected boolean supports(MLImplementationType mlType) {
        return mlType == MLImplementationType.SUPERVISED_BATCH || mlType == MLImplementationType.UNSUPERVISED || mlType == MLImplementationType.SUPERVISED_ACTIVE;
    }

    @Override
    protected AMapping getNextExamples(int size) throws UnsupportedMLImplementationException {
        return this.calculateOracleQuestions(size);
    }

    @Override
    protected MLResults activeLearn(AMapping oracleMapping) throws UnsupportedMLImplementationException {
        logger.info((Object)("EAGLE active learning started with " + oracleMapping.size() + " examples"));
        return this.learn(oracleMapping);
    }

    @Override
    protected MLResults activeLearn() throws UnsupportedMLImplementationException {
        logger.info((Object)"Supposed to run an active EAGLE, but provided no oracle data. Running default unsupervised approach instead.");
        return this.learn(new PseudoFMeasure());
    }

    @Override
    public void setDefaultParameters() {
        this.learningParameters = new ArrayList();
        this.learningParameters.add(new LearningParameter(GENERATIONS, 20, Integer.class, 1.0, 2.147483647E9, 1.0, GENERATIONS));
        this.learningParameters.add(new LearningParameter(PRESERVE_FITTEST, true, Boolean.class, Double.NaN, Double.NaN, Double.NaN, PRESERVE_FITTEST));
        this.learningParameters.add(new LearningParameter(MAX_DURATION, 60, Long.class, 0.0, 9.223372036854776E18, 1.0, MAX_DURATION));
        this.learningParameters.add(new LearningParameter(INQUIRY_SIZE, 10, Integer.class, 1.0, 2.147483647E9, 1.0, INQUIRY_SIZE));
        this.learningParameters.add(new LearningParameter(MAX_ITERATIONS, 500, Integer.class, 1.0, 2.147483647E9, 1.0, MAX_ITERATIONS));
        this.learningParameters.add(new LearningParameter(MAX_QUALITY, 0.5, Double.class, 0.0, 1.0, Double.NaN, MAX_QUALITY));
        this.learningParameters.add(new LearningParameter(TERMINATION_CRITERIA, (Object)TerminationCriteria.iteration, TerminationCriteria.class, Double.NaN, Double.NaN, Double.NaN, TERMINATION_CRITERIA));
        this.learningParameters.add(new LearningParameter(TERMINATION_CRITERIA_VALUE, 0.0, Double.class, 0.0, Double.MAX_VALUE, Double.NaN, TERMINATION_CRITERIA_VALUE));
        this.learningParameters.add(new LearningParameter(BETA, 1.0, Double.class, 0.0, 1.0, Double.NaN, BETA));
        this.learningParameters.add(new LearningParameter(POPULATION, 20, Integer.class, 1.0, 2.147483647E9, 1.0, POPULATION));
        this.learningParameters.add(new LearningParameter(MUTATION_RATE, Float.valueOf(0.4f), Float.class, 0.0, 1.0, Double.NaN, MUTATION_RATE));
        this.learningParameters.add(new LearningParameter(REPRODUCTION_RATE, Float.valueOf(0.4f), Float.class, 0.0, 1.0, Double.NaN, REPRODUCTION_RATE));
        this.learningParameters.add(new LearningParameter(CROSSOVER_RATE, Float.valueOf(0.3f), Float.class, 0.0, 1.0, Double.NaN, CROSSOVER_RATE));
        this.learningParameters.add(new LearningParameter(MEASURE, new FMeasure(), IQualitativeMeasure.class, Double.NaN, Double.NaN, Double.NaN, MEASURE));
        this.learningParameters.add(new LearningParameter(PSEUDO_FMEASURE, new PseudoFMeasure(), IQualitativeMeasure.class, Double.NaN, Double.NaN, Double.NaN, MEASURE));
        this.learningParameters.add(new LearningParameter(PROPERTY_MAPPING, new PropertyMapping(), PropertyMapping.class, Double.NaN, Double.NaN, Double.NaN, PROPERTY_MAPPING));
    }

    private void setUp(AMapping trainingData) throws InvalidConfigurationException {
        PropertyMapping pm = (PropertyMapping)this.getParameter(PROPERTY_MAPPING);
        if (!pm.wasSet()) {
            pm.setDefault(this.configuration.getSourceInfo(), this.configuration.getTargetInfo());
        }
        LinkSpecGeneticLearnerConfig jgapConfig = new LinkSpecGeneticLearnerConfig(this.configuration.getSourceInfo(), this.configuration.getTargetInfo(), pm);
        jgapConfig.sC = this.sourceCache;
        jgapConfig.tC = this.targetCache;
        jgapConfig.setPopulationSize((Integer)this.getParameter(POPULATION));
        jgapConfig.setCrossoverProb(((Float)this.getParameter(CROSSOVER_RATE)).floatValue());
        jgapConfig.setMutationProb(((Float)this.getParameter(MUTATION_RATE)).floatValue());
        jgapConfig.setPreservFittestIndividual((Boolean)this.getParameter(PRESERVE_FITTEST));
        jgapConfig.setReproductionProb(((Float)this.getParameter(REPRODUCTION_RATE)).floatValue());
        jgapConfig.setPropertyMapping(pm);
        if (trainingData != null) {
            FMeasure fm = (FMeasure)this.getParameter(MEASURE);
            this.fitness = ExpressionFitnessFunction.getInstance(jgapConfig, fm, trainingData);
            Configuration.reset();
            jgapConfig.setFitnessFunction(this.fitness);
        } else {
            PseudoFMeasure pfm = (PseudoFMeasure)this.getParameter(PSEUDO_FMEASURE);
            this.fitness = PseudoFMeasureFitnessFunction.getInstance(jgapConfig, pfm, this.sourceCache, this.targetCache);
            Configuration.reset();
            jgapConfig.setFitnessFunction(this.fitness);
        }
        ExpressionProblem gpP = new ExpressionProblem(jgapConfig);
        this.gp = gpP.create();
    }

    private AMapping extractPositiveMatches(AMapping trainingData) {
        AMapping positives = MappingFactory.createDefaultMapping();
        for (String sUri : trainingData.getMap().keySet()) {
            for (String tUri : trainingData.getMap().get(sUri).keySet()) {
                double confidence = trainingData.getConfidence(sUri, tUri);
                if (!(confidence > 0.0)) continue;
                positives.add(sUri, tUri, confidence);
            }
        }
        return positives;
    }

    private IGPProgram determineFittest(GPGenotype gp, int gen) {
        double fitM;
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), pop.getGPProgram(0)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        if (bestHere == null) {
            logger.debug((Object)"Determining best program failed, consider the whole population");
            for (IGPProgram p : pop.getGPPrograms()) {
                if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
                fittest = fitM;
                bestHere = p;
            }
        }
        if (((Boolean)this.getParameter(PRESERVE_FITTEST)).booleanValue() && (this.allBest == null || this.fitness.calculateRawFitness(this.allBest) > fittest)) {
            this.allBest = bestHere;
            logger.info((Object)("Generation " + gen + " new fittest (" + fittest + ") individual: " + this.getLinkSpecification(bestHere)));
        }
        return bestHere;
    }

    private LinkSpecification getLinkSpecification(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (LinkSpecification)pc.getNode(0).execute_object(pc, 0, args);
    }

    private MLResults createSupervisedResult() {
        MLResults result = new MLResults();
        result.setMapping(this.fitness.getMapping(this.sourceCache, this.targetCache, this.getLinkSpecification(this.allBest)));
        result.setLinkSpecification(this.getLinkSpecification(this.allBest));
        result.setQuality(this.allBest.getFitnessValue());
        result.addDetail("specifiactions", this.bestSolutions);
        return result;
    }

    private MLResults createUnsupervisedResult() {
        MLResults result = new MLResults();
        result.setMapping(this.fitness.getMapping(this.sourceCache, this.targetCache, this.getLinkSpecification(this.allBest)));
        result.setLinkSpecification(this.getLinkSpecification(this.allBest));
        result.setQuality(this.allBest.getFitnessValue());
        result.addDetail("specifiactions", this.specifications);
        return result;
    }

    private AMapping calculateOracleQuestions(int size) {
        logger.info((Object)"Getting mappings for output");
        GPPopulation pop = this.gp.getGPPopulation();
        pop.sortByFitness();
        HashSet<LinkSpecification> metrics = new HashSet<LinkSpecification>();
        LinkedList<AMapping> candidateMaps = new LinkedList<AMapping>();
        metrics.add(this.getLinkSpecification(this.allBest));
        for (IGPProgram p : pop.getGPPrograms()) {
            LinkSpecification m = this.getLinkSpecification(p);
            if (m == null || metrics.contains(m)) continue;
            metrics.add(m);
        }
        if (metrics.size() <= 1) {
            throw new NotYetImplementedException("Fallback solution if we have too less candidates.");
        }
        logger.info((Object)("Getting " + metrics.size() + " full mappings to determine controversy matches..."));
        for (LinkSpecification m : metrics) {
            candidateMaps.add(this.fitness.getMapping(this.sourceCache, this.targetCache, m));
        }
        logger.info((Object)("Getting " + size + " controversy match candidates from " + candidateMaps.size() + " maps..."));
        List<ALDecider.Triple> controversyMatches = this.alDecider.getControversyCandidates(candidateMaps, size);
        AMapping answer = MappingFactory.createDefaultMapping();
        for (ALDecider.Triple t : controversyMatches) {
            answer.add(t.getSourceUri(), t.getTargetUri(), t.getSimilarity());
        }
        return answer;
    }

    private IGPProgram determineFittestUnsup(GPGenotype gp, int gen) {
        double fitM;
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), pop.getGPProgram(0)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        if (bestHere == null) {
            logger.debug((Object)"Determining best program failed, consider the whole population.");
            for (IGPProgram p : pop.getGPPrograms()) {
                if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
                fittest = fitM;
                bestHere = p;
            }
        }
        if (((Boolean)this.getParameter(PRESERVE_FITTEST)).booleanValue() && (this.allBest == null || this.fitness.calculateRawFitness(this.allBest) > fittest)) {
            this.allBest = bestHere;
            logger.info((Object)("Generation " + gen + " new fittest (" + fittest + ") individual: " + this.getLinkSpecification(bestHere)));
        }
        return bestHere;
    }

    public int getTurn() {
        return this.turn;
    }
}

