/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.LinkedList;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.ITrieFilterableStringMeasure;
import org.aksw.limes.core.measures.measure.string.StringMeasure;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class RatcliffObershelpMeasure
extends StringMeasure
implements ITrieFilterableStringMeasure {
    private int score;

    @Override
    public double characterFrequencyUpperBound(int l1, int l2, int m) {
        return 2.0 * (double)m / ((double)l1 + (double)l2);
    }

    @Override
    public int characterMatchLowerBound(int l1, int l2, double threshold) {
        return (int)Math.round(Math.ceil(threshold * (double)(l1 + l2) / 2.0));
    }

    @Override
    public int lengthLowerBound(int l1, double threshold) {
        return (int)Math.round(Math.ceil(threshold / (2.0 - threshold) * (double)l1));
    }

    @Override
    public int lengthUpperBound(int l1, double threshold) {
        return (int)Math.round(Math.floor((2.0 - threshold) / threshold * (double)l1));
    }

    @Override
    public LinkedList<ImmutableTriple<Integer, Integer, Integer>> getPartitionBounds(int maxSize, double threshold) {
        LinkedList<ImmutableTriple<Integer, Integer, Integer>> sliceBoundaries = new LinkedList<ImmutableTriple<Integer, Integer, Integer>>();
        for (int t = 1; t <= maxSize; ++t) {
            sliceBoundaries.add((ImmutableTriple<Integer, Integer, Integer>)new ImmutableTriple((Object)t, (Object)this.lengthLowerBound(t, threshold), (Object)this.lengthUpperBound(t, threshold)));
        }
        return sliceBoundaries;
    }

    @Override
    public double proximity(String s1, String s2) {
        this.score = 0;
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        this.processRatcliffAlgorithm(s1, s2);
        return (double)this.score / (double)(s1.length() + s2.length());
    }

    private void processRatcliffAlgorithm(String s1, String s2) {
        String substring = this.findLongestSubstring(s1, s2);
        if (substring == null || substring.isEmpty()) {
            return;
        }
        this.score += 2 * substring.length();
        int index1 = s1.indexOf(substring);
        int index2 = s2.indexOf(substring);
        String rightPartS1 = s1.substring(index1 + substring.length());
        String leftPartS1 = s1.substring(0, index1);
        String rightPartS2 = s2.substring(index2 + substring.length());
        String leftPartS2 = s2.substring(0, index2);
        if (rightPartS1 != null && !rightPartS1.isEmpty() && rightPartS2 != null && !rightPartS2.isEmpty()) {
            this.processRatcliffAlgorithm(rightPartS1, rightPartS2);
        }
        if (leftPartS1 != null && !leftPartS1.isEmpty() && leftPartS2 != null && !leftPartS2.isEmpty()) {
            this.processRatcliffAlgorithm(leftPartS1, leftPartS2);
        }
    }

    private String findLongestSubstring(String s, String t) {
        StringBuilder sb = new StringBuilder();
        if (s == null || s.isEmpty() || t == null || t.isEmpty()) {
            return "";
        }
        s = s.toLowerCase();
        t = t.toLowerCase();
        int[][] num = new int[s.length()][t.length()];
        int maxlen = 0;
        int lastSubsBegin = 0;
        for (int i = 0; i < s.length(); ++i) {
            for (int j = 0; j < t.length(); ++j) {
                if (s.charAt(i) != t.charAt(j)) continue;
                num[i][j] = i == 0 || j == 0 ? 1 : 1 + num[i - 1][j - 1];
                if (num[i][j] <= maxlen) continue;
                maxlen = num[i][j];
                int thisSubsBegin = i - num[i][j] + 1;
                if (lastSubsBegin == thisSubsBegin) {
                    sb.append(s.charAt(i));
                    continue;
                }
                sb.setLength(0);
                sb.append(s.substring(thisSubsBegin, i + 1));
                lastSubsBegin = thisSubsBegin;
            }
        }
        return sb.toString();
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        return false;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return this.proximity(object1.toString(), object2.toString());
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.proximity(source, target);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "ratcliff-obershelp";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

