/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.space;

import org.aksw.limes.core.measures.measure.pointsets.GeoOrthodromicMeasure;
import org.aksw.limes.core.measures.measure.space.EuclideanMeasure;
import org.aksw.limes.core.measures.measure.space.ISpaceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceMeasureFactory {
    static Logger logger = LoggerFactory.getLogger(SpaceMeasureFactory.class);

    public static ISpaceMeasure getMeasure(String name, int dimension) {
        if (name.toLowerCase().startsWith("geo")) {
            if (dimension != 2) {
                logger.warn("Erroneous dimension settings for GeoDistance (" + dimension + ").");
            }
            return new GeoOrthodromicMeasure();
        }
        EuclideanMeasure measure = new EuclideanMeasure();
        measure.setDimension(dimension);
        return measure;
    }
}

