/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.space;

import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.space.ASpaceMeasure;

abstract class AMinkowskiMeasure
extends ASpaceMeasure {
    AMinkowskiMeasure() {
    }

    @Override
    public String getType() {
        return "spatial";
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        String[] split1 = ((String)object1).split("\\|");
        String[] split2 = ((String)object2).split("\\|");
        double distance = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            distance += this.innerPTerm(split1[i], split2[i]);
        }
        distance = this.outerPTerm(distance);
        return 1.0 / (1.0 + distance);
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String properties1, String properties2) {
        String[] p1 = properties1.split("\\|");
        String[] p2 = properties2.split("\\|");
        double distance = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double min = 2.147483647E9;
            for (String value1 : instance1.getProperty(p1[i])) {
                for (String value2 : instance2.getProperty(p2[i])) {
                    try {
                        min = Math.min(min, this.innerPTerm(value1, value2));
                    }
                    catch (Exception exception) {}
                }
            }
            distance += min;
        }
        return 1.0 / (1.0 + this.outerPTerm(distance));
    }

    abstract double outerPTerm(double var1);

    abstract double innerPTerm(String var1, String var2);
}

