/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.resourcesets;

import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.AMeasure;

public class SetJaccardMeasure
extends AMeasure {
    @Override
    public double getSimilarity(Object object1, Object object2) {
        if (object1 instanceof Set && object2 instanceof Set) {
            Set s = (Set)object1;
            Set t = (Set)object2;
            if (s.isEmpty() && t.isEmpty()) {
                return 1.0;
            }
            int matches = 0;
            for (String x : s) {
                if (!t.contains(x)) continue;
                ++matches;
            }
            return (double)matches / ((double)s.size() + (double)t.size() - (double)matches);
        }
        return 0.0;
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        TreeSet<String> object1 = instance1.getProperty(property1);
        TreeSet<String> object2 = instance2.getProperty(property2);
        return this.getSimilarity(object1, object2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "set_jaccard";
    }

    @Override
    public String getType() {
        return "resource_sets";
    }
}

