/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.hausdorff;

import java.util.Set;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.CentroidIndex;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.IndexedHausdorffMeasure;

public class CentroidIndexedHausdorffMeasure
extends IndexedHausdorffMeasure {
    public CentroidIndex sourceIndex;
    public IndexedHausdorffMeasure ih = new IndexedHausdorffMeasure();
    boolean verbose = false;

    public void computeIndexes(Set<Polygon> source, Set<Polygon> target) {
        this.sourceIndex = new CentroidIndex();
        this.sourceIndex.index(source);
        this.targetIndex = new CentroidIndex();
        this.targetIndex.index(target);
        this.ih.targetIndex = this.targetIndex;
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        this.targetIndex = new CentroidIndex();
        this.sourceIndex = new CentroidIndex();
        this.targetIndex.index(target);
        this.sourceIndex.index(source);
        this.ih.targetIndex = this.targetIndex;
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = CentroidIndexedHausdorffMeasure.pointToPointDistance(this.sourceIndex.centroids.get((Object)s.uri).center, ((CentroidIndex)this.targetIndex).centroids.get((Object)t.uri).center);
                if (!(d - (this.sourceIndex.centroids.get((Object)s.uri).radius + ((CentroidIndex)this.targetIndex).centroids.get((Object)t.uri).radius) <= threshold) || !((d = this.computeDistance(s, t, threshold)) <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        double d = CentroidIndexedHausdorffMeasure.pointToPointDistance(this.sourceIndex.centroids.get((Object)X.uri).center, ((CentroidIndex)this.targetIndex).centroids.get((Object)Y.uri).center);
        if (d - (this.sourceIndex.centroids.get((Object)X.uri).radius + ((CentroidIndex)this.targetIndex).centroids.get((Object)Y.uri).radius) > threshold) {
            return threshold + 1.0;
        }
        return this.ih.computeDistance(X, Y, threshold);
    }
}

