/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.frechet;

import fr.ign.cogit.geoxygene.api.spatial.coordgeom.IDirectPosition;
import fr.ign.cogit.geoxygene.api.spatial.coordgeom.ILineSegment;
import fr.ign.cogit.geoxygene.api.spatial.coordgeom.ILineString;
import fr.ign.cogit.geoxygene.spatial.coordgeom.DirectPosition;
import fr.ign.cogit.geoxygene.spatial.coordgeom.GM_LineSegment;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.frechet.OrthodromicFrechetDistance;

public class GeOxygeneFrechetMeasure
extends APointsetsMeasure {
    public GeOxygeneFrechetMeasure() {
        computations = 0;
    }

    public static ILineSegment toLineSegment(Polygon poly) {
        double pLat = poly.points.get((int)0).coordinates.get(0);
        double pLong = poly.points.get((int)0).coordinates.get(1);
        double qLat = poly.points.get((int)(poly.points.size() - 1)).coordinates.get(0);
        double qLong = poly.points.get((int)(poly.points.size() - 1)).coordinates.get(1);
        GM_LineSegment lineSegment = new GM_LineSegment((IDirectPosition)new DirectPosition(pLat, pLong), (IDirectPosition)new DirectPosition(qLat, qLong));
        for (int i = 1; i < poly.points.size() - 1; ++i) {
            double lat = poly.points.get((int)i).coordinates.get(0);
            double lon = poly.points.get((int)i).coordinates.get(1);
            lineSegment.addControlPoint((IDirectPosition)new DirectPosition(lat, lon));
        }
        return lineSegment;
    }

    public static double distance(Polygon X, Polygon Y, double threshold) {
        return new GeOxygeneFrechetMeasure().computeDistance(X, Y, threshold);
    }

    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        double f = OrthodromicFrechetDistance.discreteFrechet((ILineString)GeOxygeneFrechetMeasure.toLineSegment(X), (ILineString)GeOxygeneFrechetMeasure.toLineSegment(Y));
        return f;
    }

    @Override
    public int getComputations() {
        return computations;
    }

    @Override
    public String getName() {
        return "GeOxygeneFrechet";
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = this.computeDistance(s, t, threshold);
                if (!(d <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    @Override
    public String getType() {
        return "geodistance";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        TreeSet<String> source = instance1.getProperty(property1);
        TreeSet<String> target = instance2.getProperty(property2);
        HashSet<Polygon> sourcePolygons = new HashSet<Polygon>();
        HashSet<Polygon> targetPolygons = new HashSet<Polygon>();
        for (String s : source) {
            sourcePolygons.add(OrchidMapper.getPolygon(s));
        }
        for (String t : target) {
            targetPolygons.add(OrchidMapper.getPolygon(t));
        }
        double min = Double.MAX_VALUE;
        double d = 0.0;
        for (Polygon p1 : sourcePolygons) {
            for (Polygon p2 : targetPolygons) {
                d = this.computeDistance(p1, p2, 0.0);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return 1.0 / (1.0 + d);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

