/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets;

import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.space.ASpaceMeasure;

public class GeoGreatEllipticMeasure
extends ASpaceMeasure {
    public static double getDistanceInDegrees(Point x, Point y) {
        return GeoGreatEllipticMeasure.getDistanceInDegrees(x.coordinates.get(0), x.coordinates.get(1), y.coordinates.get(0), y.coordinates.get(1));
    }

    public static double getDistanceInDegrees(double lat1, double long1, double lat2, double long2) {
        double la1 = Math.toRadians(lat1);
        double lo1 = Math.toRadians(long1);
        double la2 = Math.toRadians(lat2);
        double lo2 = Math.toRadians(long2);
        return GeoGreatEllipticMeasure.getDistance(la1, lo1, la2, lo2);
    }

    public static double getDistance(double lat1, double long1, double lat2, double long2) {
        double lambdaP;
        double cos2SigmaM;
        double cosLambda;
        double cosSigma;
        double sigma;
        double sinSigma;
        double sinLambda;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double a = 6378137.0;
        double b = 6356752.314245;
        double f = 0.0033528106647474805;
        double L = long2 - long1;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        do {
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) != 0.0) continue;
            return 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * (cosSqAlpha = 1.0 - (sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma) * sinAlpha) * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda)) + C * sinSigma * ((cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha) + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return 0.0;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double s = b * A * (sigma - deltaSigma);
        return s / 1000.0;
    }

    @Override
    public double getThreshold(int dimension, double simThreshold) {
        return (1.0 - simThreshold) / (radius * simThreshold);
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        String[] p1 = ((String)object1).split("\\|");
        String[] p2 = ((String)object2).split("\\|");
        double lat1 = Double.parseDouble(p1[0]);
        double lon1 = Double.parseDouble(p1[1]);
        double lat2 = Double.parseDouble(p1[0]);
        double lon2 = Double.parseDouble(p2[1]);
        return GeoGreatEllipticMeasure.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double lat2;
        double lon2;
        double lat1;
        double lon1;
        String[] p1 = property1.split("\\|");
        String[] p2 = property1.split("\\|");
        if (p1[0].toLowerCase().startsWith("lo")) {
            lon1 = Double.parseDouble(instance1.getProperty(p1[0]).first());
            lat1 = Double.parseDouble(instance1.getProperty(p1[1]).first());
        } else {
            lat1 = Double.parseDouble(instance1.getProperty(p1[0]).first());
            lon1 = Double.parseDouble(instance1.getProperty(p1[1]).first());
        }
        if (p2[0].toLowerCase().startsWith("lo")) {
            lon2 = Double.parseDouble(instance1.getProperty(p2[0]).first());
            lat2 = Double.parseDouble(instance1.getProperty(p2[1]).first());
        } else {
            lat2 = Double.parseDouble(instance1.getProperty(p2[0]).first());
            lon2 = Double.parseDouble(instance1.getProperty(p2[1]).first());
        }
        return GeoGreatEllipticMeasure.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "GeoGreatEllipticMeasure";
    }

    @Override
    public String getType() {
        return "spatial";
    }
}

